/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

public class ModuleShardConfiguration {
    private final XMLNamespace namespace;
    private final String moduleName;
    private final String shardName;
    private final String shardStrategyName;
    private final Collection<MemberName> shardMemberNames;

    public ModuleShardConfiguration(@NonNull XMLNamespace namespace, @NonNull String moduleName, @NonNull String shardName, @Nullable String shardStrategyName, @NonNull Collection<MemberName> shardMemberNames) {
        this.namespace = Objects.requireNonNull(namespace, "nameSpace should not be null");
        this.moduleName = Objects.requireNonNull(moduleName, "moduleName should not be null");
        this.shardName = Objects.requireNonNull(shardName, "shardName should not be null");
        this.shardStrategyName = shardStrategyName;
        this.shardMemberNames = Objects.requireNonNull(shardMemberNames, "shardMemberNames");
    }

    public XMLNamespace getNamespace() {
        return this.namespace;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getShardName() {
        return this.shardName;
    }

    public String getShardStrategyName() {
        return this.shardStrategyName;
    }

    public Collection<MemberName> getShardMemberNames() {
        return this.shardMemberNames;
    }

    public String toString() {
        return "ModuleShardConfiguration [namespace=" + this.namespace + ", moduleName=" + this.moduleName + ", shardName=" + this.shardName + ", shardMemberNames=" + this.shardMemberNames + ", shardStrategyName=" + this.shardStrategyName + "]";
    }
}

