/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;

abstract class AbstractDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final ModificationType type;

    protected AbstractDataTreeCandidateNode(ModificationType type) {
        this.type = Objects.requireNonNull(type);
    }

    public final Optional<DataTreeCandidateNode> getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public final ModificationType getModificationType() {
        return this.type;
    }

    public final Optional<NormalizedNode> getDataBefore() {
        throw new UnsupportedOperationException("Before-image not available after serialization");
    }

    static DataTreeCandidateNode createUnmodified() {
        return new AbstractDataTreeCandidateNode(ModificationType.UNMODIFIED){

            public YangInstanceIdentifier.PathArgument getIdentifier() {
                throw new UnsupportedOperationException("Root node does not have an identifier");
            }

            public Optional<NormalizedNode> getDataAfter() {
                throw new UnsupportedOperationException("After-image not available after serialization");
            }

            public Collection<DataTreeCandidateNode> getChildNodes() {
                throw new UnsupportedOperationException("Children not available after serialization");
            }
        };
    }
}

