/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.concepts.WritableObjects;

public final class FrontendHistoryMetadata
implements WritableObject {
    private final RangeSet<UnsignedLong> purgedTransactions;
    private final Map<UnsignedLong, Boolean> closedTransactions;
    private final long historyId;
    private final long cookie;
    private final boolean closed;

    public FrontendHistoryMetadata(long historyId, long cookie, boolean closed, Map<UnsignedLong, Boolean> closedTransactions, RangeSet<UnsignedLong> purgedTransactions) {
        this.historyId = historyId;
        this.cookie = cookie;
        this.closed = closed;
        this.closedTransactions = ImmutableMap.copyOf(closedTransactions);
        this.purgedTransactions = ImmutableRangeSet.copyOf(purgedTransactions);
    }

    public long getHistoryId() {
        return this.historyId;
    }

    public long getCookie() {
        return this.cookie;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Map<UnsignedLong, Boolean> getClosedTransactions() {
        return this.closedTransactions;
    }

    public RangeSet<UnsignedLong> getPurgedTransactions() {
        return this.purgedTransactions;
    }

    public void writeTo(DataOutput out) throws IOException {
        WritableObjects.writeLongs((DataOutput)out, (long)this.historyId, (long)this.cookie);
        out.writeBoolean(this.closed);
        Set purgedRanges = this.purgedTransactions.asRanges();
        WritableObjects.writeLongs((DataOutput)out, (long)this.closedTransactions.size(), (long)purgedRanges.size());
        for (Map.Entry<UnsignedLong, Boolean> e : this.closedTransactions.entrySet()) {
            WritableObjects.writeLong((DataOutput)out, (long)e.getKey().longValue());
            out.writeBoolean(e.getValue());
        }
        for (Range r : purgedRanges) {
            WritableObjects.writeLongs((DataOutput)out, (long)((UnsignedLong)r.lowerEndpoint()).longValue(), (long)((UnsignedLong)r.upperEndpoint()).longValue());
        }
    }

    public static FrontendHistoryMetadata readFrom(DataInput in) throws IOException {
        byte header = WritableObjects.readLongHeader((DataInput)in);
        long historyId = WritableObjects.readFirstLong((DataInput)in, (byte)header);
        long cookie = WritableObjects.readSecondLong((DataInput)in, (byte)header);
        boolean closed = in.readBoolean();
        header = WritableObjects.readLongHeader((DataInput)in);
        long ls = WritableObjects.readFirstLong((DataInput)in, (byte)header);
        Verify.verify((ls >= 0L && ls <= Integer.MAX_VALUE ? 1 : 0) != 0);
        int csize = (int)ls;
        ls = WritableObjects.readSecondLong((DataInput)in, (byte)header);
        Verify.verify((ls >= 0L && ls <= Integer.MAX_VALUE ? 1 : 0) != 0);
        int psize = (int)ls;
        HashMap<UnsignedLong, Boolean> closedTransactions = new HashMap<UnsignedLong, Boolean>(csize);
        for (int i = 0; i < csize; ++i) {
            UnsignedLong key = UnsignedLong.fromLongBits((long)WritableObjects.readLong((DataInput)in));
            Boolean value = in.readBoolean();
            closedTransactions.put(key, value);
        }
        TreeRangeSet purgedTransactions = TreeRangeSet.create();
        for (int i = 0; i < psize; ++i) {
            byte h = WritableObjects.readLongHeader((DataInput)in);
            UnsignedLong l = UnsignedLong.fromLongBits((long)WritableObjects.readFirstLong((DataInput)in, (byte)h));
            UnsignedLong u = UnsignedLong.fromLongBits((long)WritableObjects.readSecondLong((DataInput)in, (byte)h));
            purgedTransactions.add(Range.closed((Comparable)l, (Comparable)u));
        }
        return new FrontendHistoryMetadata(historyId, cookie, closed, closedTransactions, (RangeSet<UnsignedLong>)purgedTransactions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrontendHistoryMetadata.class).add("historyId", this.historyId).add("cookie", this.cookie).add("closed", this.closed).add("closedTransactions", this.closedTransactions).add("purgedTransactions", this.purgedTransactions).toString();
    }
}

