/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ShardManagerSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> shardList;

    public ShardManagerSnapshot(@NonNull List<String> shardList) {
        this.shardList = ImmutableList.copyOf(shardList);
    }

    public List<String> getShardList() {
        return this.shardList;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return "ShardManagerSnapshot [ShardList = " + this.shardList + " ]";
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShardManagerSnapshot snapshot;

        public Proxy() {
        }

        Proxy(ShardManagerSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.snapshot.shardList.size());
            for (String shard : this.snapshot.shardList) {
                out.writeObject(shard);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ArrayList<String> localShardList = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                localShardList.add((String)in.readObject());
            }
            this.snapshot = new ShardManagerSnapshot(localShardList);
        }

        private Object readResolve() {
            return this.snapshot;
        }
    }
}

