/*
 * Copyright (c) 2016 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.yangtools.concepts.Identifiable;

/**
 * Client interface for interacting with the frontend actor. This interface is the primary access point through
 * which the DistributedDataStore frontend interacts with backend Shards.
 *
 * <p>
 * Keep this interface as clean as possible, as it needs to be implemented in thread-safe and highly-efficient manner.
 *
 * @author Robert Varga
 */
@Beta
@NonNullByDefault
public interface DataStoreClient extends Identifiable<ClientIdentifier>, AutoCloseable {
    @Override
    void close();

    /**
     * Create a new local history. ClientLocalHistory represents the interface exposed to the client.
     *
     * @return Client history handle
     */
    ClientLocalHistory createLocalHistory();

    /**
     * Create a new free-standing snapshot.
     *
     * @return Client snapshot handle
     */
    ClientSnapshot createSnapshot();

    /**
     * Create a new free-standing transaction.
     *
     * @return Client transaction handle
     */
    ClientTransaction createTransaction();
}
