package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>distributed-datastore-provider</b>
 * <pre>
 * container data-store-properties-container {
 *   uses data-store-properties;
 * }
 * </pre>
 * <p>To create instances of this class use {@link DataStorePropertiesContainerBuilder}.
 * @see DataStorePropertiesContainerBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface DataStorePropertiesContainer
    extends
    ChildOf<DistributedDatastoreProviderData>,
    Augmentable<DataStorePropertiesContainer>,
    DataStoreProperties
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("data-store-properties-container");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.@NonNull DataStorePropertiesContainer obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBackendAlivenessTimerIntervalInSeconds());
        result = prime * result + Objects.hashCode(obj.getBoundedMailboxCapacity());
        result = prime * result + Objects.hashCode(obj.getCustomRaftPolicyImplementation());
        result = prime * result + Objects.hashCode(obj.getEnableMetricCapture());
        result = prime * result + Objects.hashCode(obj.getExportOnRecovery());
        result = prime * result + Objects.hashCode(obj.getFileBackedStreamingThresholdInMegabytes());
        result = prime * result + Objects.hashCode(obj.getFrontendNoProgressTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getFrontendRequestTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getInitialPayloadSerializedBufferCapacity());
        result = prime * result + Objects.hashCode(obj.getInitialSettleTimeoutMultiplier());
        result = prime * result + Objects.hashCode(obj.getMaximumMessageSliceSize());
        result = prime * result + Objects.hashCode(obj.getOperationTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getPersistent());
        result = prime * result + Objects.hashCode(obj.getRecoveryExportBaseDir());
        result = prime * result + Objects.hashCode(obj.getRecoverySnapshotIntervalSeconds());
        result = prime * result + Objects.hashCode(obj.getShardBatchedModificationCount());
        result = prime * result + Objects.hashCode(obj.getShardCommitQueueExpiryTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getShardElectionTimeoutFactor());
        result = prime * result + Objects.hashCode(obj.getShardHeartbeatIntervalInMillis());
        result = prime * result + Objects.hashCode(obj.getShardInitializationTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getShardIsolatedLeaderCheckIntervalInMillis());
        result = prime * result + Objects.hashCode(obj.getShardJournalRecoveryLogBatchSize());
        result = prime * result + Objects.hashCode(obj.getShardLeaderElectionTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getShardSnapshotBatchCount());
        result = prime * result + Objects.hashCode(obj.getShardSnapshotChunkSize());
        result = prime * result + Objects.hashCode(obj.getShardSnapshotDataThreshold());
        result = prime * result + Objects.hashCode(obj.getShardSnapshotDataThresholdPercentage());
        result = prime * result + Objects.hashCode(obj.getShardTransactionCommitQueueCapacity());
        result = prime * result + Objects.hashCode(obj.getShardTransactionCommitTimeoutInSeconds());
        result = prime * result + Objects.hashCode(obj.getShardTransactionIdleTimeoutInMinutes());
        result = prime * result + Objects.hashCode(obj.getSnapshotOnRootOverwrite());
        result = prime * result + Objects.hashCode(obj.getSyncIndexThreshold());
        result = prime * result + Objects.hashCode(obj.getTransactionCreationInitialRateLimit());
        result = prime * result + Objects.hashCode(obj.getTransactionDebugContextEnabled());
        result = prime * result + Objects.hashCode(obj.getUseLz4Compression());
        result = prime * result + Objects.hashCode(obj.getUseTellBasedProtocol());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.@NonNull DataStorePropertiesContainer thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBackendAlivenessTimerIntervalInSeconds(), other.getBackendAlivenessTimerIntervalInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBoundedMailboxCapacity(), other.getBoundedMailboxCapacity())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEnableMetricCapture(), other.getEnableMetricCapture())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFileBackedStreamingThresholdInMegabytes(), other.getFileBackedStreamingThresholdInMegabytes())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFrontendNoProgressTimeoutInSeconds(), other.getFrontendNoProgressTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFrontendRequestTimeoutInSeconds(), other.getFrontendRequestTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInitialPayloadSerializedBufferCapacity(), other.getInitialPayloadSerializedBufferCapacity())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInitialSettleTimeoutMultiplier(), other.getInitialSettleTimeoutMultiplier())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaximumMessageSliceSize(), other.getMaximumMessageSliceSize())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOperationTimeoutInSeconds(), other.getOperationTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPersistent(), other.getPersistent())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRecoverySnapshotIntervalSeconds(), other.getRecoverySnapshotIntervalSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardBatchedModificationCount(), other.getShardBatchedModificationCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardCommitQueueExpiryTimeoutInSeconds(), other.getShardCommitQueueExpiryTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardElectionTimeoutFactor(), other.getShardElectionTimeoutFactor())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardHeartbeatIntervalInMillis(), other.getShardHeartbeatIntervalInMillis())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardInitializationTimeoutInSeconds(), other.getShardInitializationTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardIsolatedLeaderCheckIntervalInMillis(), other.getShardIsolatedLeaderCheckIntervalInMillis())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardJournalRecoveryLogBatchSize(), other.getShardJournalRecoveryLogBatchSize())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardLeaderElectionTimeoutInSeconds(), other.getShardLeaderElectionTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardSnapshotBatchCount(), other.getShardSnapshotBatchCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardSnapshotChunkSize(), other.getShardSnapshotChunkSize())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardSnapshotDataThreshold(), other.getShardSnapshotDataThreshold())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardSnapshotDataThresholdPercentage(), other.getShardSnapshotDataThresholdPercentage())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardTransactionCommitQueueCapacity(), other.getShardTransactionCommitQueueCapacity())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardTransactionCommitTimeoutInSeconds(), other.getShardTransactionCommitTimeoutInSeconds())) {
            return false;
        }
        if (!Objects.equals(thisObj.getShardTransactionIdleTimeoutInMinutes(), other.getShardTransactionIdleTimeoutInMinutes())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSnapshotOnRootOverwrite(), other.getSnapshotOnRootOverwrite())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSyncIndexThreshold(), other.getSyncIndexThreshold())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTransactionCreationInitialRateLimit(), other.getTransactionCreationInitialRateLimit())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTransactionDebugContextEnabled(), other.getTransactionDebugContextEnabled())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUseLz4Compression(), other.getUseLz4Compression())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUseTellBasedProtocol(), other.getUseTellBasedProtocol())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCustomRaftPolicyImplementation(), other.getCustomRaftPolicyImplementation())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRecoveryExportBaseDir(), other.getRecoveryExportBaseDir())) {
            return false;
        }
        if (!Objects.equals(thisObj.getExportOnRecovery(), other.getExportOnRecovery())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.@NonNull DataStorePropertiesContainer obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DataStorePropertiesContainer");
        CodeHelpers.appendValue(helper, "backendAlivenessTimerIntervalInSeconds", obj.getBackendAlivenessTimerIntervalInSeconds());
        CodeHelpers.appendValue(helper, "boundedMailboxCapacity", obj.getBoundedMailboxCapacity());
        CodeHelpers.appendValue(helper, "customRaftPolicyImplementation", obj.getCustomRaftPolicyImplementation());
        CodeHelpers.appendValue(helper, "enableMetricCapture", obj.getEnableMetricCapture());
        CodeHelpers.appendValue(helper, "exportOnRecovery", obj.getExportOnRecovery());
        CodeHelpers.appendValue(helper, "fileBackedStreamingThresholdInMegabytes", obj.getFileBackedStreamingThresholdInMegabytes());
        CodeHelpers.appendValue(helper, "frontendNoProgressTimeoutInSeconds", obj.getFrontendNoProgressTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "frontendRequestTimeoutInSeconds", obj.getFrontendRequestTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "initialPayloadSerializedBufferCapacity", obj.getInitialPayloadSerializedBufferCapacity());
        CodeHelpers.appendValue(helper, "initialSettleTimeoutMultiplier", obj.getInitialSettleTimeoutMultiplier());
        CodeHelpers.appendValue(helper, "maximumMessageSliceSize", obj.getMaximumMessageSliceSize());
        CodeHelpers.appendValue(helper, "operationTimeoutInSeconds", obj.getOperationTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "persistent", obj.getPersistent());
        CodeHelpers.appendValue(helper, "recoveryExportBaseDir", obj.getRecoveryExportBaseDir());
        CodeHelpers.appendValue(helper, "recoverySnapshotIntervalSeconds", obj.getRecoverySnapshotIntervalSeconds());
        CodeHelpers.appendValue(helper, "shardBatchedModificationCount", obj.getShardBatchedModificationCount());
        CodeHelpers.appendValue(helper, "shardCommitQueueExpiryTimeoutInSeconds", obj.getShardCommitQueueExpiryTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "shardElectionTimeoutFactor", obj.getShardElectionTimeoutFactor());
        CodeHelpers.appendValue(helper, "shardHeartbeatIntervalInMillis", obj.getShardHeartbeatIntervalInMillis());
        CodeHelpers.appendValue(helper, "shardInitializationTimeoutInSeconds", obj.getShardInitializationTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "shardIsolatedLeaderCheckIntervalInMillis", obj.getShardIsolatedLeaderCheckIntervalInMillis());
        CodeHelpers.appendValue(helper, "shardJournalRecoveryLogBatchSize", obj.getShardJournalRecoveryLogBatchSize());
        CodeHelpers.appendValue(helper, "shardLeaderElectionTimeoutInSeconds", obj.getShardLeaderElectionTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "shardSnapshotBatchCount", obj.getShardSnapshotBatchCount());
        CodeHelpers.appendValue(helper, "shardSnapshotChunkSize", obj.getShardSnapshotChunkSize());
        CodeHelpers.appendValue(helper, "shardSnapshotDataThreshold", obj.getShardSnapshotDataThreshold());
        CodeHelpers.appendValue(helper, "shardSnapshotDataThresholdPercentage", obj.getShardSnapshotDataThresholdPercentage());
        CodeHelpers.appendValue(helper, "shardTransactionCommitQueueCapacity", obj.getShardTransactionCommitQueueCapacity());
        CodeHelpers.appendValue(helper, "shardTransactionCommitTimeoutInSeconds", obj.getShardTransactionCommitTimeoutInSeconds());
        CodeHelpers.appendValue(helper, "shardTransactionIdleTimeoutInMinutes", obj.getShardTransactionIdleTimeoutInMinutes());
        CodeHelpers.appendValue(helper, "snapshotOnRootOverwrite", obj.getSnapshotOnRootOverwrite());
        CodeHelpers.appendValue(helper, "syncIndexThreshold", obj.getSyncIndexThreshold());
        CodeHelpers.appendValue(helper, "transactionCreationInitialRateLimit", obj.getTransactionCreationInitialRateLimit());
        CodeHelpers.appendValue(helper, "transactionDebugContextEnabled", obj.getTransactionDebugContextEnabled());
        CodeHelpers.appendValue(helper, "useLz4Compression", obj.getUseLz4Compression());
        CodeHelpers.appendValue(helper, "useTellBasedProtocol", obj.getUseTellBasedProtocol());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

