/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBrokerWriteTransaction;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class AbstractDOMBrokerWriteTransactionTest {
    @Mock
    private AbstractDOMTransactionFactory<?> abstractDOMTransactionFactory;
    @Mock
    private DOMStoreWriteTransaction domStoreWriteTransaction;

    @Test
    public void readyRuntimeExceptionAndCancel() throws InterruptedException {
        RuntimeException thrown = new RuntimeException();
        ((DOMStoreWriteTransaction)Mockito.doThrow((Throwable[])new Throwable[]{thrown}).when((Object)this.domStoreWriteTransaction)).ready();
        AbstractDOMBrokerWriteTransactionTestImpl abstractDOMBrokerWriteTransactionTestImpl = new AbstractDOMBrokerWriteTransactionTestImpl();
        FluentFuture submitFuture = abstractDOMBrokerWriteTransactionTestImpl.commit();
        try {
            submitFuture.get();
            Assert.fail((String)"TransactionCommitFailedException expected");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionCommitFailedException));
            Assert.assertTrue((e.getCause().getCause() == thrown ? 1 : 0) != 0);
            abstractDOMBrokerWriteTransactionTestImpl.cancel();
        }
    }

    @Test
    public void submitRuntimeExceptionAndCancel() throws InterruptedException {
        RuntimeException thrown = new RuntimeException();
        ((AbstractDOMTransactionFactory)Mockito.doThrow((Throwable[])new Throwable[]{thrown}).when(this.abstractDOMTransactionFactory)).commit((DOMDataTreeWriteTransaction)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        AbstractDOMBrokerWriteTransactionTestImpl abstractDOMBrokerWriteTransactionTestImpl = new AbstractDOMBrokerWriteTransactionTestImpl();
        FluentFuture submitFuture = abstractDOMBrokerWriteTransactionTestImpl.commit();
        try {
            submitFuture.get();
            Assert.fail((String)"TransactionCommitFailedException expected");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionCommitFailedException));
            Assert.assertTrue((e.getCause().getCause() == thrown ? 1 : 0) != 0);
            abstractDOMBrokerWriteTransactionTestImpl.cancel();
        }
    }

    private class AbstractDOMBrokerWriteTransactionTestImpl
    extends AbstractDOMBrokerWriteTransaction<DOMStoreWriteTransaction> {
        AbstractDOMBrokerWriteTransactionTestImpl() {
            super(new Object(), Collections.emptyMap(), AbstractDOMBrokerWriteTransactionTest.this.abstractDOMTransactionFactory);
        }

        protected DOMStoreWriteTransaction createTransaction(LogicalDatastoreType key) {
            return null;
        }

        protected Collection<DOMStoreWriteTransaction> getSubtransactions() {
            return Collections.singletonList(AbstractDOMBrokerWriteTransactionTest.this.domStoreWriteTransaction);
        }
    }
}

