/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandleTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;

public class ClientTransactionTest
extends AbstractClientHandleTest<ClientTransaction> {
    private static final YangInstanceIdentifier PATH = YangInstanceIdentifier.builder().node(QName.create((String)"ns-1", (String)"node-1")).build();
    private static final ContainerNode DATA = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)PATH.getLastPathArgument().getNodeType())).build();
    @Mock
    private CursorAwareDataTreeModification modification;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Mockito.when((Object)this.getDataTreeSnapshot().newModification()).thenReturn((Object)this.modification);
        Mockito.when((Object)this.modification.readNode(PATH)).thenReturn(Optional.of(DATA));
    }

    @Override
    protected ClientTransaction createHandle(AbstractClientHistory parent) {
        return parent.createTransaction();
    }

    @Override
    protected void doHandleOperation(ClientTransaction transaction) {
        transaction.read(PATH);
    }

    @Test
    public void testExists() throws Exception {
        FluentFuture exists = ((ClientTransaction)this.getHandle()).exists(PATH);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).readNode(PATH);
        Assert.assertEquals((Object)Boolean.TRUE, TestUtils.getWithTimeout(exists));
    }

    @Test
    public void testRead() throws Exception {
        FluentFuture resultFuture = ((ClientTransaction)this.getHandle()).read(PATH);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).readNode(PATH);
        Optional result = (Optional)TestUtils.getWithTimeout(resultFuture);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)DATA, result.get());
    }

    @Test
    public void testDelete() {
        ((ClientTransaction)this.getHandle()).delete(PATH);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).delete(PATH);
    }

    @Test
    public void testMerge() {
        ((ClientTransaction)this.getHandle()).merge(PATH, (NormalizedNode)DATA);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).merge(PATH, (NormalizedNode)DATA);
    }

    @Test
    public void testWrite() {
        ((ClientTransaction)this.getHandle()).write(PATH, (NormalizedNode)DATA);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).write(PATH, (NormalizedNode)DATA);
    }

    @Test
    public void testReadyEmpty() throws Exception {
        DOMStoreThreePhaseCommitCohort cohort = ((ClientTransaction)this.getHandle()).ready();
        TestUtils.assertFutureEquals(Boolean.TRUE, cohort.canCommit());
        TestUtils.assertFutureEquals(Empty.value(), cohort.preCommit());
        TestUtils.assertFutureEquals(CommitInfo.empty(), cohort.commit());
    }

    @Test
    public void testReady() throws Exception {
        ((ClientTransaction)this.getHandle()).write(PATH, (NormalizedNode)DATA);
        DOMStoreThreePhaseCommitCohort cohort = ((ClientTransaction)this.getHandle()).ready();
        TransactionCommitSuccess response = new TransactionCommitSuccess(TestUtils.TRANSACTION_ID, 0L);
        ListenableFuture actual = cohort.canCommit();
        CommitLocalTransactionRequest request = this.backendRespondToRequest(CommitLocalTransactionRequest.class, (Response<?, ?>)response);
        Assert.assertEquals((Object)this.modification, (Object)request.getModification());
        TestUtils.assertFutureEquals(Boolean.TRUE, actual);
        TestUtils.assertFutureEquals(Empty.value(), cohort.preCommit());
        TestUtils.assertFutureEquals(CommitInfo.empty(), cohort.commit());
    }

    @Test
    public void testReadyNoFurtherOperationsAllowed() throws Exception {
        ((ClientTransaction)this.getHandle()).ready();
        this.checkClosed();
    }
}

