/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.testkit.TestActorRef;
import akka.testkit.javadsl.TestKit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListenerReply;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotification;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotifier;
import org.opendaylight.controller.cluster.notifications.RoleChanged;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.utils.MessageCollectorActor;

public class RoleChangeNotifierTest
extends AbstractActorTest {
    private TestKit testKit;

    @Before
    public void setup() {
        this.testKit = new TestKit(RoleChangeNotifierTest.getSystem());
    }

    @Test
    public void testHandleRegisterRoleChangeListener() {
        String memberId = "testHandleRegisterRoleChangeListener";
        ActorRef listenerActor = RoleChangeNotifierTest.getSystem().actorOf(MessageCollectorActor.props());
        TestActorRef notifierTestActorRef = TestActorRef.create((ActorSystem)RoleChangeNotifierTest.getSystem(), (Props)RoleChangeNotifier.getProps((String)memberId), (String)memberId);
        notifierTestActorRef.tell((Object)new RegisterRoleChangeListener(), listenerActor);
        RegisterRoleChangeListenerReply reply = (RegisterRoleChangeListenerReply)MessageCollectorActor.getFirstMatching((ActorRef)listenerActor, RegisterRoleChangeListenerReply.class);
        Assert.assertNotNull((Object)reply);
        RoleChangeNotification notification = (RoleChangeNotification)MessageCollectorActor.getFirstMatching((ActorRef)listenerActor, RoleChangeNotification.class);
        Assert.assertNull((Object)notification);
    }

    @Test
    public void testHandleRaftRoleChanged() {
        String memberId = "testHandleRegisterRoleChangeListenerWithNotificationSet";
        ActorRef listenerActor = RoleChangeNotifierTest.getSystem().actorOf(MessageCollectorActor.props());
        ActorRef shardActor = this.testKit.getTestActor();
        TestActorRef notifierTestActorRef = TestActorRef.create((ActorSystem)RoleChangeNotifierTest.getSystem(), (Props)RoleChangeNotifier.getProps((String)memberId), (String)memberId);
        notifierTestActorRef.tell((Object)new RoleChanged(memberId, RaftState.Candidate.name(), RaftState.Leader.name()), shardActor);
        Assert.assertNull((Object)MessageCollectorActor.getFirstMatching((ActorRef)listenerActor, RoleChangeNotification.class));
        notifierTestActorRef.tell((Object)new RegisterRoleChangeListener(), listenerActor);
        RegisterRoleChangeListenerReply reply = (RegisterRoleChangeListenerReply)MessageCollectorActor.getFirstMatching((ActorRef)listenerActor, RegisterRoleChangeListenerReply.class);
        Assert.assertNotNull((Object)reply);
        RoleChangeNotification notification = (RoleChangeNotification)MessageCollectorActor.getFirstMatching((ActorRef)listenerActor, RoleChangeNotification.class);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((Object)RaftState.Candidate.name(), (Object)notification.getOldRole());
        Assert.assertEquals((Object)RaftState.Leader.name(), (Object)notification.getNewRole());
    }

    @Test
    public void testHandleLeaderStateChanged() {
        String actorId = "testHandleLeaderStateChanged";
        TestActorRef notifierTestActorRef = TestActorRef.create((ActorSystem)RoleChangeNotifierTest.getSystem(), (Props)RoleChangeNotifier.getProps((String)actorId), (String)actorId);
        notifierTestActorRef.tell((Object)new LeaderStateChanged("member1", "leader1", 5), ActorRef.noSender());
        notifierTestActorRef.tell((Object)new RegisterRoleChangeListener(), this.testKit.getRef());
        this.testKit.expectMsgClass(RegisterRoleChangeListenerReply.class);
        LeaderStateChanged leaderStateChanged = (LeaderStateChanged)this.testKit.expectMsgClass(LeaderStateChanged.class);
        Assert.assertEquals((String)"getMemberId", (Object)"member1", (Object)leaderStateChanged.getMemberId());
        Assert.assertEquals((String)"getLeaderId", (Object)"leader1", (Object)leaderStateChanged.getLeaderId());
        Assert.assertEquals((String)"getLeaderPayloadVersion", (long)5L, (long)leaderStateChanged.getLeaderPayloadVersion());
        notifierTestActorRef.tell((Object)new LeaderStateChanged("member1", "leader2", 6), ActorRef.noSender());
        leaderStateChanged = (LeaderStateChanged)this.testKit.expectMsgClass(LeaderStateChanged.class);
        Assert.assertEquals((String)"getMemberId", (Object)"member1", (Object)leaderStateChanged.getMemberId());
        Assert.assertEquals((String)"getLeaderId", (Object)"leader2", (Object)leaderStateChanged.getLeaderId());
        Assert.assertEquals((String)"getLeaderPayloadVersion", (long)6L, (long)leaderStateChanged.getLeaderPayloadVersion());
    }
}

