/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.Props;
import akka.actor.Status;
import akka.actor.UntypedAbstractActor;
import akka.dispatch.Dispatchers;
import akka.dispatch.Futures;
import akka.testkit.TestActorRef;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ThreePhaseCommitCohortProxy;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransaction;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.AbstractThreePhaseCommitMessage;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.MockClusterWrapper;
import org.opendaylight.controller.cluster.datastore.utils.MockConfiguration;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.controller.cluster.raft.TestActorFactory;
import org.opendaylight.controller.cluster.raft.utils.DoNothingActor;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ThreePhaseCommitCohortProxyTest
extends AbstractActorTest {
    private ActorUtils actorUtils;
    @Mock
    private Timer commitTimer;
    @Mock
    private Timer.Context commitTimerContext;
    @Mock
    private Snapshot commitSnapshot;
    private final TestActorFactory actorFactory = new TestActorFactory(ThreePhaseCommitCohortProxyTest.getSystem());
    private final List<TestActorRef<CohortActor>> cohortActors = new ArrayList<TestActorRef<CohortActor>>();
    private final TransactionIdentifier tx = ThreePhaseCommitCohortProxyTest.nextTransactionId();

    @Before
    public void setUp() {
        this.actorUtils = new ActorUtils(ThreePhaseCommitCohortProxyTest.getSystem(), this.actorFactory.createActor(Props.create(DoNothingActor.class, (Object[])new Object[0])), new MockClusterWrapper(), (Configuration)new MockConfiguration(), DatastoreContext.newBuilder().build(), new PrimaryShardInfoFutureCache()){

            public Timer getOperationTimer(String operationName) {
                return ThreePhaseCommitCohortProxyTest.this.commitTimer;
            }

            public double getTxCreationLimit() {
                return 10.0;
            }
        };
        ((Timer)Mockito.lenient().doReturn((Object)this.commitTimerContext).when((Object)this.commitTimer)).time();
        ((Timer)Mockito.lenient().doReturn((Object)this.commitSnapshot).when((Object)this.commitTimer)).getSnapshot();
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.lenient().doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(i) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
    }

    @Test
    public void testCanCommitYesWithOneCohort() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), true);
        this.verifyCohortActors();
    }

    @Test
    public void testCanCommitNoWithOneCohort() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.no((short)12)))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), false);
        this.verifyCohortActors();
    }

    @Test
    public void testCanCommitYesWithTwoCohorts() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12))), this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), true);
        this.verifyCohortActors();
    }

    @Test
    public void testCanCommitNoWithThreeCohorts() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12))), this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.no((short)12))), this.newCohortInfo(new CohortActor.Builder(this.tx))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), false);
        this.verifyCohortActors();
    }

    @Test
    public void testCanCommitWithExceptionFailure() {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(new TestException()))), this.tx);
        this.propagateExecutionExceptionCause(proxy.canCommit(), TestException.class);
    }

    @Test
    public void testCanCommitWithInvalidResponseType() {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit("invalid"))), this.tx);
        Assert.assertEquals((Object)"Unexpected response type class java.lang.String", (Object)this.propagateExecutionExceptionCause(proxy.canCommit(), IllegalArgumentException.class));
    }

    @Test
    public void testCanCommitWithFailedCohortFuture() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx)), ThreePhaseCommitCohortProxyTest.newCohortInfoWithFailedFuture(new TestException()), this.newCohortInfo(new CohortActor.Builder(this.tx))), this.tx);
        this.propagateExecutionExceptionCause(proxy.canCommit(), TestException.class);
    }

    @Test
    public void testAllThreePhasesSuccessful() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)).expectCommit(CommitTransactionReply.instance((short)12))), this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)).expectCommit(CommitTransactionReply.instance((short)12)))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), true);
        this.verifySuccessfulFuture(proxy.preCommit());
        this.verifySuccessfulFuture(proxy.commit());
        this.verifyCohortActors();
    }

    @Test
    public void testCommitWithExceptionFailure() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)).expectCommit(CommitTransactionReply.instance((short)12))), this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)).expectCommit(new TestException()))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), true);
        this.verifySuccessfulFuture(proxy.preCommit());
        this.propagateExecutionExceptionCause(proxy.commit(), TestException.class);
    }

    @Test
    public void testCommitWithInvalidResponseType() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectCanCommit(CanCommitTransactionReply.yes((short)12)).expectCommit("invalid"))), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), true);
        this.verifySuccessfulFuture(proxy.preCommit());
        Assert.assertEquals((Object)"Unexpected response type class java.lang.String", (Object)this.propagateExecutionExceptionCause(proxy.commit(), IllegalArgumentException.class));
    }

    @Test
    public void testAbort() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectAbort(AbortTransactionReply.instance((short)12)))), this.tx);
        this.verifySuccessfulFuture(proxy.abort());
        this.verifyCohortActors();
    }

    @Test
    public void testAbortWithFailure() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(this.newCohortInfo(new CohortActor.Builder(this.tx).expectAbort(new RuntimeException("mock")))), this.tx);
        this.verifySuccessfulFuture(proxy.abort());
        this.verifyCohortActors();
    }

    @Test
    public void testAbortWithFailedCohortFuture() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(ThreePhaseCommitCohortProxyTest.newCohortInfoWithFailedFuture(new TestException()), this.newCohortInfo(new CohortActor.Builder(this.tx))), this.tx);
        this.verifySuccessfulFuture(proxy.abort());
        this.verifyCohortActors();
    }

    @Test
    public void testWithNoCohorts() throws Exception {
        ThreePhaseCommitCohortProxy proxy = new ThreePhaseCommitCohortProxy(this.actorUtils, List.of(), this.tx);
        this.verifyCanCommit((ListenableFuture<Boolean>)proxy.canCommit(), true);
        this.verifySuccessfulFuture(proxy.preCommit());
        this.verifySuccessfulFuture(proxy.commit());
        this.verifyCohortActors();
    }

    private String propagateExecutionExceptionCause(ListenableFuture<?> future, Class<? extends Exception> expected) {
        Throwable ex = ((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get(5L, TimeUnit.SECONDS))).getCause();
        this.verifyCohortActors();
        MatcherAssert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(expected));
        return ex.getMessage();
    }

    private ThreePhaseCommitCohortProxy.CohortInfo newCohortInfo(CohortActor.Builder builder, short version) {
        TestActorRef actor = this.actorFactory.createTestActor(builder.props().withDispatcher(Dispatchers.DefaultDispatcherId()), this.actorFactory.generateActorId("cohort"));
        this.cohortActors.add((TestActorRef<CohortActor>)actor);
        return new ThreePhaseCommitCohortProxy.CohortInfo(Futures.successful((Object)ThreePhaseCommitCohortProxyTest.getSystem().actorSelection(actor.path())), () -> version);
    }

    private ThreePhaseCommitCohortProxy.CohortInfo newCohortInfo(CohortActor.Builder builder) {
        return this.newCohortInfo(builder, (short)12);
    }

    private static ThreePhaseCommitCohortProxy.CohortInfo newCohortInfoWithFailedFuture(Exception failure) {
        return new ThreePhaseCommitCohortProxy.CohortInfo(Futures.failed((Throwable)failure), () -> (short)12);
    }

    private void verifyCohortActors() {
        for (TestActorRef<CohortActor> actor : this.cohortActors) {
            ((CohortActor)actor.underlyingActor()).verify();
        }
    }

    private <T> T verifySuccessfulFuture(ListenableFuture<T> future) throws Exception {
        try {
            return (T)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.verifyCohortActors();
            throw e;
        }
    }

    private void verifyCanCommit(ListenableFuture<Boolean> future, boolean expected) throws Exception {
        Boolean actual = this.verifySuccessfulFuture(future);
        Assert.assertEquals((String)"canCommit", (Object)expected, (Object)actual);
    }

    private static class CohortActor
    extends UntypedAbstractActor {
        private final Builder builder;
        private final AtomicInteger canCommitCount = new AtomicInteger();
        private final AtomicInteger commitCount = new AtomicInteger();
        private final AtomicInteger abortCount = new AtomicInteger();
        private volatile AssertionError assertionError;

        CohortActor(Builder builder) {
            this.builder = builder;
        }

        public void onReceive(Object message) {
            if (CanCommitTransaction.isSerializedType((Object)message)) {
                this.canCommitCount.incrementAndGet();
                this.onMessage("CanCommitTransaction", message, (AbstractThreePhaseCommitMessage)CanCommitTransaction.fromSerializable((Object)message), this.builder.expCanCommitType, this.builder.canCommitReply);
            } else if (CommitTransaction.isSerializedType((Object)message)) {
                this.commitCount.incrementAndGet();
                this.onMessage("CommitTransaction", message, (AbstractThreePhaseCommitMessage)CommitTransaction.fromSerializable((Object)message), this.builder.expCommitType, this.builder.commitReply);
            } else if (AbortTransaction.isSerializedType((Object)message)) {
                this.abortCount.incrementAndGet();
                this.onMessage("AbortTransaction", message, (AbstractThreePhaseCommitMessage)AbortTransaction.fromSerializable((Object)message), this.builder.expAbortType, this.builder.abortReply);
            } else {
                this.assertionError = new AssertionError((Object)("Unexpected message " + message));
            }
        }

        private void onMessage(String name, Object rawMessage, AbstractThreePhaseCommitMessage actualMessage, Class<?> expType, Object reply) {
            try {
                Assert.assertNotNull((String)("Unexpected " + name), expType);
                Assert.assertEquals((String)(name + " type"), expType, rawMessage.getClass());
                Assert.assertEquals((String)(name + " transactionId"), (Object)this.builder.transactionId, (Object)actualMessage.getTransactionId());
                if (reply instanceof Throwable) {
                    this.getSender().tell((Object)new Status.Failure((Throwable)reply), this.self());
                } else {
                    this.getSender().tell(reply, this.self());
                }
            }
            catch (AssertionError e) {
                this.assertionError = e;
            }
        }

        void verify() {
            if (this.assertionError != null) {
                throw this.assertionError;
            }
            if (this.builder.expCanCommitType != null) {
                Assert.assertEquals((String)"CanCommitTransaction count", (long)1L, (long)this.canCommitCount.get());
            }
            if (this.builder.expCommitType != null) {
                Assert.assertEquals((String)"CommitTransaction count", (long)1L, (long)this.commitCount.get());
            }
            if (this.builder.expAbortType != null) {
                Assert.assertEquals((String)"AbortTransaction count", (long)1L, (long)this.abortCount.get());
            }
        }

        static class Builder {
            private Class<?> expCanCommitType;
            private Class<?> expCommitType;
            private Class<?> expAbortType;
            private Object canCommitReply;
            private Object commitReply;
            private Object abortReply;
            private final TransactionIdentifier transactionId;

            Builder(TransactionIdentifier transactionId) {
                this.transactionId = Objects.requireNonNull(transactionId);
            }

            Builder expectCanCommit(Class<?> newExpCanCommitType, Object newCanCommitReply) {
                this.expCanCommitType = newExpCanCommitType;
                this.canCommitReply = newCanCommitReply;
                return this;
            }

            Builder expectCanCommit(Object newCanCommitReply) {
                return this.expectCanCommit(CanCommitTransaction.class, newCanCommitReply);
            }

            Builder expectCommit(Class<?> newExpCommitType, Object newCommitReply) {
                this.expCommitType = newExpCommitType;
                this.commitReply = newCommitReply;
                return this;
            }

            Builder expectCommit(Object newCommitReply) {
                return this.expectCommit(CommitTransaction.class, newCommitReply);
            }

            Builder expectAbort(Class<?> newExpAbortType, Object newAbortReply) {
                this.expAbortType = newExpAbortType;
                this.abortReply = newAbortReply;
                return this;
            }

            Builder expectAbort(Object newAbortReply) {
                return this.expectAbort(AbortTransaction.class, newAbortReply);
            }

            Props props() {
                return Props.create(CohortActor.class, (Object[])new Object[]{this});
            }
        }
    }

    static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        TestException() {
        }
    }
}

