/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import akka.util.Timeout;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionProxyTest;
import org.opendaylight.controller.cluster.datastore.MockIdentifiers;
import org.opendaylight.controller.cluster.datastore.TransactionChainProxy;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import scala.concurrent.Promise;
import scala.util.Try;

public class TransactionChainProxyTest
extends AbstractTransactionProxyTest {
    private LocalHistoryIdentifier historyId;

    @Override
    public void setUp() {
        super.setUp();
        this.historyId = MockIdentifiers.historyIdentifier(TransactionChainProxyTest.class, "mock-member");
    }

    @Test
    public void testNewReadOnlyTransaction() {
        DOMStoreReadTransaction dst = new TransactionChainProxy(this.mockComponentFactory, this.historyId).newReadOnlyTransaction();
        Assert.assertTrue((boolean)(dst instanceof DOMStoreReadTransaction));
    }

    @Test
    public void testNewReadWriteTransaction() {
        DOMStoreReadWriteTransaction dst = new TransactionChainProxy(this.mockComponentFactory, this.historyId).newReadWriteTransaction();
        Assert.assertTrue((boolean)(dst instanceof DOMStoreReadWriteTransaction));
    }

    @Test
    public void testNewWriteOnlyTransaction() {
        DOMStoreWriteTransaction dst = new TransactionChainProxy(this.mockComponentFactory, this.historyId).newWriteOnlyTransaction();
        Assert.assertTrue((boolean)(dst instanceof DOMStoreWriteTransaction));
    }

    @Test
    public void testClose() {
        new TransactionChainProxy(this.mockComponentFactory, this.historyId).close();
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.times((int)1))).broadcast((Function)ArgumentMatchers.any(Function.class), (Class)ArgumentMatchers.any(Class.class));
    }

    @Test
    public void testRateLimitingUsedInReadWriteTxCreation() {
        try (TransactionChainProxy txChainProxy = new TransactionChainProxy(this.mockComponentFactory, this.historyId);){
            txChainProxy.newReadWriteTransaction();
            ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.times((int)1))).acquireTxCreationPermit();
        }
    }

    @Test
    public void testRateLimitingUsedInWriteOnlyTxCreation() {
        try (TransactionChainProxy txChainProxy = new TransactionChainProxy(this.mockComponentFactory, this.historyId);){
            txChainProxy.newWriteOnlyTransaction();
            ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.times((int)1))).acquireTxCreationPermit();
        }
    }

    @Test
    public void testRateLimitingNotUsedInReadOnlyTxCreation() {
        try (TransactionChainProxy txChainProxy = new TransactionChainProxy(this.mockComponentFactory, this.historyId);){
            txChainProxy.newReadOnlyTransaction();
            ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.times((int)0))).acquireTxCreationPermit();
        }
    }

    @Test
    public void testChainedWriteOnlyTransactions() throws Exception {
        this.dataStoreContextBuilder.writeOnlyTransactionOptimizationsEnabled(true);
        try (TransactionChainProxy txChainProxy = new TransactionChainProxy(this.mockComponentFactory, this.historyId);){
            ActorRef txActorRef1 = this.setupActorContextWithoutInitialCreateTransaction(this.getSystem());
            Promise batchedReplyPromise1 = Futures.promise();
            ((ActorUtils)Mockito.doReturn((Object)batchedReplyPromise1.future()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(txActorRef1)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
            DOMStoreWriteTransaction writeTx1 = txChainProxy.newWriteOnlyTransaction();
            ContainerNode writeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            writeTx1.write(TestModel.TEST_PATH, (NormalizedNode)writeNode1);
            writeTx1.ready();
            ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.times((int)1))).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
            this.verifyOneBatchedModification(txActorRef1, (Modification)new WriteModification(TestModel.TEST_PATH, (NormalizedNode)writeNode1), true);
            ActorRef txActorRef2 = this.setupActorContextWithoutInitialCreateTransaction(this.getSystem());
            this.expectBatchedModifications(txActorRef2, 1);
            ContainerNode writeNode2 = ImmutableNodes.containerNode((QName)TestModel.OUTER_LIST_QNAME);
            DOMStoreWriteTransaction writeTx2 = txChainProxy.newWriteOnlyTransaction();
            AtomicReference caughtEx = new AtomicReference();
            CountDownLatch write2Complete = new CountDownLatch(1);
            new Thread(() -> TransactionChainProxyTest.lambda$testChainedWriteOnlyTransactions$0(writeTx2, (NormalizedNode)writeNode2, caughtEx, write2Complete)).start();
            Assert.assertTrue((String)"Tx 2 write should've completed", (boolean)write2Complete.await(5L, TimeUnit.SECONDS));
            if (caughtEx.get() != null) {
                throw (Exception)caughtEx.get();
            }
            try {
                ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.times((int)1))).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
            }
            catch (AssertionError e) {
                Assert.fail((String)"Tx 2 should not have initiated until the Tx 1's ready future completed");
            }
            batchedReplyPromise1.success(((Try)this.readyTxReply(txActorRef1.path().toString()).value().get()).get());
            ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.timeout((long)5000L).times(2))).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        }
    }

    @Test
    public void testChainedReadWriteTransactions() throws Exception {
        try (TransactionChainProxy txChainProxy = new TransactionChainProxy(this.mockComponentFactory, this.historyId);){
            ActorRef txActorRef1 = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
            this.expectBatchedModifications(txActorRef1, 1);
            Promise readyReplyPromise1 = Futures.promise();
            ((ActorUtils)Mockito.doReturn((Object)readyReplyPromise1.future()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(txActorRef1)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
            DOMStoreReadWriteTransaction writeTx1 = txChainProxy.newReadWriteTransaction();
            ContainerNode writeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            writeTx1.write(TestModel.TEST_PATH, (NormalizedNode)writeNode1);
            writeTx1.ready();
            this.verifyOneBatchedModification(txActorRef1, (Modification)new WriteModification(TestModel.TEST_PATH, (NormalizedNode)writeNode1), true);
            String tx2MemberName = "mock-member";
            ActorRef shardActorRef2 = this.setupActorContextWithoutInitialCreateTransaction(this.getSystem());
            ActorRef txActorRef2 = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE, (short)12, tx2MemberName, shardActorRef2);
            this.expectBatchedModifications(txActorRef2, 1);
            ContainerNode writeNode2 = ImmutableNodes.containerNode((QName)TestModel.OUTER_LIST_QNAME);
            DOMStoreReadWriteTransaction writeTx2 = txChainProxy.newReadWriteTransaction();
            AtomicReference caughtEx = new AtomicReference();
            CountDownLatch write2Complete = new CountDownLatch(1);
            new Thread(() -> TransactionChainProxyTest.lambda$testChainedReadWriteTransactions$1((DOMStoreWriteTransaction)writeTx2, (NormalizedNode)writeNode2, caughtEx, write2Complete)).start();
            Assert.assertTrue((String)"Tx 2 write should've completed", (boolean)write2Complete.await(5L, TimeUnit.SECONDS));
            if (caughtEx.get() != null) {
                throw (Exception)caughtEx.get();
            }
            try {
                ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.never())).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.getSystem().actorSelection(shardActorRef2.path())), (Object)this.eqCreateTransaction(tx2MemberName, TransactionType.READ_WRITE));
            }
            catch (AssertionError e) {
                Assert.fail((String)"Tx 2 should not have initiated until the Tx 1's ready future completed");
            }
            readyReplyPromise1.success(((Try)this.readyTxReply(txActorRef1.path().toString()).value().get()).get());
            ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.timeout((long)5000L))).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.getSystem().actorSelection(shardActorRef2.path())), (Object)this.eqCreateTransaction(tx2MemberName, TransactionType.READ_WRITE), (Timeout)ArgumentMatchers.any(Timeout.class));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testChainedWriteTransactionsWithPreviousTxNotReady() {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        this.expectBatchedModifications(actorRef, 1);
        try (TransactionChainProxy txChainProxy = new TransactionChainProxy(this.mockComponentFactory, this.historyId);){
            DOMStoreWriteTransaction writeTx1 = txChainProxy.newWriteOnlyTransaction();
            ContainerNode writeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            writeTx1.write(TestModel.TEST_PATH, (NormalizedNode)writeNode1);
            txChainProxy.newWriteOnlyTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testChainedReadWriteTransactions$1(DOMStoreWriteTransaction writeTx2, NormalizedNode writeNode2, AtomicReference caughtEx, CountDownLatch write2Complete) {
        try {
            writeTx2.write(TestModel.OUTER_LIST_PATH, writeNode2);
        }
        catch (Exception e) {
            caughtEx.set(e);
        }
        finally {
            write2Complete.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testChainedWriteOnlyTransactions$0(DOMStoreWriteTransaction writeTx2, NormalizedNode writeNode2, AtomicReference caughtEx, CountDownLatch write2Complete) {
        try {
            writeTx2.write(TestModel.OUTER_LIST_PATH, writeNode2);
        }
        catch (Exception e) {
            caughtEx.set(e);
        }
        finally {
            write2Complete.countDown();
        }
    }
}

