/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.cluster.datastore.model;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;

public final class CarsModel {
    public static final QName BASE_QNAME = QName.create((String)"urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:test:cars", (String)"2014-03-13", (String)"cars");
    public static final QName CARS_QNAME = QName.create((QName)BASE_QNAME, (String)"cars");
    public static final QName CAR_QNAME = QName.create((QName)CARS_QNAME, (String)"car");
    public static final QName CAR_NAME_QNAME = QName.create((QName)CAR_QNAME, (String)"name");
    public static final QName CAR_PRICE_QNAME = QName.create((QName)CAR_QNAME, (String)"price");
    public static final YangInstanceIdentifier BASE_PATH = YangInstanceIdentifier.of((QName)BASE_QNAME);
    public static final YangInstanceIdentifier CAR_LIST_PATH = BASE_PATH.node(CAR_QNAME);

    private CarsModel() {
    }

    public static ContainerNode create() {
        CollectionNodeBuilder cars = ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CAR_QNAME));
        MapEntryNode altima = (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)CAR_QNAME, (QName)CAR_NAME_QNAME, (Object)"altima").withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CAR_NAME_QNAME, (Object)"altima")).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CAR_PRICE_QNAME, (Object)Uint64.valueOf((int)1000))).build();
        MapEntryNode honda = (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)CAR_QNAME, (QName)CAR_NAME_QNAME, (Object)"accord").withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CAR_NAME_QNAME, (Object)"accord")).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CAR_PRICE_QNAME, (Object)Uint64.valueOf((String)"2000"))).build();
        cars.withChild((NormalizedNode)altima);
        cars.withChild((NormalizedNode)honda);
        return (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(BASE_QNAME)).withChild((DataContainerChild)cars.build()).build();
    }

    public static NormalizedNode createEmptyCarsList() {
        return CarsModel.newCarsNode(CarsModel.newCarsMapNode(new MapEntryNode[0]));
    }

    public static ContainerNode newCarsNode(MapNode carsList) {
        return (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(BASE_QNAME)).withChild((DataContainerChild)carsList).build();
    }

    public static MapNode newCarsMapNode(MapEntryNode ... carEntries) {
        CollectionNodeBuilder builder = ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CAR_QNAME));
        for (MapEntryNode e : carEntries) {
            builder.withChild((NormalizedNode)e);
        }
        return (MapNode)builder.build();
    }

    public static ContainerNode emptyContainer() {
        return (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(BASE_QNAME)).build();
    }

    public static SystemMapNode newCarMapNode() {
        return (SystemMapNode)ImmutableNodes.mapNodeBuilder((QName)CAR_QNAME).build();
    }

    public static MapEntryNode newCarEntry(String name, Uint64 price) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)CAR_QNAME, (QName)CAR_NAME_QNAME, (Object)name).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CAR_NAME_QNAME, (Object)name)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CAR_PRICE_QNAME, (Object)price)).build();
    }

    public static YangInstanceIdentifier newCarPath(String name) {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)CAR_LIST_PATH).nodeWithKey(CAR_QNAME, CAR_NAME_QNAME, (Object)name).build();
    }
}

