package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link DataStorePropertiesContainer} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DataStorePropertiesContainer createDataStorePropertiesContainer(int fooXyzzy, int barBaz) {
 *         return new DataStorePropertiesContainerBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DataStorePropertiesContainer, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DataStorePropertiesContainer
 *
 */
@Generated("mdsal-binding-generator")
public class DataStorePropertiesContainerBuilder {

    private NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
    private NonZeroUint32Type _boundedMailboxCapacity;
    private String _customRaftPolicyImplementation;
    private Boolean _enableMetricCapture;
    private DataStoreProperties.ExportOnRecovery _exportOnRecovery;
    private NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
    private NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
    private NonZeroUint32Type _frontendRequestTimeoutInSeconds;
    private NonZeroUint32Type _initialPayloadSerializedBufferCapacity;
    private Uint32 _initialSettleTimeoutMultiplier;
    private NonZeroUint32Type _maximumMessageSliceSize;
    private OperationTimeoutType _operationTimeoutInSeconds;
    private Boolean _persistent;
    private String _recoveryExportBaseDir;
    private Uint32 _recoverySnapshotIntervalSeconds;
    private NonZeroUint32Type _shardBatchedModificationCount;
    private NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
    private NonZeroUint32Type _shardElectionTimeoutFactor;
    private HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
    private NonZeroUint32Type _shardInitializationTimeoutInSeconds;
    private HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
    private NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
    private NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
    private NonZeroUint32Type _shardSnapshotBatchCount;
    private NonZeroUint32Type _shardSnapshotChunkSize;
    private Uint32 _shardSnapshotDataThreshold;
    private Percentage _shardSnapshotDataThresholdPercentage;
    private NonZeroUint32Type _shardTransactionCommitQueueCapacity;
    private NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
    private NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
    private Boolean _snapshotOnRootOverwrite;
    private NonZeroUint32Type _syncIndexThreshold;
    private NonZeroUint32Type _transactionCreationInitialRateLimit;
    private Boolean _transactionDebugContextEnabled;
    private Boolean _useLz4Compression;
    private Boolean _useTellBasedProtocol;


    Map<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public DataStorePropertiesContainerBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link DataStoreProperties}.
     *
     * @param arg DataStoreProperties from which the builder should be initialized
     */
    public DataStorePropertiesContainerBuilder(DataStoreProperties arg) {
        this._shardTransactionIdleTimeoutInMinutes = arg.getShardTransactionIdleTimeoutInMinutes();
        this._shardSnapshotBatchCount = arg.getShardSnapshotBatchCount();
        this._shardSnapshotDataThresholdPercentage = arg.getShardSnapshotDataThresholdPercentage();
        this._shardSnapshotDataThreshold = arg.getShardSnapshotDataThreshold();
        this._shardHeartbeatIntervalInMillis = arg.getShardHeartbeatIntervalInMillis();
        this._shardElectionTimeoutFactor = arg.getShardElectionTimeoutFactor();
        this._operationTimeoutInSeconds = arg.getOperationTimeoutInSeconds();
        this._shardJournalRecoveryLogBatchSize = arg.getShardJournalRecoveryLogBatchSize();
        this._shardTransactionCommitTimeoutInSeconds = arg.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionCommitQueueCapacity = arg.getShardTransactionCommitQueueCapacity();
        this._shardCommitQueueExpiryTimeoutInSeconds = arg.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardInitializationTimeoutInSeconds = arg.getShardInitializationTimeoutInSeconds();
        this._shardLeaderElectionTimeoutInSeconds = arg.getShardLeaderElectionTimeoutInSeconds();
        this._initialSettleTimeoutMultiplier = arg.getInitialSettleTimeoutMultiplier();
        this._recoverySnapshotIntervalSeconds = arg.getRecoverySnapshotIntervalSeconds();
        this._shardBatchedModificationCount = arg.getShardBatchedModificationCount();
        this._enableMetricCapture = arg.getEnableMetricCapture();
        this._boundedMailboxCapacity = arg.getBoundedMailboxCapacity();
        this._persistent = arg.getPersistent();
        this._snapshotOnRootOverwrite = arg.getSnapshotOnRootOverwrite();
        this._shardIsolatedLeaderCheckIntervalInMillis = arg.getShardIsolatedLeaderCheckIntervalInMillis();
        this._transactionCreationInitialRateLimit = arg.getTransactionCreationInitialRateLimit();
        this._transactionDebugContextEnabled = arg.getTransactionDebugContextEnabled();
        this._customRaftPolicyImplementation = arg.getCustomRaftPolicyImplementation();
        this._shardSnapshotChunkSize = arg.getShardSnapshotChunkSize();
        this._maximumMessageSliceSize = arg.getMaximumMessageSliceSize();
        this._useTellBasedProtocol = arg.getUseTellBasedProtocol();
        this._fileBackedStreamingThresholdInMegabytes = arg.getFileBackedStreamingThresholdInMegabytes();
        this._syncIndexThreshold = arg.getSyncIndexThreshold();
        this._backendAlivenessTimerIntervalInSeconds = arg.getBackendAlivenessTimerIntervalInSeconds();
        this._frontendRequestTimeoutInSeconds = arg.getFrontendRequestTimeoutInSeconds();
        this._frontendNoProgressTimeoutInSeconds = arg.getFrontendNoProgressTimeoutInSeconds();
        this._initialPayloadSerializedBufferCapacity = arg.getInitialPayloadSerializedBufferCapacity();
        this._useLz4Compression = arg.getUseLz4Compression();
        this._exportOnRecovery = arg.getExportOnRecovery();
        this._recoveryExportBaseDir = arg.getRecoveryExportBaseDir();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link DataStorePropertiesContainer}.
     *
     * @param base DataStorePropertiesContainer from which the builder should be initialized
     */
    public DataStorePropertiesContainerBuilder(DataStorePropertiesContainer base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
        this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
        this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
        this._enableMetricCapture = base.getEnableMetricCapture();
        this._exportOnRecovery = base.getExportOnRecovery();
        this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
        this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
        this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
        this._initialPayloadSerializedBufferCapacity = base.getInitialPayloadSerializedBufferCapacity();
        this._initialSettleTimeoutMultiplier = base.getInitialSettleTimeoutMultiplier();
        this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
        this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
        this._persistent = base.getPersistent();
        this._recoveryExportBaseDir = base.getRecoveryExportBaseDir();
        this._recoverySnapshotIntervalSeconds = base.getRecoverySnapshotIntervalSeconds();
        this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
        this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
        this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
        this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
        this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
        this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
        this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
        this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
        this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
        this._shardSnapshotDataThreshold = base.getShardSnapshotDataThreshold();
        this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
        this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
        this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
        this._snapshotOnRootOverwrite = base.getSnapshotOnRootOverwrite();
        this._syncIndexThreshold = base.getSyncIndexThreshold();
        this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
        this._transactionDebugContextEnabled = base.getTransactionDebugContextEnabled();
        this._useLz4Compression = base.getUseLz4Compression();
        this._useTellBasedProtocol = base.getUseTellBasedProtocol();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link DataStoreProperties}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DataStoreProperties) {
            this._shardTransactionIdleTimeoutInMinutes = ((DataStoreProperties)arg).getShardTransactionIdleTimeoutInMinutes();
            this._shardSnapshotBatchCount = ((DataStoreProperties)arg).getShardSnapshotBatchCount();
            this._shardSnapshotDataThresholdPercentage = ((DataStoreProperties)arg).getShardSnapshotDataThresholdPercentage();
            this._shardSnapshotDataThreshold = ((DataStoreProperties)arg).getShardSnapshotDataThreshold();
            this._shardHeartbeatIntervalInMillis = ((DataStoreProperties)arg).getShardHeartbeatIntervalInMillis();
            this._shardElectionTimeoutFactor = ((DataStoreProperties)arg).getShardElectionTimeoutFactor();
            this._operationTimeoutInSeconds = ((DataStoreProperties)arg).getOperationTimeoutInSeconds();
            this._shardJournalRecoveryLogBatchSize = ((DataStoreProperties)arg).getShardJournalRecoveryLogBatchSize();
            this._shardTransactionCommitTimeoutInSeconds = ((DataStoreProperties)arg).getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionCommitQueueCapacity = ((DataStoreProperties)arg).getShardTransactionCommitQueueCapacity();
            this._shardCommitQueueExpiryTimeoutInSeconds = ((DataStoreProperties)arg).getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardInitializationTimeoutInSeconds = ((DataStoreProperties)arg).getShardInitializationTimeoutInSeconds();
            this._shardLeaderElectionTimeoutInSeconds = ((DataStoreProperties)arg).getShardLeaderElectionTimeoutInSeconds();
            this._initialSettleTimeoutMultiplier = ((DataStoreProperties)arg).getInitialSettleTimeoutMultiplier();
            this._recoverySnapshotIntervalSeconds = ((DataStoreProperties)arg).getRecoverySnapshotIntervalSeconds();
            this._shardBatchedModificationCount = ((DataStoreProperties)arg).getShardBatchedModificationCount();
            this._enableMetricCapture = ((DataStoreProperties)arg).getEnableMetricCapture();
            this._boundedMailboxCapacity = ((DataStoreProperties)arg).getBoundedMailboxCapacity();
            this._persistent = ((DataStoreProperties)arg).getPersistent();
            this._snapshotOnRootOverwrite = ((DataStoreProperties)arg).getSnapshotOnRootOverwrite();
            this._shardIsolatedLeaderCheckIntervalInMillis = ((DataStoreProperties)arg).getShardIsolatedLeaderCheckIntervalInMillis();
            this._transactionCreationInitialRateLimit = ((DataStoreProperties)arg).getTransactionCreationInitialRateLimit();
            this._transactionDebugContextEnabled = ((DataStoreProperties)arg).getTransactionDebugContextEnabled();
            this._customRaftPolicyImplementation = ((DataStoreProperties)arg).getCustomRaftPolicyImplementation();
            this._shardSnapshotChunkSize = ((DataStoreProperties)arg).getShardSnapshotChunkSize();
            this._maximumMessageSliceSize = ((DataStoreProperties)arg).getMaximumMessageSliceSize();
            this._useTellBasedProtocol = ((DataStoreProperties)arg).getUseTellBasedProtocol();
            this._fileBackedStreamingThresholdInMegabytes = ((DataStoreProperties)arg).getFileBackedStreamingThresholdInMegabytes();
            this._syncIndexThreshold = ((DataStoreProperties)arg).getSyncIndexThreshold();
            this._backendAlivenessTimerIntervalInSeconds = ((DataStoreProperties)arg).getBackendAlivenessTimerIntervalInSeconds();
            this._frontendRequestTimeoutInSeconds = ((DataStoreProperties)arg).getFrontendRequestTimeoutInSeconds();
            this._frontendNoProgressTimeoutInSeconds = ((DataStoreProperties)arg).getFrontendNoProgressTimeoutInSeconds();
            this._initialPayloadSerializedBufferCapacity = ((DataStoreProperties)arg).getInitialPayloadSerializedBufferCapacity();
            this._useLz4Compression = ((DataStoreProperties)arg).getUseLz4Compression();
            this._exportOnRecovery = ((DataStoreProperties)arg).getExportOnRecovery();
            this._recoveryExportBaseDir = ((DataStoreProperties)arg).getRecoveryExportBaseDir();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[DataStoreProperties]");
    }

    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getBackendAlivenessTimerIntervalInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
        return _backendAlivenessTimerIntervalInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getBoundedMailboxCapacity()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getBoundedMailboxCapacity() {
        return _boundedMailboxCapacity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getCustomRaftPolicyImplementation()}.
     *
     * @return current value
     */
    public String getCustomRaftPolicyImplementation() {
        return _customRaftPolicyImplementation;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getEnableMetricCapture()}.
     *
     * @return current value
     */
    public Boolean getEnableMetricCapture() {
        return _enableMetricCapture;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getExportOnRecovery()}.
     *
     * @return current value
     */
    public DataStoreProperties.ExportOnRecovery getExportOnRecovery() {
        return _exportOnRecovery;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getFileBackedStreamingThresholdInMegabytes()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
        return _fileBackedStreamingThresholdInMegabytes;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getFrontendNoProgressTimeoutInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
        return _frontendNoProgressTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getFrontendRequestTimeoutInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
        return _frontendRequestTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getInitialPayloadSerializedBufferCapacity()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getInitialPayloadSerializedBufferCapacity() {
        return _initialPayloadSerializedBufferCapacity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getInitialSettleTimeoutMultiplier()}.
     *
     * @return current value
     */
    public Uint32 getInitialSettleTimeoutMultiplier() {
        return _initialSettleTimeoutMultiplier;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getMaximumMessageSliceSize()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getMaximumMessageSliceSize() {
        return _maximumMessageSliceSize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getOperationTimeoutInSeconds()}.
     *
     * @return current value
     */
    public OperationTimeoutType getOperationTimeoutInSeconds() {
        return _operationTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getPersistent()}.
     *
     * @return current value
     */
    public Boolean getPersistent() {
        return _persistent;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getRecoveryExportBaseDir()}.
     *
     * @return current value
     */
    public String getRecoveryExportBaseDir() {
        return _recoveryExportBaseDir;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getRecoverySnapshotIntervalSeconds()}.
     *
     * @return current value
     */
    public Uint32 getRecoverySnapshotIntervalSeconds() {
        return _recoverySnapshotIntervalSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardBatchedModificationCount()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardBatchedModificationCount() {
        return _shardBatchedModificationCount;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardCommitQueueExpiryTimeoutInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
        return _shardCommitQueueExpiryTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardElectionTimeoutFactor()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardElectionTimeoutFactor() {
        return _shardElectionTimeoutFactor;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardHeartbeatIntervalInMillis()}.
     *
     * @return current value
     */
    public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
        return _shardHeartbeatIntervalInMillis;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardInitializationTimeoutInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
        return _shardInitializationTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardIsolatedLeaderCheckIntervalInMillis()}.
     *
     * @return current value
     */
    public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
        return _shardIsolatedLeaderCheckIntervalInMillis;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardJournalRecoveryLogBatchSize()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
        return _shardJournalRecoveryLogBatchSize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardLeaderElectionTimeoutInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
        return _shardLeaderElectionTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotBatchCount()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardSnapshotBatchCount() {
        return _shardSnapshotBatchCount;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotChunkSize()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardSnapshotChunkSize() {
        return _shardSnapshotChunkSize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotDataThreshold()}.
     *
     * @return current value
     */
    public Uint32 getShardSnapshotDataThreshold() {
        return _shardSnapshotDataThreshold;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotDataThresholdPercentage()}.
     *
     * @return current value
     */
    public Percentage getShardSnapshotDataThresholdPercentage() {
        return _shardSnapshotDataThresholdPercentage;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardTransactionCommitQueueCapacity()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
        return _shardTransactionCommitQueueCapacity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardTransactionCommitTimeoutInSeconds()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
        return _shardTransactionCommitTimeoutInSeconds;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getShardTransactionIdleTimeoutInMinutes()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
        return _shardTransactionIdleTimeoutInMinutes;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getSnapshotOnRootOverwrite()}.
     *
     * @return current value
     */
    public Boolean getSnapshotOnRootOverwrite() {
        return _snapshotOnRootOverwrite;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getSyncIndexThreshold()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getSyncIndexThreshold() {
        return _syncIndexThreshold;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getTransactionCreationInitialRateLimit()}.
     *
     * @return current value
     */
    public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
        return _transactionCreationInitialRateLimit;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getTransactionDebugContextEnabled()}.
     *
     * @return current value
     */
    public Boolean getTransactionDebugContextEnabled() {
        return _transactionDebugContextEnabled;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getUseLz4Compression()}.
     *
     * @return current value
     */
    public Boolean getUseLz4Compression() {
        return _useLz4Compression;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link DataStorePropertiesContainer#getUseTellBasedProtocol()}.
     *
     * @return current value
     */
    public Boolean getUseTellBasedProtocol() {
        return _useTellBasedProtocol;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DataStorePropertiesContainer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getBackendAlivenessTimerIntervalInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setBackendAlivenessTimerIntervalInSeconds(final NonZeroUint32Type value) {
        this._backendAlivenessTimerIntervalInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getBoundedMailboxCapacity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setBoundedMailboxCapacity(final NonZeroUint32Type value) {
        this._boundedMailboxCapacity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getCustomRaftPolicyImplementation()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setCustomRaftPolicyImplementation(final String value) {
        this._customRaftPolicyImplementation = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getEnableMetricCapture()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setEnableMetricCapture(final Boolean value) {
        this._enableMetricCapture = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getExportOnRecovery()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setExportOnRecovery(final DataStoreProperties.ExportOnRecovery value) {
        this._exportOnRecovery = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getFileBackedStreamingThresholdInMegabytes()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setFileBackedStreamingThresholdInMegabytes(final NonZeroUint32Type value) {
        this._fileBackedStreamingThresholdInMegabytes = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getFrontendNoProgressTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setFrontendNoProgressTimeoutInSeconds(final NonZeroUint32Type value) {
        this._frontendNoProgressTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getFrontendRequestTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setFrontendRequestTimeoutInSeconds(final NonZeroUint32Type value) {
        this._frontendRequestTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getInitialPayloadSerializedBufferCapacity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setInitialPayloadSerializedBufferCapacity(final NonZeroUint32Type value) {
        this._initialPayloadSerializedBufferCapacity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getInitialSettleTimeoutMultiplier()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setInitialSettleTimeoutMultiplier(final Uint32 value) {
        this._initialSettleTimeoutMultiplier = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getMaximumMessageSliceSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setMaximumMessageSliceSize(final NonZeroUint32Type value) {
        this._maximumMessageSliceSize = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getOperationTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setOperationTimeoutInSeconds(final OperationTimeoutType value) {
        this._operationTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getPersistent()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setPersistent(final Boolean value) {
        this._persistent = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getRecoveryExportBaseDir()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setRecoveryExportBaseDir(final String value) {
        this._recoveryExportBaseDir = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getRecoverySnapshotIntervalSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setRecoverySnapshotIntervalSeconds(final Uint32 value) {
        this._recoverySnapshotIntervalSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardBatchedModificationCount()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardBatchedModificationCount(final NonZeroUint32Type value) {
        this._shardBatchedModificationCount = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardCommitQueueExpiryTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardCommitQueueExpiryTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardCommitQueueExpiryTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardElectionTimeoutFactor()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardElectionTimeoutFactor(final NonZeroUint32Type value) {
        this._shardElectionTimeoutFactor = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardHeartbeatIntervalInMillis()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardHeartbeatIntervalInMillis(final HeartbeatIntervalType value) {
        this._shardHeartbeatIntervalInMillis = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardInitializationTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardInitializationTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardInitializationTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardIsolatedLeaderCheckIntervalInMillis()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardIsolatedLeaderCheckIntervalInMillis(final HeartbeatIntervalType value) {
        this._shardIsolatedLeaderCheckIntervalInMillis = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardJournalRecoveryLogBatchSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardJournalRecoveryLogBatchSize(final NonZeroUint32Type value) {
        this._shardJournalRecoveryLogBatchSize = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardLeaderElectionTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardLeaderElectionTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardLeaderElectionTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotBatchCount()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardSnapshotBatchCount(final NonZeroUint32Type value) {
        this._shardSnapshotBatchCount = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotChunkSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardSnapshotChunkSize(final NonZeroUint32Type value) {
        this._shardSnapshotChunkSize = value;
        return this;
    }
    
    private static void checkShardSnapshotDataThresholdRange(final long value) {
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotDataThreshold()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardSnapshotDataThreshold(final Uint32 value) {
        if (value != null) {
            checkShardSnapshotDataThresholdRange(value.longValue());
            
        }
        this._shardSnapshotDataThreshold = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardSnapshotDataThresholdPercentage()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardSnapshotDataThresholdPercentage(final Percentage value) {
        this._shardSnapshotDataThresholdPercentage = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardTransactionCommitQueueCapacity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardTransactionCommitQueueCapacity(final NonZeroUint32Type value) {
        this._shardTransactionCommitQueueCapacity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardTransactionCommitTimeoutInSeconds()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardTransactionCommitTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardTransactionCommitTimeoutInSeconds = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getShardTransactionIdleTimeoutInMinutes()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setShardTransactionIdleTimeoutInMinutes(final NonZeroUint32Type value) {
        this._shardTransactionIdleTimeoutInMinutes = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getSnapshotOnRootOverwrite()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setSnapshotOnRootOverwrite(final Boolean value) {
        this._snapshotOnRootOverwrite = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getSyncIndexThreshold()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setSyncIndexThreshold(final NonZeroUint32Type value) {
        this._syncIndexThreshold = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getTransactionCreationInitialRateLimit()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setTransactionCreationInitialRateLimit(final NonZeroUint32Type value) {
        this._transactionCreationInitialRateLimit = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getTransactionDebugContextEnabled()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setTransactionDebugContextEnabled(final Boolean value) {
        this._transactionDebugContextEnabled = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getUseLz4Compression()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setUseLz4Compression(final Boolean value) {
        this._useLz4Compression = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link DataStorePropertiesContainer#getUseTellBasedProtocol()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public DataStorePropertiesContainerBuilder setUseTellBasedProtocol(final Boolean value) {
        this._useTellBasedProtocol = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DataStorePropertiesContainerBuilder addAugmentation(Augmentation<DataStorePropertiesContainer> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DataStorePropertiesContainerBuilder removeAugmentation(Class<? extends Augmentation<DataStorePropertiesContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link DataStorePropertiesContainer} instance.
     *
     * @return A new {@link DataStorePropertiesContainer} instance.
     */
    public @NonNull DataStorePropertiesContainer build() {
        return new DataStorePropertiesContainerImpl(this);
    }

    private static final class DataStorePropertiesContainerImpl
        extends AbstractAugmentable<DataStorePropertiesContainer>
        implements DataStorePropertiesContainer {
    
        private final NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
        private final NonZeroUint32Type _boundedMailboxCapacity;
        private final String _customRaftPolicyImplementation;
        private final Boolean _enableMetricCapture;
        private final DataStoreProperties.ExportOnRecovery _exportOnRecovery;
        private final NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
        private final NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
        private final NonZeroUint32Type _frontendRequestTimeoutInSeconds;
        private final NonZeroUint32Type _initialPayloadSerializedBufferCapacity;
        private final Uint32 _initialSettleTimeoutMultiplier;
        private final NonZeroUint32Type _maximumMessageSliceSize;
        private final OperationTimeoutType _operationTimeoutInSeconds;
        private final Boolean _persistent;
        private final String _recoveryExportBaseDir;
        private final Uint32 _recoverySnapshotIntervalSeconds;
        private final NonZeroUint32Type _shardBatchedModificationCount;
        private final NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
        private final NonZeroUint32Type _shardElectionTimeoutFactor;
        private final HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
        private final NonZeroUint32Type _shardInitializationTimeoutInSeconds;
        private final HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
        private final NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
        private final NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
        private final NonZeroUint32Type _shardSnapshotBatchCount;
        private final NonZeroUint32Type _shardSnapshotChunkSize;
        private final Uint32 _shardSnapshotDataThreshold;
        private final Percentage _shardSnapshotDataThresholdPercentage;
        private final NonZeroUint32Type _shardTransactionCommitQueueCapacity;
        private final NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
        private final NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
        private final Boolean _snapshotOnRootOverwrite;
        private final NonZeroUint32Type _syncIndexThreshold;
        private final NonZeroUint32Type _transactionCreationInitialRateLimit;
        private final Boolean _transactionDebugContextEnabled;
        private final Boolean _useLz4Compression;
        private final Boolean _useTellBasedProtocol;
    
        DataStorePropertiesContainerImpl(DataStorePropertiesContainerBuilder base) {
            super(base.augmentation);
            this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
            this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
            this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
            this._enableMetricCapture = base.getEnableMetricCapture();
            this._exportOnRecovery = base.getExportOnRecovery();
            this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
            this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
            this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
            this._initialPayloadSerializedBufferCapacity = base.getInitialPayloadSerializedBufferCapacity();
            this._initialSettleTimeoutMultiplier = base.getInitialSettleTimeoutMultiplier();
            this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
            this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
            this._persistent = base.getPersistent();
            this._recoveryExportBaseDir = base.getRecoveryExportBaseDir();
            this._recoverySnapshotIntervalSeconds = base.getRecoverySnapshotIntervalSeconds();
            this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
            this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
            this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
            this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
            this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
            this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
            this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
            this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
            this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
            this._shardSnapshotDataThreshold = base.getShardSnapshotDataThreshold();
            this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
            this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
            this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
            this._snapshotOnRootOverwrite = base.getSnapshotOnRootOverwrite();
            this._syncIndexThreshold = base.getSyncIndexThreshold();
            this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
            this._transactionDebugContextEnabled = base.getTransactionDebugContextEnabled();
            this._useLz4Compression = base.getUseLz4Compression();
            this._useTellBasedProtocol = base.getUseTellBasedProtocol();
        }
    
        @Override
        public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
            return _backendAlivenessTimerIntervalInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getBoundedMailboxCapacity() {
            return _boundedMailboxCapacity;
        }
        
        @Override
        public String getCustomRaftPolicyImplementation() {
            return _customRaftPolicyImplementation;
        }
        
        @Override
        public Boolean getEnableMetricCapture() {
            return _enableMetricCapture;
        }
        
        @Override
        public DataStoreProperties.ExportOnRecovery getExportOnRecovery() {
            return _exportOnRecovery;
        }
        
        @Override
        public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
            return _fileBackedStreamingThresholdInMegabytes;
        }
        
        @Override
        public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
            return _frontendNoProgressTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
            return _frontendRequestTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getInitialPayloadSerializedBufferCapacity() {
            return _initialPayloadSerializedBufferCapacity;
        }
        
        @Override
        public Uint32 getInitialSettleTimeoutMultiplier() {
            return _initialSettleTimeoutMultiplier;
        }
        
        @Override
        public NonZeroUint32Type getMaximumMessageSliceSize() {
            return _maximumMessageSliceSize;
        }
        
        @Override
        public OperationTimeoutType getOperationTimeoutInSeconds() {
            return _operationTimeoutInSeconds;
        }
        
        @Override
        public Boolean getPersistent() {
            return _persistent;
        }
        
        @Override
        public String getRecoveryExportBaseDir() {
            return _recoveryExportBaseDir;
        }
        
        @Override
        public Uint32 getRecoverySnapshotIntervalSeconds() {
            return _recoverySnapshotIntervalSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardBatchedModificationCount() {
            return _shardBatchedModificationCount;
        }
        
        @Override
        public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
            return _shardCommitQueueExpiryTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardElectionTimeoutFactor() {
            return _shardElectionTimeoutFactor;
        }
        
        @Override
        public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
            return _shardHeartbeatIntervalInMillis;
        }
        
        @Override
        public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
            return _shardInitializationTimeoutInSeconds;
        }
        
        @Override
        public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
            return _shardIsolatedLeaderCheckIntervalInMillis;
        }
        
        @Override
        public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
            return _shardJournalRecoveryLogBatchSize;
        }
        
        @Override
        public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
            return _shardLeaderElectionTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardSnapshotBatchCount() {
            return _shardSnapshotBatchCount;
        }
        
        @Override
        public NonZeroUint32Type getShardSnapshotChunkSize() {
            return _shardSnapshotChunkSize;
        }
        
        @Override
        public Uint32 getShardSnapshotDataThreshold() {
            return _shardSnapshotDataThreshold;
        }
        
        @Override
        public Percentage getShardSnapshotDataThresholdPercentage() {
            return _shardSnapshotDataThresholdPercentage;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
            return _shardTransactionCommitQueueCapacity;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
            return _shardTransactionCommitTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
            return _shardTransactionIdleTimeoutInMinutes;
        }
        
        @Override
        public Boolean getSnapshotOnRootOverwrite() {
            return _snapshotOnRootOverwrite;
        }
        
        @Override
        public NonZeroUint32Type getSyncIndexThreshold() {
            return _syncIndexThreshold;
        }
        
        @Override
        public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
            return _transactionCreationInitialRateLimit;
        }
        
        @Override
        public Boolean getTransactionDebugContextEnabled() {
            return _transactionDebugContextEnabled;
        }
        
        @Override
        public Boolean getUseLz4Compression() {
            return _useLz4Compression;
        }
        
        @Override
        public Boolean getUseTellBasedProtocol() {
            return _useTellBasedProtocol;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = DataStorePropertiesContainer.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return DataStorePropertiesContainer.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return DataStorePropertiesContainer.bindingToString(this);
        }
    }
}
