package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

@Generated("mdsal-binding-generator")
public class OperationTimeoutType
 implements ScalarTypeObject<Uint16>, Serializable {
    private static final long serialVersionUID = -8895242571909692994L;
    private final Uint16 _value;

    private static void check_valueRange(final int value) {
        if (value >= 5) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[5..65535]]", value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public OperationTimeoutType(Uint16 _value) {
        if (_value != null) {
            check_valueRange(_value.intValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public OperationTimeoutType(OperationTimeoutType source) {
        this._value = source._value;
    }

    public static OperationTimeoutType getDefaultInstance(final String defaultValue) {
        return new OperationTimeoutType(Uint16.valueOf(defaultValue));
    }

    @Override
    public Uint16 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OperationTimeoutType)) {
            return false;
        }
        final OperationTimeoutType other = (OperationTimeoutType) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(OperationTimeoutType.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

