/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransactionTest;
import org.opendaylight.controller.cluster.databroker.ClientBackedWriteTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ClientBackedWriteTransactionTest
extends ClientBackedTransactionTest<ClientBackedWriteTransaction> {
    private ClientBackedWriteTransaction object;
    @Mock
    private ClientTransaction delegate;
    @Mock
    private NormalizedNode data;
    @Mock
    private DOMStoreThreePhaseCommitCohort readyCohort;

    @Before
    public void setUp() {
        ((ClientTransaction)Mockito.doReturn((Object)TRANSACTION_ID).when((Object)this.delegate)).getIdentifier();
        ((ClientTransaction)Mockito.doReturn((Object)this.readyCohort).when((Object)this.delegate)).ready();
        this.object = new ClientBackedWriteTransaction(this.delegate, null);
    }

    @Override
    ClientBackedWriteTransaction object() {
        return this.object;
    }

    @Test
    public void testWrite() {
        this.object().write(YangInstanceIdentifier.empty(), this.data);
        ((ClientTransaction)Mockito.verify((Object)this.delegate)).write(YangInstanceIdentifier.empty(), this.data);
    }

    @Test
    public void testMerge() {
        this.object().merge(YangInstanceIdentifier.empty(), this.data);
        ((ClientTransaction)Mockito.verify((Object)this.delegate)).merge(YangInstanceIdentifier.empty(), this.data);
    }

    @Test
    public void testDelete() {
        this.object().delete(YangInstanceIdentifier.empty());
        ((ClientTransaction)Mockito.verify((Object)this.delegate)).delete(YangInstanceIdentifier.empty());
    }

    @Test
    public void testReady() {
        DOMStoreThreePhaseCommitCohort result = this.object().ready();
        Assert.assertNotNull((Object)result);
        ((ClientTransaction)Mockito.verify((Object)this.delegate)).ready();
    }
}

