/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Status;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import java.util.List;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequest;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccess;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.GetClientRequest;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;
import scala.concurrent.impl.Promise;

public abstract class AbstractDataStoreClientBehaviorTest {
    protected static final String SHARD = "default";
    private static final String PERSISTENCE_ID = "per-1";
    private ActorSystem system;
    private ClientActorContext clientContext;
    private TestProbe clientActorProbe;
    private TestProbe actorContextProbe;
    private AbstractDataStoreClientBehavior behavior;
    private ActorUtils util;

    @Before
    public void setUp() {
        this.system = ActorSystem.apply();
        this.clientActorProbe = new TestProbe(this.system, "client");
        this.actorContextProbe = new TestProbe(this.system, "actor-context");
        this.util = AbstractDataStoreClientBehaviorTest.createActorContextMock(this.system, this.actorContextProbe.ref());
        this.clientContext = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)this.clientActorProbe.ref(), (ClientIdentifier)TestUtils.CLIENT_ID, (String)PERSISTENCE_ID);
        this.behavior = this.createBehavior(this.clientContext, this.util);
    }

    protected abstract AbstractDataStoreClientBehavior createBehavior(ClientActorContext var1, ActorUtils var2);

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public void testResolveShardForPath() {
        Assert.assertEquals((long)0L, (long)this.behavior.resolveShardForPath(YangInstanceIdentifier.empty()));
    }

    @Test
    public void testHaltClient() {
        this.behavior.haltClient((Throwable)new RuntimeException());
    }

    @Test
    public void testOnCommand() {
        TestProbe probe = new TestProbe(this.system);
        GetClientRequest request = new GetClientRequest(probe.ref());
        AbstractDataStoreClientBehavior nextBehavior = this.behavior.onCommand((Object)request);
        Status.Success success = (Status.Success)probe.expectMsgClass(Status.Success.class);
        Assert.assertEquals((Object)this.behavior, (Object)success.status());
        Assert.assertSame((Object)this.behavior, (Object)nextBehavior);
    }

    @Test
    public void testOnCommandUnhandled() {
        AbstractDataStoreClientBehavior nextBehavior = this.behavior.onCommand((Object)"unhandled");
        Assert.assertSame((Object)this.behavior, (Object)nextBehavior);
    }

    @Test
    public void testCreateLocalHistory() {
        ClientLocalHistory history = this.behavior.createLocalHistory();
        Assert.assertEquals((Object)this.behavior.getIdentifier(), (Object)history.getIdentifier().getClientId());
    }

    @Test
    public void testCreateTransaction() {
        ClientTransaction transaction = this.behavior.createTransaction();
        Assert.assertEquals((Object)this.behavior.getIdentifier(), (Object)transaction.getIdentifier().getHistoryId().getClientId());
    }

    @Test
    public void testCreateSnapshot() {
        ClientSnapshot snapshot = this.behavior.createSnapshot();
        Assert.assertEquals((Object)this.behavior.getIdentifier(), (Object)snapshot.getIdentifier().getHistoryId().getClientId());
    }

    @Test
    public void testClose() {
        this.behavior.close();
        InternalCommand internalCommand = (InternalCommand)this.clientActorProbe.expectMsgClass(InternalCommand.class);
        internalCommand.execute((ClientActorBehavior)this.behavior);
        Assert.assertThrows(IllegalStateException.class, () -> this.behavior.createLocalHistory());
    }

    @Test
    public void testGetIdentifier() {
        Assert.assertEquals((Object)TestUtils.CLIENT_ID, (Object)this.behavior.getIdentifier());
    }

    @Test
    public void testGetConnection() {
        DatastoreContext datastoreContext = (DatastoreContext)Mockito.mock(DatastoreContext.class);
        ((DatastoreContext)Mockito.doReturn((Object)1000).when((Object)datastoreContext)).getShardBatchedModificationCount();
        ((ActorUtils)Mockito.doReturn((Object)datastoreContext).when((Object)this.util)).getDatastoreContext();
        CursorAwareDataTreeModification modification = (CursorAwareDataTreeModification)Mockito.mock(CursorAwareDataTreeModification.class);
        ((CursorAwareDataTreeModification)Mockito.doReturn(Optional.empty()).when((Object)modification)).readNode(YangInstanceIdentifier.empty());
        DataTreeSnapshot snapshot = (DataTreeSnapshot)Mockito.mock(DataTreeSnapshot.class);
        ((DataTreeSnapshot)Mockito.doReturn((Object)modification).when((Object)snapshot)).newModification();
        DataTree dataTree = (DataTree)Mockito.mock(DataTree.class);
        ((DataTree)Mockito.doReturn((Object)snapshot).when((Object)dataTree)).takeSnapshot();
        TestProbe backendProbe = new TestProbe(this.system, "backend");
        long shard = 0L;
        this.behavior.createTransaction().read(YangInstanceIdentifier.empty());
        AbstractClientConnection connection = this.behavior.getConnection(Long.valueOf(0L));
        Assert.assertSame((Object)connection, (Object)this.behavior.getConnection(Long.valueOf(0L)));
        ConnectClientRequest connectClientRequest = (ConnectClientRequest)this.actorContextProbe.expectMsgClass(ConnectClientRequest.class);
        Assert.assertEquals((Object)TestUtils.CLIENT_ID, (Object)connectClientRequest.getTarget());
        long sequence = 0L;
        Assert.assertEquals((long)0L, (long)connectClientRequest.getSequence());
        this.actorContextProbe.reply((Object)new ConnectClientSuccess(TestUtils.CLIENT_ID, 0L, backendProbe.ref(), List.of(), (ReadOnlyDataTree)dataTree, 3));
        Assert.assertEquals((Object)this.clientActorProbe.ref(), (Object)connection.localActor());
        InternalCommand command = (InternalCommand)this.clientActorProbe.expectMsgClass(InternalCommand.class);
        command.execute((ClientActorBehavior)this.behavior);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)modification)).readNode(YangInstanceIdentifier.empty());
    }

    private static ActorUtils createActorContextMock(ActorSystem system, ActorRef actor) {
        ActorUtils mock = (ActorUtils)Mockito.mock(ActorUtils.class);
        Promise.DefaultPromise promise = new Promise.DefaultPromise();
        ActorSelection selection = system.actorSelection(actor.path());
        PrimaryShardInfo shardInfo = new PrimaryShardInfo(selection, 0);
        promise.success((Object)shardInfo);
        ((ActorUtils)Mockito.doReturn((Object)promise.future()).when((Object)mock)).findPrimaryShardAsync(SHARD);
        return mock;
    }
}

