/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.testkit.TestProbe;
import com.google.common.base.Ticker;
import com.google.common.base.VerifyException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransactionTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalReadOnlyProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.VotingFuture;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;

public class LocalReadOnlyProxyTransactionTest
extends LocalProxyTransactionTest<LocalReadOnlyProxyTransaction> {
    private DataTreeSnapshot snapshot;

    @Override
    protected LocalReadOnlyProxyTransaction createTransaction(ProxyHistory parent, TransactionIdentifier id, DataTreeSnapshot snapshot) {
        Mockito.when((Object)snapshot.readNode(PATH_1)).thenReturn(Optional.of(DATA_1));
        Mockito.when((Object)snapshot.readNode(PATH_3)).thenReturn(Optional.empty());
        this.snapshot = snapshot;
        return new LocalReadOnlyProxyTransaction(parent, id, this.snapshot);
    }

    @Test
    public void testIsSnapshotOnly() {
        Assert.assertTrue((boolean)((LocalReadOnlyProxyTransaction)this.transaction).isSnapshotOnly());
    }

    @Test
    public void testReadOnlyView() {
        Assert.assertEquals((Object)this.snapshot, (Object)((LocalReadOnlyProxyTransaction)this.transaction).readOnlyView());
    }

    @Override
    @Test
    public void testDirectCommit() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).directCommit());
    }

    @Override
    @Test
    public void testCanCommit() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).canCommit(new VotingFuture(new Object(), 1)));
    }

    @Override
    @Test
    public void testPreCommit() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).preCommit(new VotingFuture(new Object(), 1)));
    }

    @Override
    @Test
    public void testDoCommit() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).doCommit(new VotingFuture(new Object(), 1)));
    }

    @Override
    @Test
    public void testDelete() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).delete(PATH_1));
    }

    @Override
    public void testMerge() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).merge(PATH_1, (NormalizedNode)DATA_1));
    }

    @Override
    @Test
    public void testWrite() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).write(PATH_1, (NormalizedNode)DATA_1));
    }

    @Test
    public void testDoDelete() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).doDelete(PATH_1));
    }

    @Test
    public void testDoMerge() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).doMerge(PATH_1, (NormalizedNode)DATA_1));
    }

    @Test
    public void testDoWrite() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).doWrite(PATH_1, (NormalizedNode)DATA_1));
    }

    @Test
    public void testCommitRequest() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((LocalReadOnlyProxyTransaction)this.transaction).commitRequest(true));
    }

    @Test
    public void testApplyModifyTransactionRequest() {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        builder.setSequence(0L);
        builder.setAbort();
        ModifyTransactionRequest request = builder.build();
        ((LocalReadOnlyProxyTransaction)this.transaction).replayModifyTransactionRequest(request, LocalReadOnlyProxyTransactionTest.createCallbackMock(), Ticker.systemTicker().read());
        this.getTester().expectTransactionRequest(AbortLocalTransactionRequest.class);
    }

    @Test
    public void testApplyModifyTransactionRequestNotAbort() throws Exception {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        builder.setSequence(0L);
        builder.setReady();
        ModifyTransactionRequest request = builder.build();
        TestUtils.assertOperationThrowsException(() -> ((LocalReadOnlyProxyTransaction)this.transaction).replayModifyTransactionRequest(request, LocalReadOnlyProxyTransactionTest.createCallbackMock(), Ticker.systemTicker().read()), VerifyException.class);
    }
}

