/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistoryTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.SingleClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class SingleClientHistoryTest
extends AbstractClientHistoryTest<SingleClientHistory> {
    private ActorSystem system;
    private AbstractDataStoreClientBehavior behavior;
    private ClientActorContext clientActorContext;
    private SingleClientHistory object;
    @Mock
    private AbstractTransactionCommitCohort cohort;

    @Before
    public void setUp() {
        this.system = ActorSystem.apply();
        TestProbe clientContextProbe = new TestProbe(this.system, "client");
        TestProbe actorContextProbe = new TestProbe(this.system, "actor-context");
        this.clientActorContext = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)TestUtils.CLIENT_ID, (String)"per-1");
        ActorUtils actorUtilsMock = this.createActorUtilsMock(this.system, actorContextProbe.ref());
        this.behavior = new SimpleDataStoreClientBehavior(this.clientActorContext, actorUtilsMock, "default");
        this.object = new SingleClientHistory(this.behavior, HISTORY_ID);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Override
    protected SingleClientHistory object() {
        return this.object;
    }

    @Override
    protected ClientActorContext clientActorContext() {
        return this.clientActorContext;
    }

    @Override
    @Test
    public void testDoCreateTransaction() {
        ClientTransaction clientTransaction = this.object().doCreateTransaction();
        Assert.assertEquals((Object)this.object().getIdentifier(), (Object)clientTransaction.getIdentifier().getHistoryId());
    }

    @Override
    @Test
    public void testCreateHistoryProxy() {
        AbstractClientConnection clientConnection = this.behavior.getConnection(Long.valueOf(0L));
        ProxyHistory historyProxy = this.object().createHistoryProxy(HISTORY_ID, clientConnection);
        Assert.assertEquals((Object)this.object().getIdentifier(), (Object)historyProxy.getIdentifier());
    }

    @Override
    @Test
    public void testDoCreateSnapshot() {
        ClientSnapshot clientSnapshot = this.object().doCreateSnapshot();
        Assert.assertEquals((Object)new TransactionIdentifier(this.object().getIdentifier(), this.object().nextTx()).getHistoryId(), (Object)clientSnapshot.getIdentifier().getHistoryId());
    }

    @Override
    @Test
    public void testOnTransactionComplete() {
        ClientTransaction transaction = this.object().createTransaction();
        this.object().onTransactionReady(transaction, this.cohort);
        this.object().onTransactionComplete(transaction.getIdentifier());
        AbstractTransactionCommitCohort result = this.object().onTransactionReady(transaction, this.cohort);
        Assert.assertEquals((Object)result, (Object)this.cohort);
    }

    @Override
    @Test
    public void testOnTransactionAbort() {
        ClientSnapshot clientSnapshot = this.object().doCreateSnapshot();
        Assert.assertTrue((boolean)clientSnapshot.abort());
    }

    @Override
    @Test
    public void testOnTransactionReady() {
        AbstractTransactionCommitCohort result = this.object().onTransactionReady(this.object().createTransaction(), this.cohort);
        Assert.assertEquals((Object)result, (Object)this.cohort);
    }

    @Override
    @Test
    public void testOnTransactionReadyDuplicate() {
        ClientTransaction transaction = this.object().createTransaction();
        this.object().onTransactionReady(transaction, this.cohort);
        IllegalStateException ise = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.object().onTransactionReady(transaction, this.cohort));
        MatcherAssert.assertThat((Object)ise.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Duplicate cohort "));
    }
}

