/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActor;
import org.opendaylight.controller.cluster.raft.TestActorFactory;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.common.api.PostPreCommitStep;
import org.opendaylight.mdsal.common.api.ThreePhaseCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public class DataTreeCohortActorTest
extends AbstractActorTest {
    private static final Collection<DOMDataTreeCandidate> CANDIDATES = new ArrayList<DOMDataTreeCandidate>();
    private static final EffectiveModelContext MOCK_SCHEMA = (EffectiveModelContext)Mockito.mock(EffectiveModelContext.class);
    private final TestActorFactory actorFactory = new TestActorFactory(DataTreeCohortActorTest.getSystem());
    private final DOMDataTreeCommitCohort mockCohort = (DOMDataTreeCommitCohort)Mockito.mock(DOMDataTreeCommitCohort.class);
    private final PostCanCommitStep mockPostCanCommit = (PostCanCommitStep)Mockito.mock(PostCanCommitStep.class);
    private final PostPreCommitStep mockPostPreCommit = (PostPreCommitStep)Mockito.mock(PostPreCommitStep.class);

    @Before
    public void setup() {
        this.resetMockCohort();
    }

    @After
    public void tearDown() {
        this.actorFactory.close();
    }

    @Test
    public void testSuccessfulThreePhaseCommit() throws Exception {
        ActorRef cohortActor = this.newCohortActor("testSuccessfulThreePhaseCommit");
        TransactionIdentifier txId = DataTreeCohortActorTest.nextTransactionId();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.PreCommit(txId));
        ((PostCanCommitStep)Mockito.verify((Object)this.mockPostCanCommit)).preCommit();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.Commit(txId));
        ((PostPreCommitStep)Mockito.verify((Object)this.mockPostPreCommit)).commit();
        this.resetMockCohort();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
    }

    @Test
    public void testMultipleThreePhaseCommits() throws Exception {
        ActorRef cohortActor = this.newCohortActor("testMultipleThreePhaseCommits");
        TransactionIdentifier txId1 = DataTreeCohortActorTest.nextTransactionId();
        TransactionIdentifier txId2 = DataTreeCohortActorTest.nextTransactionId();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId1, CANDIDATES, MOCK_SCHEMA, cohortActor));
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId2, CANDIDATES, MOCK_SCHEMA, cohortActor));
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.PreCommit(txId1));
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.PreCommit(txId2));
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.Commit(txId1));
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.Commit(txId2));
    }

    @Test
    public void testAsyncCohort() throws Exception {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        ((DOMDataTreeCommitCohort)Mockito.doReturn(DataTreeCohortActorTest.executeWithDelay(executor, this.mockPostCanCommit)).when((Object)this.mockCohort)).canCommit(ArgumentMatchers.any(Object.class), (EffectiveModelContext)ArgumentMatchers.any(EffectiveModelContext.class), ArgumentMatchers.anyCollection());
        ((PostCanCommitStep)Mockito.doReturn((Object)executor.submit(() -> this.mockPostPreCommit)).when((Object)this.mockPostCanCommit)).preCommit();
        ((PostPreCommitStep)Mockito.doReturn((Object)executor.submit(() -> null)).when((Object)this.mockPostPreCommit)).commit();
        ActorRef cohortActor = this.newCohortActor("testAsyncCohort");
        TransactionIdentifier txId = DataTreeCohortActorTest.nextTransactionId();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.PreCommit(txId));
        ((PostCanCommitStep)Mockito.verify((Object)this.mockPostCanCommit)).preCommit();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.Commit(txId));
        ((PostPreCommitStep)Mockito.verify((Object)this.mockPostPreCommit)).commit();
        executor.shutdownNow();
    }

    @Test
    public void testFailureOnCanCommit() throws Exception {
        DataValidationFailedException failure = new DataValidationFailedException(YangInstanceIdentifier.empty(), "mock");
        ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateFailedFluentFuture((Throwable)failure)).when((Object)this.mockCohort)).canCommit(ArgumentMatchers.any(Object.class), (EffectiveModelContext)ArgumentMatchers.any(EffectiveModelContext.class), ArgumentMatchers.anyCollection());
        ActorRef cohortActor = this.newCohortActor("testFailureOnCanCommit");
        TransactionIdentifier txId = DataTreeCohortActorTest.nextTransactionId();
        try {
            DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        }
        catch (DataValidationFailedException e) {
            Assert.assertEquals((String)"DataValidationFailedException", (Object)((Object)failure), (Object)((Object)e));
        }
        this.resetMockCohort();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
    }

    @Test
    public void testAbortAfterCanCommit() throws Exception {
        ActorRef cohortActor = this.newCohortActor("testAbortAfterCanCommit");
        TransactionIdentifier txId = DataTreeCohortActorTest.nextTransactionId();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.Abort(txId));
        ((PostCanCommitStep)Mockito.verify((Object)this.mockPostCanCommit)).abort();
        this.resetMockCohort();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
    }

    @Test
    public void testAbortAfterPreCommit() throws Exception {
        ActorRef cohortActor = this.newCohortActor("testAbortAfterPreCommit");
        TransactionIdentifier txId = DataTreeCohortActorTest.nextTransactionId();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.CanCommit(txId, CANDIDATES, MOCK_SCHEMA, cohortActor));
        ((DOMDataTreeCommitCohort)Mockito.verify((Object)this.mockCohort)).canCommit((Object)txId, MOCK_SCHEMA, CANDIDATES);
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.PreCommit(txId));
        ((PostCanCommitStep)Mockito.verify((Object)this.mockPostCanCommit)).preCommit();
        DataTreeCohortActorTest.askAndAwait(cohortActor, new DataTreeCohortActor.Abort(txId));
        ((PostPreCommitStep)Mockito.verify((Object)this.mockPostPreCommit)).abort();
    }

    private static <T> FluentFuture<T> executeWithDelay(ListeningExecutorService executor, T result) {
        return FluentFuture.from((ListenableFuture)executor.submit(() -> {
            Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            return result;
        }));
    }

    private ActorRef newCohortActor(String name) {
        return this.actorFactory.createActor(DataTreeCohortActor.props((DOMDataTreeCommitCohort)this.mockCohort, (YangInstanceIdentifier)YangInstanceIdentifier.empty()), name);
    }

    private void resetMockCohort() {
        Mockito.reset((Object[])new DOMDataTreeCommitCohort[]{this.mockCohort});
        ((PostCanCommitStep)Mockito.doReturn((Object)ThreePhaseCommitStep.NOOP_ABORT_FUTURE).when((Object)this.mockPostCanCommit)).abort();
        ((PostCanCommitStep)Mockito.doReturn((Object)Futures.immediateFuture((Object)this.mockPostPreCommit)).when((Object)this.mockPostCanCommit)).preCommit();
        ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateFluentFuture((Object)this.mockPostCanCommit)).when((Object)this.mockCohort)).canCommit(ArgumentMatchers.any(Object.class), (EffectiveModelContext)ArgumentMatchers.any(EffectiveModelContext.class), ArgumentMatchers.anyCollection());
        ((PostPreCommitStep)Mockito.doReturn((Object)ThreePhaseCommitStep.NOOP_ABORT_FUTURE).when((Object)this.mockPostPreCommit)).abort();
        ((PostPreCommitStep)Mockito.doReturn((Object)Futures.immediateFuture(null)).when((Object)this.mockPostPreCommit)).commit();
    }

    private static void askAndAwait(ActorRef actor, DataTreeCohortActor.CommitProtocolCommand<?> message) throws Exception {
        Timeout timeout = new Timeout(5L, TimeUnit.SECONDS);
        Object result = Await.result((Awaitable)Patterns.ask((ActorRef)actor, message, (Timeout)timeout), (Duration)timeout.duration());
        Assert.assertTrue((String)("Expected Success but was " + result), (boolean)(result instanceof DataTreeCohortActor.Success));
        Assert.assertEquals((String)"Success", (Object)message.getTxId(), (Object)((DataTreeCohortActor.Success)result).getTxId());
    }
}

