/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Ticker;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ReadOnlyShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeMocking;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class ShardDataTreeTest
extends AbstractTest {
    private static final DatastoreContext DATASTORE_CONTEXT = DatastoreContext.newBuilder().build();
    private final Shard mockShard = (Shard)Mockito.mock(Shard.class);
    private ShardDataTree shardDataTree;
    private EffectiveModelContext fullSchema;

    @Before
    public void setUp() {
        ((Shard)Mockito.doReturn((Object)Ticker.systemTicker()).when((Object)this.mockShard)).ticker();
        ((Shard)Mockito.doReturn((Object)new ShardStats("shardName", "mxBeanType", this.mockShard)).when((Object)this.mockShard)).getShardMBean();
        ((Shard)Mockito.doReturn((Object)DATASTORE_CONTEXT).when((Object)this.mockShard)).getDatastoreContext();
        this.fullSchema = SchemaContextHelper.full();
        this.shardDataTree = new ShardDataTree(this.mockShard, this.fullSchema, TreeType.OPERATIONAL);
    }

    @Test
    public void testWrite() {
        this.modify(false, true, true);
    }

    @Test
    public void testMerge() {
        this.modify(true, true, true);
    }

    private void modify(boolean merge, boolean expectedCarsPresent, boolean expectedPeoplePresent) {
        ShardDataTreeMocking.immediatePayloadReplication(this.shardDataTree, this.mockShard);
        Assert.assertEquals((Object)this.fullSchema, (Object)this.shardDataTree.getSchemaContext());
        ReadWriteShardDataTreeTransaction transaction = this.shardDataTree.newReadWriteTransaction(ShardDataTreeTest.nextTransactionId());
        DataTreeModification snapshot = (DataTreeModification)transaction.getSnapshot();
        Assert.assertNotNull((Object)snapshot);
        if (merge) {
            snapshot.merge(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.create());
            snapshot.merge(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.create());
        } else {
            snapshot.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.create());
            snapshot.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.create());
        }
        ShardDataTreeCohort cohort = this.shardDataTree.finishTransaction(transaction, Optional.empty());
        ShardDataTreeMocking.immediateCanCommit(cohort);
        ShardDataTreeMocking.immediatePreCommit(cohort);
        ShardDataTreeMocking.immediateCommit(cohort);
        ReadOnlyShardDataTreeTransaction readOnlyShardDataTreeTransaction = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId());
        DataTreeSnapshot snapshot1 = readOnlyShardDataTreeTransaction.getSnapshot();
        Optional optional = snapshot1.readNode(CarsModel.BASE_PATH);
        Assert.assertEquals((Object)expectedCarsPresent, (Object)optional.isPresent());
        Optional optional1 = snapshot1.readNode(PeopleModel.BASE_PATH);
        Assert.assertEquals((Object)expectedPeoplePresent, (Object)optional1.isPresent());
    }

    @Test
    public void bug4359AddRemoveCarOnce() {
        ShardDataTreeMocking.immediatePayloadReplication(this.shardDataTree, this.mockShard);
        ArrayList<DataTreeCandidate> candidates = new ArrayList<DataTreeCandidate>();
        candidates.add(ShardDataTreeTest.addCar(this.shardDataTree));
        candidates.add(ShardDataTreeTest.removeCar(this.shardDataTree));
        NormalizedNode expected = ShardDataTreeTest.getCars(this.shardDataTree);
        ShardDataTreeTest.applyCandidates(this.shardDataTree, candidates);
        NormalizedNode actual = ShardDataTreeTest.getCars(this.shardDataTree);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void bug4359AddRemoveCarTwice() {
        ShardDataTreeMocking.immediatePayloadReplication(this.shardDataTree, this.mockShard);
        ArrayList<DataTreeCandidate> candidates = new ArrayList<DataTreeCandidate>();
        candidates.add(ShardDataTreeTest.addCar(this.shardDataTree));
        candidates.add(ShardDataTreeTest.removeCar(this.shardDataTree));
        candidates.add(ShardDataTreeTest.addCar(this.shardDataTree));
        candidates.add(ShardDataTreeTest.removeCar(this.shardDataTree));
        NormalizedNode expected = ShardDataTreeTest.getCars(this.shardDataTree);
        ShardDataTreeTest.applyCandidates(this.shardDataTree, candidates);
        NormalizedNode actual = ShardDataTreeTest.getCars(this.shardDataTree);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testListenerNotifiedOnApplySnapshot() throws Exception {
        ShardDataTreeMocking.immediatePayloadReplication(this.shardDataTree, this.mockShard);
        DOMDataTreeChangeListener listener = (DOMDataTreeChangeListener)Mockito.mock(DOMDataTreeChangeListener.class);
        this.shardDataTree.registerTreeChangeListener(CarsModel.CAR_LIST_PATH.node(CarsModel.CAR_QNAME), listener, Optional.empty(), noop -> {});
        ShardDataTreeTest.addCar(this.shardDataTree, "optima");
        ShardDataTreeTest.verifyOnDataTreeChanged(listener, dtc -> {
            Assert.assertEquals((String)"getModificationType", (Object)ModificationType.WRITE, (Object)dtc.getRootNode().getModificationType());
            Assert.assertEquals((String)"getRootPath", (Object)CarsModel.newCarPath("optima"), (Object)dtc.getRootPath());
        });
        ShardDataTreeTest.addCar(this.shardDataTree, "sportage");
        ShardDataTreeTest.verifyOnDataTreeChanged(listener, dtc -> {
            Assert.assertEquals((String)"getModificationType", (Object)ModificationType.WRITE, (Object)dtc.getRootNode().getModificationType());
            Assert.assertEquals((String)"getRootPath", (Object)CarsModel.newCarPath("sportage"), (Object)dtc.getRootPath());
        });
        ShardDataTree newDataTree = new ShardDataTree(this.mockShard, this.fullSchema, TreeType.OPERATIONAL);
        ShardDataTreeMocking.immediatePayloadReplication(newDataTree, this.mockShard);
        ShardDataTreeTest.addCar(newDataTree, "optima");
        ShardDataTreeTest.addCar(newDataTree, "murano");
        this.shardDataTree.applySnapshot(newDataTree.takeStateSnapshot());
        HashMap<YangInstanceIdentifier, ModificationType> expChanges = new HashMap<YangInstanceIdentifier, ModificationType>();
        expChanges.put(CarsModel.newCarPath("optima"), ModificationType.WRITE);
        expChanges.put(CarsModel.newCarPath("murano"), ModificationType.WRITE);
        expChanges.put(CarsModel.newCarPath("sportage"), ModificationType.DELETE);
        ShardDataTreeTest.verifyOnDataTreeChanged(listener, dtc -> {
            ModificationType expType = (ModificationType)expChanges.remove(dtc.getRootPath());
            Assert.assertNotNull((String)("Got unexpected change for " + dtc.getRootPath()), (Object)expType);
            Assert.assertEquals((String)"getModificationType", (Object)expType, (Object)dtc.getRootNode().getModificationType());
        });
        if (!expChanges.isEmpty()) {
            Assert.fail((String)("Missing change notifications: " + expChanges));
        }
    }

    @Test
    public void testPipelinedTransactionsWithCoordinatedCommits() throws Exception {
        ShardDataTreeCohort cohort1 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()));
        ShardDataTreeCohort cohort2 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()));
        ContainerNode peopleNode = PeopleModel.create();
        ShardDataTreeCohort cohort3 = this.newShardDataTreeCohort(arg_0 -> ShardDataTreeTest.lambda$testPipelinedTransactionsWithCoordinatedCommits$6((NormalizedNode)peopleNode, arg_0));
        YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
        MapEntryNode carNode = CarsModel.newCarEntry("optima", Uint64.valueOf((int)100));
        ShardDataTreeCohort cohort4 = this.newShardDataTreeCohort(snapshot -> snapshot.write(carPath, (NormalizedNode)carNode));
        ShardDataTreeMocking.immediateCanCommit(cohort1);
        FutureCallback<Empty> canCommitCallback2 = ShardDataTreeMocking.coordinatedCanCommit(cohort2);
        FutureCallback<Empty> canCommitCallback3 = ShardDataTreeMocking.coordinatedCanCommit(cohort3);
        FutureCallback<Empty> canCommitCallback4 = ShardDataTreeMocking.coordinatedCanCommit(cohort4);
        FutureCallback<DataTreeCandidate> preCommitCallback1 = ShardDataTreeMocking.coordinatedPreCommit(cohort1);
        ((FutureCallback)Mockito.verify(preCommitCallback1)).onSuccess((Object)cohort1.getCandidate());
        ((FutureCallback)Mockito.verify(canCommitCallback2)).onSuccess((Object)Empty.value());
        FutureCallback<DataTreeCandidate> preCommitCallback2 = ShardDataTreeMocking.coordinatedPreCommit(cohort2);
        ((FutureCallback)Mockito.verify(preCommitCallback2)).onSuccess((Object)cohort2.getCandidate());
        ((FutureCallback)Mockito.verify(canCommitCallback3)).onSuccess((Object)Empty.value());
        FutureCallback<DataTreeCandidate> preCommitCallback3 = ShardDataTreeMocking.coordinatedPreCommit(cohort3);
        ((FutureCallback)Mockito.verify(preCommitCallback3)).onSuccess((Object)cohort3.getCandidate());
        ((FutureCallback)Mockito.verify(canCommitCallback4)).onSuccess((Object)Empty.value());
        FutureCallback<DataTreeCandidate> preCommitCallback4 = ShardDataTreeMocking.coordinatedPreCommit(cohort4);
        ((FutureCallback)Mockito.verify(preCommitCallback4)).onSuccess((Object)cohort4.getCandidate());
        FutureCallback<UnsignedLong> commitCallback2 = ShardDataTreeMocking.coordinatedCommit(cohort2);
        ((Shard)Mockito.verify((Object)this.mockShard, (VerificationMode)Mockito.never())).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort1.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.anyBoolean());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{commitCallback2});
        FutureCallback<UnsignedLong> commitCallback4 = ShardDataTreeMocking.coordinatedCommit(cohort4);
        ((Shard)Mockito.verify((Object)this.mockShard, (VerificationMode)Mockito.never())).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort4.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.anyBoolean());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{commitCallback4});
        FutureCallback<UnsignedLong> commitCallback1 = ShardDataTreeMocking.coordinatedCommit(cohort1);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockShard});
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort1.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)true));
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort2.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)false));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{commitCallback1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{commitCallback2});
        FutureCallback<UnsignedLong> commitCallback3 = ShardDataTreeMocking.coordinatedCommit(cohort3);
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockShard});
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort3.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)true));
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort4.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)false));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{commitCallback3});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{commitCallback4});
        ShardDataTreeCohort cohort5 = this.newShardDataTreeCohort(snapshot -> snapshot.merge(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()));
        FutureCallback<Empty> canCommitCallback5 = ShardDataTreeMocking.coordinatedCanCommit(cohort5);
        CommitTransactionPayload mockPayload = CommitTransactionPayload.create((TransactionIdentifier)ShardDataTreeTest.nextTransactionId(), (DataTreeCandidate)cohort1.getCandidate());
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort1.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort2.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort3.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort4.getIdentifier(), (Payload)mockPayload);
        inOrder = Mockito.inOrder((Object[])new Object[]{commitCallback1, commitCallback2, commitCallback3, commitCallback4});
        ((FutureCallback)inOrder.verify(commitCallback1)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback2)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback3)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback4)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)Mockito.verify(canCommitCallback5)).onSuccess((Object)Empty.value());
        DataTreeSnapshot snapshot2 = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        Assert.assertEquals((String)"Car node", Optional.of(carNode), (Object)snapshot2.readNode(carPath));
        Assert.assertEquals((String)"People node", Optional.of(peopleNode), (Object)snapshot2.readNode(PeopleModel.BASE_PATH));
    }

    @Test
    public void testPipelinedTransactionsWithImmediateCommits() throws Exception {
        ShardDataTreeCohort cohort1 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()));
        ShardDataTreeCohort cohort2 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()));
        YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
        MapEntryNode carNode = CarsModel.newCarEntry("optima", Uint64.valueOf((int)100));
        ShardDataTreeCohort cohort3 = this.newShardDataTreeCohort(snapshot -> snapshot.write(carPath, (NormalizedNode)carNode));
        FutureCallback<UnsignedLong> commitCallback2 = ShardDataTreeMocking.immediate3PhaseCommit(cohort2);
        FutureCallback<UnsignedLong> commitCallback3 = ShardDataTreeMocking.immediate3PhaseCommit(cohort3);
        FutureCallback<UnsignedLong> commitCallback1 = ShardDataTreeMocking.immediate3PhaseCommit(cohort1);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockShard});
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort1.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)true));
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort2.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)true));
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort3.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)false));
        CommitTransactionPayload mockPayload = CommitTransactionPayload.create((TransactionIdentifier)ShardDataTreeTest.nextTransactionId(), (DataTreeCandidate)cohort1.getCandidate());
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort1.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort2.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort3.getIdentifier(), (Payload)mockPayload);
        inOrder = Mockito.inOrder((Object[])new Object[]{commitCallback1, commitCallback2, commitCallback3});
        ((FutureCallback)inOrder.verify(commitCallback1)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback2)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback3)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        DataTreeSnapshot snapshot2 = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        Assert.assertEquals((String)"Car node", Optional.of(carNode), (Object)snapshot2.readNode(carPath));
    }

    @Test
    public void testPipelinedTransactionsWithImmediateReplication() {
        ShardDataTreeMocking.immediatePayloadReplication(this.shardDataTree, this.mockShard);
        ShardDataTreeCohort cohort1 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()));
        ShardDataTreeCohort cohort2 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()));
        YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
        MapEntryNode carNode = CarsModel.newCarEntry("optima", Uint64.valueOf((int)100));
        ShardDataTreeCohort cohort3 = this.newShardDataTreeCohort(snapshot -> snapshot.write(carPath, (NormalizedNode)carNode));
        FutureCallback<UnsignedLong> commitCallback1 = ShardDataTreeMocking.immediate3PhaseCommit(cohort1);
        FutureCallback<UnsignedLong> commitCallback2 = ShardDataTreeMocking.immediate3PhaseCommit(cohort2);
        FutureCallback<UnsignedLong> commitCallback3 = ShardDataTreeMocking.immediate3PhaseCommit(cohort3);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{commitCallback1, commitCallback2, commitCallback3});
        ((FutureCallback)inOrder.verify(commitCallback1)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback2)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)inOrder.verify(commitCallback3)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        DataTreeSnapshot snapshot2 = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        Optional optional = snapshot2.readNode(CarsModel.BASE_PATH);
        Assert.assertTrue((String)"Car node present", (boolean)optional.isPresent());
    }

    @Test
    public void testAbortWithPendingCommits() throws Exception {
        ShardDataTreeCohort cohort1 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()));
        ShardDataTreeCohort cohort2 = this.newShardDataTreeCohort(snapshot -> snapshot.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.create()));
        ShardDataTreeCohort cohort3 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()));
        YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
        MapEntryNode carNode = CarsModel.newCarEntry("optima", Uint64.valueOf((int)100));
        ShardDataTreeCohort cohort4 = this.newShardDataTreeCohort(snapshot -> snapshot.write(carPath, (NormalizedNode)carNode));
        ShardDataTreeMocking.coordinatedCanCommit(cohort2);
        ShardDataTreeMocking.immediateCanCommit(cohort1);
        ShardDataTreeMocking.coordinatedCanCommit(cohort3);
        ShardDataTreeMocking.coordinatedCanCommit(cohort4);
        ShardDataTreeMocking.coordinatedPreCommit(cohort1);
        ShardDataTreeMocking.coordinatedPreCommit(cohort2);
        ShardDataTreeMocking.coordinatedPreCommit(cohort3);
        FutureCallback mockAbortCallback = (FutureCallback)Mockito.mock(FutureCallback.class);
        ((FutureCallback)Mockito.doNothing().when((Object)mockAbortCallback)).onSuccess((Object)Empty.value());
        cohort2.abort(mockAbortCallback);
        ((FutureCallback)Mockito.verify((Object)mockAbortCallback)).onSuccess((Object)Empty.value());
        ShardDataTreeMocking.coordinatedPreCommit(cohort4);
        ShardDataTreeMocking.coordinatedCommit(cohort1);
        ShardDataTreeMocking.coordinatedCommit(cohort3);
        ShardDataTreeMocking.coordinatedCommit(cohort4);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockShard});
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort1.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)false));
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort3.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)false));
        ((Shard)inOrder.verify((Object)this.mockShard)).persistPayload((Identifier)ArgumentMatchers.eq((Object)((TransactionIdentifier)cohort4.getIdentifier())), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.eq((boolean)false));
        CommitTransactionPayload mockPayload = CommitTransactionPayload.create((TransactionIdentifier)ShardDataTreeTest.nextTransactionId(), (DataTreeCandidate)cohort1.getCandidate());
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort1.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort3.getIdentifier(), (Payload)mockPayload);
        this.shardDataTree.applyReplicatedPayload((Identifier)cohort4.getIdentifier(), (Payload)mockPayload);
        DataTreeSnapshot snapshot2 = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        Optional optional = snapshot2.readNode(carPath);
        Assert.assertEquals((String)"Car node", Optional.of(carNode), (Object)optional);
    }

    @Test
    public void testAbortWithFailedRebase() {
        ShardDataTreeMocking.immediatePayloadReplication(this.shardDataTree, this.mockShard);
        ShardDataTreeCohort cohort1 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()));
        ShardDataTreeCohort cohort2 = this.newShardDataTreeCohort(snapshot -> snapshot.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()));
        ContainerNode peopleNode = PeopleModel.create();
        ShardDataTreeCohort cohort3 = this.newShardDataTreeCohort(arg_0 -> ShardDataTreeTest.lambda$testAbortWithFailedRebase$21((NormalizedNode)peopleNode, arg_0));
        ShardDataTreeMocking.immediateCanCommit(cohort1);
        FutureCallback<Empty> canCommitCallback2 = ShardDataTreeMocking.coordinatedCanCommit(cohort2);
        ShardDataTreeMocking.coordinatedPreCommit(cohort1);
        ((FutureCallback)Mockito.verify(canCommitCallback2)).onSuccess((Object)Empty.value());
        FutureCallback mockAbortCallback = (FutureCallback)Mockito.mock(FutureCallback.class);
        ((FutureCallback)Mockito.doNothing().when((Object)mockAbortCallback)).onSuccess((Object)Empty.value());
        cohort1.abort(mockAbortCallback);
        ((FutureCallback)Mockito.verify((Object)mockAbortCallback)).onSuccess((Object)Empty.value());
        FutureCallback<DataTreeCandidate> preCommitCallback2 = ShardDataTreeMocking.coordinatedPreCommit(cohort2);
        ((FutureCallback)Mockito.verify(preCommitCallback2)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        ShardDataTreeMocking.immediateCanCommit(cohort3);
        ShardDataTreeMocking.immediatePreCommit(cohort3);
        ShardDataTreeMocking.immediateCommit(cohort3);
        DataTreeSnapshot snapshot2 = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        Optional optional = snapshot2.readNode(PeopleModel.BASE_PATH);
        Assert.assertEquals((String)"People node", Optional.of(peopleNode), (Object)optional);
    }

    @Test
    public void testUintCommitPayload() throws IOException {
        this.shardDataTree.applyRecoveryPayload((Payload)CommitTransactionPayload.create((TransactionIdentifier)ShardDataTreeTest.nextTransactionId(), (DataTreeCandidate)DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.empty(), (NormalizedNode)ShardDataTreeTest.bigIntegerRoot()), (PayloadVersion)PayloadVersion.SODIUM_SR1));
        this.assertCarsUint64();
    }

    @Test
    public void testUintSnapshot() throws IOException, DataValidationFailedException {
        this.shardDataTree.applyRecoverySnapshot(new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot((NormalizedNode)ShardDataTreeTest.bigIntegerRoot()), true));
        this.assertCarsUint64();
    }

    @Test
    public void testUintReplay() throws DataValidationFailedException, IOException {
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, this.fullSchema);
        DataTreeModification mod = dataTree.takeSnapshot().newModification();
        mod.write(CarsModel.BASE_PATH, Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.BASE_QNAME)).withChild((DataContainerChild)Builders.mapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CarsModel.CAR_QNAME)).withChild((NormalizedNode)ShardDataTreeTest.createCar("one", BigInteger.ONE)).build()).build());
        mod.ready();
        dataTree.validate(mod);
        DataTreeCandidateTip first = dataTree.prepare(mod);
        dataTree.commit((DataTreeCandidate)first);
        mod = dataTree.takeSnapshot().newModification();
        mod.write(CarsModel.newCarPath("two"), (NormalizedNode)ShardDataTreeTest.createCar("two", BigInteger.TWO));
        mod.ready();
        dataTree.validate(mod);
        DataTreeCandidateTip second = dataTree.prepare(mod);
        dataTree.commit((DataTreeCandidate)second);
        mod = dataTree.takeSnapshot().newModification();
        mod.merge(CarsModel.CAR_LIST_PATH, Builders.mapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CarsModel.CAR_QNAME)).withChild((NormalizedNode)ShardDataTreeTest.createCar("three", BigInteger.TEN)).build());
        mod.ready();
        dataTree.validate(mod);
        DataTreeCandidateTip third = dataTree.prepare(mod);
        dataTree.commit((DataTreeCandidate)third);
        this.shardDataTree.applyRecoverySnapshot(new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot((NormalizedNode)first.getRootNode().getDataAfter().orElseThrow()), true));
        this.shardDataTree.applyRecoveryPayload((Payload)CommitTransactionPayload.create((TransactionIdentifier)ShardDataTreeTest.nextTransactionId(), (DataTreeCandidate)second, (PayloadVersion)PayloadVersion.SODIUM_SR1));
        this.shardDataTree.applyRecoveryPayload((Payload)CommitTransactionPayload.create((TransactionIdentifier)ShardDataTreeTest.nextTransactionId(), (DataTreeCandidate)third, (PayloadVersion)PayloadVersion.SODIUM_SR1));
        DataTreeSnapshot snapshot = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        Assert.assertEquals((Object)Builders.mapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CarsModel.CAR_QNAME)).withChild((NormalizedNode)ShardDataTreeTest.createCar("one", Uint64.ONE)).withChild((NormalizedNode)ShardDataTreeTest.createCar("two", Uint64.TWO)).withChild((NormalizedNode)ShardDataTreeTest.createCar("three", Uint64.TEN)).build(), snapshot.readNode(CarsModel.CAR_LIST_PATH).orElseThrow());
    }

    private void assertCarsUint64() {
        DataTreeSnapshot snapshot = this.shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId()).getSnapshot();
        NormalizedNode cars = (NormalizedNode)snapshot.readNode(CarsModel.CAR_LIST_PATH).orElseThrow();
        Assert.assertEquals((Object)Builders.mapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CarsModel.CAR_QNAME)).withChild((NormalizedNode)ShardDataTreeTest.createCar("foo", Uint64.ONE)).build(), (Object)cars);
    }

    private static ContainerNode bigIntegerRoot() {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(SchemaContext.NAME)).withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.CARS_QNAME)).withChild((DataContainerChild)Builders.mapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(CarsModel.CAR_QNAME)).withChild((NormalizedNode)ShardDataTreeTest.createCar("foo", BigInteger.ONE)).build()).build()).build();
    }

    private static MapEntryNode createCar(String name, Object value) {
        return (MapEntryNode)Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)CarsModel.CAR_QNAME, (QName)CarsModel.CAR_NAME_QNAME, (Object)name)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CarsModel.CAR_NAME_QNAME, (Object)name)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CarsModel.CAR_PRICE_QNAME, (Object)value)).build();
    }

    private ShardDataTreeCohort newShardDataTreeCohort(DataTreeOperation operation) {
        ReadWriteShardDataTreeTransaction transaction = this.shardDataTree.newReadWriteTransaction(ShardDataTreeTest.nextTransactionId());
        DataTreeModification snapshot = (DataTreeModification)transaction.getSnapshot();
        operation.execute(snapshot);
        return this.shardDataTree.finishTransaction(transaction, Optional.empty());
    }

    private static void verifyOnDataTreeChanged(DOMDataTreeChangeListener listener, Consumer<DataTreeCandidate> callback) {
        ArgumentCaptor changes = ArgumentCaptor.forClass(List.class);
        ((DOMDataTreeChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).onDataTreeChanged((List)changes.capture());
        for (Collection list : changes.getAllValues()) {
            for (Object dtc : list) {
                callback.accept((DataTreeCandidate)dtc);
            }
        }
        Mockito.reset((Object[])new DOMDataTreeChangeListener[]{listener});
    }

    private static NormalizedNode getCars(ShardDataTree shardDataTree) {
        ReadOnlyShardDataTreeTransaction readOnlyShardDataTreeTransaction = shardDataTree.newReadOnlyTransaction(ShardDataTreeTest.nextTransactionId());
        DataTreeSnapshot snapshot1 = readOnlyShardDataTreeTransaction.getSnapshot();
        Optional optional = snapshot1.readNode(CarsModel.BASE_PATH);
        Assert.assertTrue((boolean)optional.isPresent());
        return (NormalizedNode)optional.orElseThrow();
    }

    private static DataTreeCandidate addCar(ShardDataTree shardDataTree) {
        return ShardDataTreeTest.addCar(shardDataTree, "altima");
    }

    private static DataTreeCandidate addCar(ShardDataTree shardDataTree, String name) {
        return ShardDataTreeTest.doTransaction(shardDataTree, snapshot -> {
            snapshot.merge(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            snapshot.merge(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            snapshot.write(CarsModel.newCarPath(name), (NormalizedNode)CarsModel.newCarEntry(name, Uint64.valueOf((int)100)));
        });
    }

    private static DataTreeCandidate removeCar(ShardDataTree shardDataTree) {
        return ShardDataTreeTest.doTransaction(shardDataTree, snapshot -> snapshot.delete(CarsModel.newCarPath("altima")));
    }

    private static DataTreeCandidate doTransaction(ShardDataTree shardDataTree, DataTreeOperation operation) {
        ReadWriteShardDataTreeTransaction transaction = shardDataTree.newReadWriteTransaction(ShardDataTreeTest.nextTransactionId());
        DataTreeModification snapshot = (DataTreeModification)transaction.getSnapshot();
        operation.execute(snapshot);
        ShardDataTreeCohort cohort = shardDataTree.finishTransaction(transaction, Optional.empty());
        ShardDataTreeMocking.immediateCanCommit(cohort);
        ShardDataTreeMocking.immediatePreCommit(cohort);
        DataTreeCandidateTip candidate = cohort.getCandidate();
        ShardDataTreeMocking.immediateCommit(cohort);
        return candidate;
    }

    private static DataTreeCandidate applyCandidates(ShardDataTree shardDataTree, List<DataTreeCandidate> candidates) {
        ReadWriteShardDataTreeTransaction transaction = shardDataTree.newReadWriteTransaction(ShardDataTreeTest.nextTransactionId());
        DataTreeModification snapshot = (DataTreeModification)transaction.getSnapshot();
        for (DataTreeCandidate candidateTip : candidates) {
            DataTreeCandidates.applyToModification((DataTreeModification)snapshot, (DataTreeCandidate)candidateTip);
        }
        ShardDataTreeCohort cohort = shardDataTree.finishTransaction(transaction, Optional.empty());
        ShardDataTreeMocking.immediateCanCommit(cohort);
        ShardDataTreeMocking.immediatePreCommit(cohort);
        DataTreeCandidateTip candidate = cohort.getCandidate();
        ShardDataTreeMocking.immediateCommit(cohort);
        return candidate;
    }

    private static /* synthetic */ void lambda$testAbortWithFailedRebase$21(NormalizedNode peopleNode, DataTreeModification snapshot) {
        snapshot.write(PeopleModel.BASE_PATH, peopleNode);
    }

    private static /* synthetic */ void lambda$testPipelinedTransactionsWithCoordinatedCommits$6(NormalizedNode peopleNode, DataTreeModification snapshot) {
        snapshot.write(PeopleModel.BASE_PATH, peopleNode);
    }

    @FunctionalInterface
    private static interface DataTreeOperation {
        public void execute(DataTreeModification var1);
    }
}

