/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import akka.actor.Terminated;
import akka.dispatch.Dispatchers;
import akka.testkit.TestActorRef;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Throwables;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ReadOnlyShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.ShardTestKit;
import org.opendaylight.controller.cluster.datastore.ShardTransaction;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModificationsReply;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.DataExistsReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.cluster.datastore.messages.ReadDataReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadyTransactionReply;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.raft.TestActorFactory;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public class ShardTransactionTest
extends AbstractActorTest {
    private static final TransactionType RO = TransactionType.READ_ONLY;
    private static final TransactionType RW = TransactionType.READ_WRITE;
    private static final TransactionType WO = TransactionType.WRITE_ONLY;
    private static final ShardIdentifier SHARD_IDENTIFIER = ShardIdentifier.create((String)"inventory", (MemberName)MEMBER_NAME, (String)"config");
    private static final EffectiveModelContext TEST_MODEL = TestModel.createTestContext();
    private DatastoreContext datastoreContext = DatastoreContext.newBuilder().persistent(false).build();
    private final TestActorFactory actorFactory = new TestActorFactory(ShardTransactionTest.getSystem());
    private TestActorRef<Shard> shard;
    private ShardDataTree store;
    private TestKit testKit;

    @Before
    public void setUp() {
        this.shard = this.actorFactory.createTestActor(((Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(SHARD_IDENTIFIER)).datastoreContext(this.datastoreContext)).schemaContextProvider(() -> TEST_MODEL)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader(this.shard);
        this.store = ((Shard)this.shard.underlyingActor()).getDataStore();
        this.testKit = new TestKit(ShardTransactionTest.getSystem());
    }

    private ActorRef newTransactionActor(TransactionType type, AbstractShardDataTreeTransaction<?> transaction, String name) {
        Props props = ShardTransaction.props((TransactionType)type, transaction, this.shard, (DatastoreContext)this.datastoreContext, (ShardStats)((Shard)this.shard.underlyingActor()).getShardMBean());
        return this.actorFactory.createActorNoVerify(props, name);
    }

    private ReadOnlyShardDataTreeTransaction readOnlyTransaction() {
        return this.store.newReadOnlyTransaction(ShardTransactionTest.nextTransactionId());
    }

    private ReadWriteShardDataTreeTransaction readWriteTransaction() {
        return this.store.newReadWriteTransaction(ShardTransactionTest.nextTransactionId());
    }

    @Test
    public void testOnReceiveReadData() {
        this.testOnReceiveReadData(this.newTransactionActor(RO, (AbstractShardDataTreeTransaction<?>)this.readOnlyTransaction(), "testReadDataRO"));
        this.testOnReceiveReadData(this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testReadDataRW"));
    }

    private void testOnReceiveReadData(ActorRef transaction) {
        transaction.tell((Object)new ReadData(YangInstanceIdentifier.empty(), 12), this.testKit.getRef());
        ReadDataReply reply = (ReadDataReply)this.testKit.expectMsgClass(Duration.ofSeconds(5L), ReadDataReply.class);
        Assert.assertNotNull((Object)reply.getNormalizedNode());
    }

    @Test
    public void testOnReceiveReadDataWhenDataNotFound() {
        this.testOnReceiveReadDataWhenDataNotFound(this.newTransactionActor(RO, (AbstractShardDataTreeTransaction<?>)this.readOnlyTransaction(), "testReadDataWhenDataNotFoundRO"));
        this.testOnReceiveReadDataWhenDataNotFound(this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testReadDataWhenDataNotFoundRW"));
    }

    private void testOnReceiveReadDataWhenDataNotFound(ActorRef transaction) {
        transaction.tell((Object)new ReadData(TestModel.TEST_PATH, 12), this.testKit.getRef());
        ReadDataReply reply = (ReadDataReply)this.testKit.expectMsgClass(Duration.ofSeconds(5L), ReadDataReply.class);
        Assert.assertNull((Object)reply.getNormalizedNode());
    }

    @Test
    public void testOnReceiveDataExistsPositive() {
        this.testOnReceiveDataExistsPositive(this.newTransactionActor(RO, (AbstractShardDataTreeTransaction<?>)this.readOnlyTransaction(), "testDataExistsPositiveRO"));
        this.testOnReceiveDataExistsPositive(this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testDataExistsPositiveRW"));
    }

    private void testOnReceiveDataExistsPositive(ActorRef transaction) {
        transaction.tell((Object)new DataExists(YangInstanceIdentifier.empty(), 12), this.testKit.getRef());
        DataExistsReply reply = (DataExistsReply)this.testKit.expectMsgClass(Duration.ofSeconds(5L), DataExistsReply.class);
        Assert.assertTrue((boolean)reply.exists());
    }

    @Test
    public void testOnReceiveDataExistsNegative() {
        this.testOnReceiveDataExistsNegative(this.newTransactionActor(RO, (AbstractShardDataTreeTransaction<?>)this.readOnlyTransaction(), "testDataExistsNegativeRO"));
        this.testOnReceiveDataExistsNegative(this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testDataExistsNegativeRW"));
    }

    private void testOnReceiveDataExistsNegative(ActorRef transaction) {
        transaction.tell((Object)new DataExists(TestModel.TEST_PATH, 12), this.testKit.getRef());
        DataExistsReply reply = (DataExistsReply)this.testKit.expectMsgClass(Duration.ofSeconds(5L), DataExistsReply.class);
        Assert.assertFalse((boolean)reply.exists());
    }

    @Test
    public void testOnReceiveBatchedModifications() {
        ShardDataTreeTransactionParent parent = (ShardDataTreeTransactionParent)Mockito.mock(ShardDataTreeTransactionParent.class);
        DataTreeModification mockModification = (DataTreeModification)Mockito.mock(DataTreeModification.class);
        ReadWriteShardDataTreeTransaction mockWriteTx = new ReadWriteShardDataTreeTransaction(parent, ShardTransactionTest.nextTransactionId(), mockModification);
        ActorRef transaction = this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)mockWriteTx, "testOnReceiveBatchedModifications");
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        YangInstanceIdentifier mergePath = TestModel.OUTER_LIST_PATH;
        NormalizedNode mergeData = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.OUTER_LIST_QNAME)).build();
        YangInstanceIdentifier deletePath = TestModel.TEST_PATH;
        BatchedModifications batched = new BatchedModifications(ShardTransactionTest.nextTransactionId(), 12);
        batched.addModification((Modification)new WriteModification(writePath, writeData));
        batched.addModification((Modification)new MergeModification(mergePath, mergeData));
        batched.addModification((Modification)new DeleteModification(deletePath));
        transaction.tell((Object)batched, this.testKit.getRef());
        BatchedModificationsReply reply = (BatchedModificationsReply)this.testKit.expectMsgClass(Duration.ofSeconds(5L), BatchedModificationsReply.class);
        Assert.assertEquals((String)"getNumBatched", (long)3L, (long)reply.getNumBatched());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockModification});
        ((DataTreeModification)inOrder.verify((Object)mockModification)).write(writePath, writeData);
        ((DataTreeModification)inOrder.verify((Object)mockModification)).merge(mergePath, mergeData);
        ((DataTreeModification)inOrder.verify((Object)mockModification)).delete(deletePath);
    }

    @Test
    public void testOnReceiveBatchedModificationsReadyWithoutImmediateCommit() {
        ActorRef transaction = this.newTransactionActor(WO, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testOnReceiveBatchedModificationsReadyWithoutImmediateCommit");
        TestKit watcher = new TestKit(ShardTransactionTest.getSystem());
        watcher.watch(transaction);
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        TransactionIdentifier tx1 = ShardTransactionTest.nextTransactionId();
        BatchedModifications batched = new BatchedModifications(tx1, 12);
        batched.addModification((Modification)new WriteModification(writePath, writeData));
        transaction.tell((Object)batched, this.testKit.getRef());
        BatchedModificationsReply reply = (BatchedModificationsReply)this.testKit.expectMsgClass(Duration.ofSeconds(5L), BatchedModificationsReply.class);
        Assert.assertEquals((String)"getNumBatched", (long)1L, (long)reply.getNumBatched());
        batched = new BatchedModifications(tx1, 12);
        batched.setReady();
        batched.setTotalMessagesSent(2);
        transaction.tell((Object)batched, this.testKit.getRef());
        this.testKit.expectMsgClass(Duration.ofSeconds(5L), ReadyTransactionReply.class);
        watcher.expectMsgClass(Duration.ofSeconds(5L), Terminated.class);
    }

    @Test
    public void testOnReceiveBatchedModificationsReadyWithImmediateCommit() {
        ActorRef transaction = this.newTransactionActor(WO, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testOnReceiveBatchedModificationsReadyWithImmediateCommit");
        TestKit watcher = new TestKit(ShardTransactionTest.getSystem());
        watcher.watch(transaction);
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        BatchedModifications batched = new BatchedModifications(ShardTransactionTest.nextTransactionId(), 12);
        batched.addModification((Modification)new WriteModification(writePath, writeData));
        batched.setReady();
        batched.setDoCommitOnReady(true);
        batched.setTotalMessagesSent(1);
        transaction.tell((Object)batched, this.testKit.getRef());
        this.testKit.expectMsgClass(Duration.ofSeconds(5L), CommitTransactionReply.class);
        watcher.expectMsgClass(Duration.ofSeconds(5L), Terminated.class);
    }

    @Test(expected=TestException.class)
    public void testOnReceiveBatchedModificationsFailure() throws Exception {
        ShardDataTreeTransactionParent parent = (ShardDataTreeTransactionParent)Mockito.mock(ShardDataTreeTransactionParent.class);
        DataTreeModification mockModification = (DataTreeModification)Mockito.mock(DataTreeModification.class);
        ReadWriteShardDataTreeTransaction mockWriteTx = new ReadWriteShardDataTreeTransaction(parent, ShardTransactionTest.nextTransactionId(), mockModification);
        ActorRef transaction = this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)mockWriteTx, "testOnReceiveBatchedModificationsFailure");
        TestKit watcher = new TestKit(ShardTransactionTest.getSystem());
        watcher.watch(transaction);
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        ContainerNode node = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        ((DataTreeModification)Mockito.doThrow((Throwable[])new Throwable[]{new TestException()}).when((Object)mockModification)).write(path, (NormalizedNode)node);
        TransactionIdentifier tx1 = ShardTransactionTest.nextTransactionId();
        BatchedModifications batched = new BatchedModifications(tx1, 12);
        batched.addModification((Modification)new WriteModification(path, (NormalizedNode)node));
        transaction.tell((Object)batched, this.testKit.getRef());
        this.testKit.expectMsgClass(Duration.ofSeconds(5L), Status.Failure.class);
        batched = new BatchedModifications(tx1, 12);
        batched.setReady();
        batched.setTotalMessagesSent(2);
        transaction.tell((Object)batched, this.testKit.getRef());
        Status.Failure failure = (Status.Failure)this.testKit.expectMsgClass(Duration.ofSeconds(5L), Status.Failure.class);
        watcher.expectMsgClass(Duration.ofSeconds(5L), Terminated.class);
        if (failure != null) {
            Throwables.propagateIfPossible((Throwable)failure.cause(), Exception.class);
            throw new RuntimeException(failure.cause());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testOnReceiveBatchedModificationsReadyWithIncorrectTotalMessageCount() throws Exception {
        ActorRef transaction = this.newTransactionActor(WO, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testOnReceiveBatchedModificationsReadyWithIncorrectTotalMessageCount");
        TestKit watcher = new TestKit(ShardTransactionTest.getSystem());
        watcher.watch(transaction);
        BatchedModifications batched = new BatchedModifications(ShardTransactionTest.nextTransactionId(), 12);
        batched.setReady();
        batched.setTotalMessagesSent(2);
        transaction.tell((Object)batched, this.testKit.getRef());
        Status.Failure failure = (Status.Failure)this.testKit.expectMsgClass(Duration.ofSeconds(5L), Status.Failure.class);
        watcher.expectMsgClass(Duration.ofSeconds(5L), Terminated.class);
        if (failure != null) {
            Throwables.throwIfInstanceOf((Throwable)failure.cause(), Exception.class);
            Throwables.throwIfUnchecked((Throwable)failure.cause());
            throw new RuntimeException(failure.cause());
        }
    }

    @Test
    public void testReadWriteTxOnReceiveCloseTransaction() {
        ActorRef transaction = this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testReadWriteTxOnReceiveCloseTransaction");
        this.testKit.watch(transaction);
        transaction.tell(new CloseTransaction().toSerializable(), this.testKit.getRef());
        this.testKit.expectMsgClass(Duration.ofSeconds(3L), CloseTransactionReply.class);
        this.testKit.expectTerminated(Duration.ofSeconds(3L), transaction);
    }

    @Test
    public void testWriteOnlyTxOnReceiveCloseTransaction() {
        ActorRef transaction = this.newTransactionActor(WO, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testWriteTxOnReceiveCloseTransaction");
        this.testKit.watch(transaction);
        transaction.tell(new CloseTransaction().toSerializable(), this.testKit.getRef());
        this.testKit.expectMsgClass(Duration.ofSeconds(3L), CloseTransactionReply.class);
        this.testKit.expectTerminated(Duration.ofSeconds(3L), transaction);
    }

    @Test
    public void testReadOnlyTxOnReceiveCloseTransaction() {
        ActorRef transaction = this.newTransactionActor(TransactionType.READ_ONLY, (AbstractShardDataTreeTransaction<?>)this.readOnlyTransaction(), "testReadOnlyTxOnReceiveCloseTransaction");
        this.testKit.watch(transaction);
        transaction.tell(new CloseTransaction().toSerializable(), this.testKit.getRef());
        this.testKit.expectMsgClass(Duration.ofSeconds(3L), Terminated.class);
    }

    @Test
    public void testShardTransactionInactivity() {
        this.datastoreContext = DatastoreContext.newBuilder().shardTransactionIdleTimeout(500L, TimeUnit.MILLISECONDS).build();
        ActorRef transaction = this.newTransactionActor(RW, (AbstractShardDataTreeTransaction<?>)this.readWriteTransaction(), "testShardTransactionInactivity");
        this.testKit.watch(transaction);
        this.testKit.expectMsgClass(Duration.ofSeconds(3L), Terminated.class);
    }

    public static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

