/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;

public class TestShard
extends Shard {
    private final Map<Class<?>, Predicate<?>> dropMessages = new ConcurrentHashMap();

    protected TestShard(Shard.AbstractBuilder<?, ?> builder) {
        super(builder);
    }

    protected void handleNonRaftCommand(Object message) {
        if (message instanceof RequestFrontendMetadata) {
            FrontendShardDataTreeSnapshotMetadata metadataSnapshot = this.frontendMetadata.toSnapshot();
            this.sender().tell((Object)metadataSnapshot, this.self());
        } else {
            super.handleNonRaftCommand(message);
        }
    }

    protected void handleCommand(Object message) {
        if (message instanceof StartDropMessages) {
            this.startDropMessages(((StartDropMessages)message).getMsgClass());
        } else if (message instanceof StopDropMessages) {
            this.stopDropMessages(((StopDropMessages)message).getMsgClass());
        } else {
            this.dropOrHandle(message);
        }
    }

    private <T> void dropOrHandle(T message) {
        Predicate<?> drop = this.dropMessages.get(message.getClass());
        if (drop == null || !drop.test(message)) {
            super.handleCommand(message);
        }
    }

    private void startDropMessages(Class<?> msgClass) {
        this.dropMessages.put(msgClass, msg -> true);
    }

    <T> void startDropMessages(Class<T> msgClass, Predicate<T> filter) {
        this.dropMessages.put(msgClass, filter);
    }

    public void stopDropMessages(Class<?> msgClass) {
        this.dropMessages.remove(msgClass);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class RequestFrontendMetadata {
    }

    public static class StartDropMessages<T>
    extends DropMessages<T> {
        public StartDropMessages(Class<T> msgClass) {
            super(msgClass);
        }
    }

    public static class StopDropMessages<T>
    extends DropMessages<T> {
        public StopDropMessages(Class<T> msgClass) {
            super(msgClass);
        }
    }

    public static class Builder
    extends Shard.Builder {
        Builder() {
            super(TestShard.class);
        }
    }

    private static abstract class DropMessages<T> {
        private final Class<T> msgClass;

        DropMessages(Class<T> msgClass) {
            this.msgClass = Objects.requireNonNull(msgClass);
        }

        final Class<T> getMsgClass() {
            return this.msgClass;
        }
    }
}

