/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.dispatch.Futures;
import akka.util.Timeout;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContextFactory;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionProxyTest;
import org.opendaylight.controller.cluster.datastore.DebugThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.SingleCommitCohortProxy;
import org.opendaylight.controller.cluster.datastore.ThreePhaseCommitCohortProxy;
import org.opendaylight.controller.cluster.datastore.TransactionProxy;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.exceptions.PrimaryNotFoundException;
import org.opendaylight.controller.cluster.datastore.exceptions.TimeoutException;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.NormalizedNodeAggregatorTest;
import org.opendaylight.controller.cluster.raft.utils.DoNothingActor;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import scala.concurrent.Promise;

public class TransactionProxyTest
extends AbstractTransactionProxyTest {
    @Test
    public void testRead() throws Exception {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        ((ActorUtils)Mockito.doReturn(this.readDataReply(null)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Assert.assertEquals(Optional.empty(), (Object)transactionProxy.read(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS));
        ContainerNode expectedNode = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        ((ActorUtils)Mockito.doReturn(this.readDataReply((NormalizedNode)expectedNode)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Assert.assertEquals(Optional.of(expectedNode), (Object)transactionProxy.read(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS));
    }

    @Test(expected=ReadFailedException.class)
    public void testReadWithInvalidReplyMessageType() throws Throwable {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)new Object())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        try {
            transactionProxy.read(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=TestException.class)
    public void testReadWithAsyncRemoteOperatonFailure() throws Throwable {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new TestException())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        this.propagateReadFailedExceptionCause(transactionProxy.read(TestModel.TEST_PATH));
    }

    private void testExceptionOnInitialCreateTransaction(Exception exToThrow, Invoker invoker) throws Throwable {
        ActorRef actorRef = this.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        if (exToThrow instanceof PrimaryNotFoundException) {
            ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)exToThrow)).when((Object)this.mockActorContext)).findPrimaryShardAsync(ArgumentMatchers.anyString());
        } else {
            ((ActorUtils)Mockito.doReturn(this.primaryShardInfoReply(this.getSystem(), actorRef)).when((Object)this.mockActorContext)).findPrimaryShardAsync(ArgumentMatchers.anyString());
        }
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)exToThrow)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), ArgumentMatchers.any(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        this.propagateReadFailedExceptionCause(invoker.invoke(transactionProxy));
    }

    private void testReadWithExceptionOnInitialCreateTransaction(Exception exToThrow) throws Throwable {
        this.testExceptionOnInitialCreateTransaction(exToThrow, proxy -> proxy.read(TestModel.TEST_PATH));
    }

    @Test(expected=PrimaryNotFoundException.class)
    public void testReadWhenAPrimaryNotFoundExceptionIsThrown() throws Throwable {
        this.testReadWithExceptionOnInitialCreateTransaction((Exception)new PrimaryNotFoundException("test"));
    }

    @Test(expected=TestException.class)
    public void testReadWhenATimeoutExceptionIsThrown() throws Throwable {
        this.testReadWithExceptionOnInitialCreateTransaction((Exception)new TimeoutException("test", (Exception)new TestException()));
    }

    @Test(expected=TestException.class)
    public void testReadWhenAnyOtherExceptionIsThrown() throws Throwable {
        this.testReadWithExceptionOnInitialCreateTransaction(new TestException());
    }

    @Test
    public void testReadWithPriorRecordingOperationSuccessful() throws Exception {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        ContainerNode expectedNode = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectBatchedModifications(actorRef, 1);
        ((ActorUtils)Mockito.doReturn(this.readDataReply((NormalizedNode)expectedNode)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)expectedNode);
        Assert.assertEquals(Optional.of(expectedNode), (Object)transactionProxy.read(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockActorContext});
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    @Test
    public void testReadPreConditionCheck() {
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        Assert.assertThrows(IllegalStateException.class, () -> transactionProxy.read(TestModel.TEST_PATH));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCreateTransactionReply() throws Throwable {
        ActorRef actorRef = this.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().actorSelection(actorRef.path())).when((Object)this.mockActorContext)).actorSelection(actorRef.path().toString());
        ((ActorUtils)Mockito.doReturn(this.primaryShardInfoReply(this.getSystem(), actorRef)).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)new Object())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.getSystem().actorSelection(actorRef.path())), (Object)this.eqCreateTransaction("mock-member", TransactionType.READ_ONLY), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        this.propagateReadFailedExceptionCause(transactionProxy.read(TestModel.TEST_PATH));
    }

    @Test
    public void testExists() throws Exception {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        ((ActorUtils)Mockito.doReturn(this.dataExistsReply(false)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Boolean exists = (Boolean)transactionProxy.exists(TestModel.TEST_PATH).get();
        Assert.assertEquals((String)"Exists response", (Object)Boolean.FALSE, (Object)exists);
        ((ActorUtils)Mockito.doReturn(this.dataExistsReply(true)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
        exists = (Boolean)transactionProxy.exists(TestModel.TEST_PATH).get();
        Assert.assertEquals((String)"Exists response", (Object)Boolean.TRUE, (Object)exists);
    }

    @Test(expected=PrimaryNotFoundException.class)
    public void testExistsWhenAPrimaryNotFoundExceptionIsThrown() throws Throwable {
        this.testExceptionOnInitialCreateTransaction((Exception)new PrimaryNotFoundException("test"), proxy -> proxy.exists(TestModel.TEST_PATH));
    }

    @Test(expected=ReadFailedException.class)
    public void testExistsWithInvalidReplyMessageType() throws Throwable {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)new Object())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        try {
            transactionProxy.exists(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=TestException.class)
    public void testExistsWithAsyncRemoteOperatonFailure() throws Throwable {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new TestException())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        this.propagateReadFailedExceptionCause(transactionProxy.exists(TestModel.TEST_PATH));
    }

    @Test
    public void testExistsWithPriorRecordingOperationSuccessful() throws Exception {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectBatchedModifications(actorRef, 1);
        ((ActorUtils)Mockito.doReturn(this.dataExistsReply(true)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        Boolean exists = (Boolean)transactionProxy.exists(TestModel.TEST_PATH).get();
        Assert.assertEquals((String)"Exists response", (Object)Boolean.TRUE, (Object)exists);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockActorContext});
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testExistsPreConditionCheck() {
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.exists(TestModel.TEST_PATH);
    }

    @Test
    public void testWrite() {
        this.dataStoreContextBuilder.shardBatchedModificationCount(1);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectBatchedModifications(actorRef, 1);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        this.verifyOneBatchedModification(actorRef, (Modification)new WriteModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite), false);
    }

    @Test
    public void testWriteAfterAsyncRead() throws Exception {
        ActorRef actorRef = this.setupActorContextWithoutInitialCreateTransaction(this.getSystem(), "default");
        Promise createTxPromise = Futures.promise();
        ((ActorUtils)Mockito.doReturn((Object)createTxPromise).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.getSystem().actorSelection(actorRef.path())), (Object)this.eqCreateTransaction("mock-member", TransactionType.READ_WRITE), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)Mockito.doReturn(this.readDataReply(null)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        this.expectBatchedModificationsReady(actorRef);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        final TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        CountDownLatch readComplete = new CountDownLatch(1);
        AtomicReference caughtEx = new AtomicReference();
        com.google.common.util.concurrent.Futures.addCallback((ListenableFuture)transactionProxy.read(TestModel.TEST_PATH), (FutureCallback)new FutureCallback<Optional<NormalizedNode>>(){
            final /* synthetic */ NormalizedNode val$nodeToWrite;
            final /* synthetic */ AtomicReference val$caughtEx;
            final /* synthetic */ CountDownLatch val$readComplete;
            {
                this.val$nodeToWrite = normalizedNode;
                this.val$caughtEx = atomicReference;
                this.val$readComplete = countDownLatch;
            }

            public void onSuccess(Optional<NormalizedNode> result) {
                try {
                    transactionProxy.write(TestModel.TEST_PATH, this.val$nodeToWrite);
                }
                catch (Exception e) {
                    this.val$caughtEx.set(e);
                }
                finally {
                    this.val$readComplete.countDown();
                }
            }

            public void onFailure(Throwable failure) {
                this.val$caughtEx.set(failure);
                this.val$readComplete.countDown();
            }
        }, (Executor)MoreExecutors.directExecutor());
        createTxPromise.success((Object)this.createTransactionReply(actorRef, (short)12));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)readComplete, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Throwable t = (Throwable)caughtEx.get();
        if (t != null) {
            Throwables.propagateIfPossible((Throwable)t, Exception.class);
            throw new RuntimeException(t);
        }
        transactionProxy.ready();
        this.verifyOneBatchedModification(actorRef, (Modification)new WriteModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testWritePreConditionCheck() {
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteAfterReadyPreConditionCheck() {
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.ready();
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
    }

    @Test
    public void testMerge() {
        this.dataStoreContextBuilder.shardBatchedModificationCount(1);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectBatchedModifications(actorRef, 1);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        this.verifyOneBatchedModification(actorRef, (Modification)new MergeModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite), false);
    }

    @Test
    public void testDelete() {
        this.dataStoreContextBuilder.shardBatchedModificationCount(1);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        this.expectBatchedModifications(actorRef, 1);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.delete(TestModel.TEST_PATH);
        this.verifyOneBatchedModification(actorRef, (Modification)new DeleteModification(TestModel.TEST_PATH), false);
    }

    @Test
    public void testReadWrite() {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        ((ActorUtils)Mockito.doReturn(this.readDataReply(null)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        this.expectBatchedModifications(actorRef, 1);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.read(TestModel.TEST_PATH);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        transactionProxy.read(TestModel.TEST_PATH);
        transactionProxy.read(TestModel.TEST_PATH);
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)1L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), false, new Modification[]{new WriteModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite)});
    }

    @Test
    public void testReadyWithReadWrite() {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        ((ActorUtils)Mockito.doReturn(this.readDataReply(null)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        this.expectBatchedModificationsReady(actorRef, true);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.read(TestModel.TEST_PATH);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), new CommitTransactionReply().toSerializable());
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)1L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), true, true, new Modification[]{new WriteModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite)});
        Assert.assertEquals((String)"getTotalMessageCount", (long)1L, (long)batchedModifications.get(0).getTotalMessagesSent());
    }

    @Test
    public void testReadyWithNoModifications() {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        ((ActorUtils)Mockito.doReturn(this.readDataReply(null)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        this.expectBatchedModificationsReady(actorRef, true);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.read(TestModel.TEST_PATH);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), new CommitTransactionReply().toSerializable());
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)1L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), true, true, new Modification[0]);
    }

    @Test
    public void testReadyWithMultipleShardWrites() {
        ActorRef actorRef1 = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ActorRef actorRef2 = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY, TestModel.JUNK_QNAME.getLocalName());
        this.expectBatchedModificationsReady(actorRef1);
        this.expectBatchedModificationsReady(actorRef2);
        ActorRef actorRef3 = this.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().actorSelection(actorRef3.path())).when((Object)this.mockActorContext)).actorSelection(actorRef3.path().toString());
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(actorRef3, TransactionProxyTest.createDataTree()))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)CarsModel.BASE_QNAME.getLocalName()));
        this.expectReadyLocalTransaction(actorRef3, false);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.write(TestModel.JUNK_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.JUNK_QNAME));
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        transactionProxy.write(CarsModel.BASE_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)CarsModel.BASE_QNAME));
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof ThreePhaseCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((ThreePhaseCommitCohortProxy)ready), this.actorSelection(actorRef1), this.actorSelection(actorRef2), this.actorSelection(actorRef3));
        ImmutableSortedSet expShardNames = ImmutableSortedSet.of((Comparable)((Object)"default"), (Comparable)((Object)TestModel.JUNK_QNAME.getLocalName()), (Comparable)((Object)CarsModel.BASE_QNAME.getLocalName()));
        ArgumentCaptor batchedMods = ArgumentCaptor.forClass(BatchedModifications.class);
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef1)), batchedMods.capture(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Assert.assertEquals((String)"Participating shards", Optional.of(expShardNames), (Object)((BatchedModifications)batchedMods.getValue()).getParticipatingShardNames());
        batchedMods = ArgumentCaptor.forClass(BatchedModifications.class);
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef2)), batchedMods.capture(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Assert.assertEquals((String)"Participating shards", Optional.of(expShardNames), (Object)((BatchedModifications)batchedMods.getValue()).getParticipatingShardNames());
        ArgumentCaptor readyLocalTx = ArgumentCaptor.forClass(ReadyLocalTransaction.class);
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef3)), readyLocalTx.capture(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Assert.assertEquals((String)"Participating shards", Optional.of(expShardNames), (Object)((ReadyLocalTransaction)readyLocalTx.getValue()).getParticipatingShardNames());
    }

    @Test
    public void testReadyWithWriteOnlyAndLastBatchPending() {
        this.dataStoreContextBuilder.writeOnlyTransactionOptimizationsEnabled(true);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectBatchedModificationsReady(actorRef, true);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), new CommitTransactionReply().toSerializable());
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)1L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), true, true, new Modification[]{new WriteModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite)});
    }

    @Test
    public void testReadyWithWriteOnlyAndLastBatchEmpty() {
        this.dataStoreContextBuilder.shardBatchedModificationCount(1).writeOnlyTransactionOptimizationsEnabled(true);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectBatchedModificationsReady(actorRef, true);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), new CommitTransactionReply().toSerializable());
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)2L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), false, new Modification[]{new WriteModification(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite)});
        this.verifyBatchedModifications((Object)batchedModifications.get(1), true, true, new Modification[0]);
    }

    @Test
    public void testReadyWithReplyFailure() {
        this.dataStoreContextBuilder.writeOnlyTransactionOptimizationsEnabled(true);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.expectFailedBatchedModifications(actorRef);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), TestException.class);
    }

    @Test
    public void testReadyWithDebugContextEnabled() {
        this.dataStoreContextBuilder.transactionDebugContextEnabled(true);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        this.expectBatchedModificationsReady(actorRef, true);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof DebugThreePhaseCommitCohort));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((DebugThreePhaseCommitCohort)ready), new CommitTransactionReply().toSerializable());
    }

    @Test
    public void testReadyWithLocalTransaction() {
        ActorRef shardActorRef = this.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().actorSelection(shardActorRef.path())).when((Object)this.mockActorContext)).actorSelection(shardActorRef.path().toString());
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(shardActorRef, TransactionProxyTest.createDataTree()))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        this.expectReadyLocalTransaction(shardActorRef, true);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), new CommitTransactionReply().toSerializable());
        ArgumentCaptor readyLocalTx = ArgumentCaptor.forClass(ReadyLocalTransaction.class);
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(shardActorRef)), readyLocalTx.capture(), (Timeout)ArgumentMatchers.any(Timeout.class));
        Assert.assertFalse((String)"Participating shards present", (boolean)((ReadyLocalTransaction)readyLocalTx.getValue()).getParticipatingShardNames().isPresent());
    }

    @Test
    public void testReadyWithLocalTransactionWithFailure() {
        ActorRef shardActorRef = this.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().actorSelection(shardActorRef.path())).when((Object)this.mockActorContext)).actorSelection(shardActorRef.path().toString());
        DataTree mockDataTree = TransactionProxyTest.createDataTree();
        DataTreeModification mockModification = mockDataTree.takeSnapshot().newModification();
        ((DataTreeModification)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("mock")}).when((Object)mockModification)).ready();
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(shardActorRef, mockDataTree))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        this.expectReadyLocalTransaction(shardActorRef, true);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), RuntimeException.class);
    }

    private void testWriteOnlyTxWithFindPrimaryShardFailure(Exception toThrow) {
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)toThrow)).when((Object)this.mockActorContext)).findPrimaryShardAsync(ArgumentMatchers.anyString());
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        transactionProxy.delete(TestModel.TEST_PATH);
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof SingleCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((SingleCommitCohortProxy)ready), toThrow.getClass());
    }

    @Test
    public void testWriteOnlyTxWithPrimaryNotFoundException() {
        this.testWriteOnlyTxWithFindPrimaryShardFailure((Exception)new PrimaryNotFoundException("mock"));
    }

    @Test
    public void testWriteOnlyTxWithNotInitializedException() {
        this.testWriteOnlyTxWithFindPrimaryShardFailure((Exception)new NotInitializedException("mock"));
    }

    @Test
    public void testWriteOnlyTxWithNoShardLeaderException() {
        this.testWriteOnlyTxWithFindPrimaryShardFailure((Exception)new NoShardLeaderException("mock"));
    }

    @Test
    public void testReadyWithInvalidReplyMessageType() {
        this.dataStoreContextBuilder.writeOnlyTransactionOptimizationsEnabled(true);
        ActorRef actorRef1 = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY);
        ActorRef actorRef2 = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.WRITE_ONLY, TestModel.JUNK_QNAME.getLocalName());
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)new Object())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef1)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        this.expectBatchedModificationsReady(actorRef2);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.WRITE_ONLY);
        transactionProxy.write(TestModel.JUNK_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.JUNK_QNAME));
        transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        AbstractThreePhaseCommitCohort ready = transactionProxy.ready();
        Assert.assertTrue((boolean)(ready instanceof ThreePhaseCommitCohortProxy));
        this.verifyCohortFutures((AbstractThreePhaseCommitCohort<?>)((ThreePhaseCommitCohortProxy)ready), this.actorSelection(actorRef2), IllegalArgumentException.class);
    }

    @Test
    public void testGetIdentifier() {
        this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_ONLY);
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        Object id = transactionProxy.getIdentifier();
        Assert.assertNotNull((String)"getIdentifier returned null", (Object)id);
        Assert.assertTrue((String)("Invalid identifier: " + id), (boolean)id.toString().contains("mock-member"));
    }

    @Test
    public void testClose() {
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        ((ActorUtils)Mockito.doReturn(this.readDataReply(null)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.read(TestModel.TEST_PATH);
        transactionProxy.close();
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext)).sendOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(CloseTransaction.class));
    }

    private PrimaryShardInfo newPrimaryShardInfo(ActorRef actorRef) {
        return new PrimaryShardInfo(this.getSystem().actorSelection(actorRef.path()), 12);
    }

    private PrimaryShardInfo newPrimaryShardInfo(ActorRef actorRef, DataTree dataTree) {
        return new PrimaryShardInfo(this.getSystem().actorSelection(actorRef.path()), 12, (ReadOnlyDataTree)dataTree);
    }

    private void throttleOperation(TransactionProxyOperation operation) {
        this.throttleOperation(operation, 1, true);
    }

    private void throttleOperation(TransactionProxyOperation operation, int outstandingOpsLimit, boolean shardFound) {
        this.throttleOperation(operation, outstandingOpsLimit, shardFound, TimeUnit.MILLISECONDS.toNanos(this.mockActorContext.getDatastoreContext().getOperationTimeoutInMillis()));
    }

    private void throttleOperation(TransactionProxyOperation operation, int outstandingOpsLimit, boolean shardFound, long expectedCompletionTime) {
        ActorSystem actorSystem = this.getSystem();
        ActorRef shardActorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)this.dataStoreContextBuilder.operationTimeoutInSeconds(2).shardBatchedModificationCount(outstandingOpsLimit - 1).build()).when((Object)this.mockActorContext)).getDatastoreContext();
        ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(shardActorRef.path())).when((Object)this.mockActorContext)).actorSelection(shardActorRef.path().toString());
        if (shardFound) {
            ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(shardActorRef))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
            ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(shardActorRef))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"cars"));
        } else {
            ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new Exception("not found"))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        }
        ((ActorUtils)Mockito.doReturn(this.incompleteFuture()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)actorSystem.actorSelection(shardActorRef.path())), (Object)this.eqCreateTransaction("mock-member", TransactionType.READ_WRITE), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        long start = System.nanoTime();
        operation.run(transactionProxy);
        long end = System.nanoTime();
        Assert.assertTrue((String)String.format("Expected elapsed time: %s. Actual: %s", expectedCompletionTime, end - start), (end - start > expectedCompletionTime && end - start < expectedCompletionTime * 2L ? 1 : 0) != 0);
    }

    private void completeOperation(TransactionProxyOperation operation) {
        this.completeOperation(operation, true);
    }

    private void completeOperation(TransactionProxyOperation operation, boolean shardFound) {
        ActorSystem actorSystem = this.getSystem();
        ActorRef shardActorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(shardActorRef.path())).when((Object)this.mockActorContext)).actorSelection(shardActorRef.path().toString());
        if (shardFound) {
            ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(shardActorRef))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        } else {
            ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new PrimaryNotFoundException("test"))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        }
        ActorRef txActorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        String actorPath = txActorRef.path().toString();
        CreateTransactionReply createTransactionReply = new CreateTransactionReply(actorPath, TransactionProxyTest.nextTransactionId(), 12);
        ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(actorPath)).when((Object)this.mockActorContext)).actorSelection(actorPath);
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)createTransactionReply)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)actorSystem.actorSelection(shardActorRef.path())), (Object)this.eqCreateTransaction("mock-member", TransactionType.READ_WRITE), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        long start = System.nanoTime();
        operation.run(transactionProxy);
        long end = System.nanoTime();
        long expected = TimeUnit.MILLISECONDS.toNanos(this.mockActorContext.getDatastoreContext().getOperationTimeoutInMillis());
        Assert.assertTrue((String)String.format("Expected elapsed time: %s. Actual: %s", expected, end - start), (end - start <= expected ? 1 : 0) != 0);
    }

    private void completeOperationLocal(TransactionProxyOperation operation, DataTree dataTree) {
        ActorSystem actorSystem = this.getSystem();
        ActorRef shardActorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(shardActorRef.path())).when((Object)this.mockActorContext)).actorSelection(shardActorRef.path().toString());
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.newPrimaryShardInfo(shardActorRef, dataTree))).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)"default"));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        long start = System.nanoTime();
        operation.run(transactionProxy);
        long end = System.nanoTime();
        long expected = TimeUnit.MILLISECONDS.toNanos(this.mockActorContext.getDatastoreContext().getOperationTimeoutInMillis());
        Assert.assertTrue((String)String.format("Expected elapsed time: %s. Actual: %s", expected, end - start), (end - start <= expected ? 1 : 0) != 0);
    }

    private static DataTree createDataTree() {
        DataTree dataTree = (DataTree)Mockito.mock(DataTree.class);
        DataTreeSnapshot dataTreeSnapshot = (DataTreeSnapshot)Mockito.mock(DataTreeSnapshot.class);
        DataTreeModification dataTreeModification = (DataTreeModification)Mockito.mock(DataTreeModification.class);
        ((DataTree)Mockito.doReturn((Object)dataTreeSnapshot).when((Object)dataTree)).takeSnapshot();
        ((DataTreeSnapshot)Mockito.doReturn((Object)dataTreeModification).when((Object)dataTreeSnapshot)).newModification();
        return dataTree;
    }

    private static DataTree createDataTree(NormalizedNode readResponse) {
        DataTree dataTree = (DataTree)Mockito.mock(DataTree.class);
        DataTreeSnapshot dataTreeSnapshot = (DataTreeSnapshot)Mockito.mock(DataTreeSnapshot.class);
        DataTreeModification dataTreeModification = (DataTreeModification)Mockito.mock(DataTreeModification.class);
        ((DataTree)Mockito.doReturn((Object)dataTreeSnapshot).when((Object)dataTree)).takeSnapshot();
        ((DataTreeSnapshot)Mockito.doReturn((Object)dataTreeModification).when((Object)dataTreeSnapshot)).newModification();
        ((DataTreeModification)Mockito.doReturn(Optional.of(readResponse)).when((Object)dataTreeModification)).readNode((YangInstanceIdentifier)ArgumentMatchers.any(YangInstanceIdentifier.class));
        return dataTree;
    }

    @Test
    public void testWriteCompletionForLocalShard() {
        this.completeOperationLocal(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        }, TransactionProxyTest.createDataTree());
    }

    @Test
    public void testWriteThrottlingWhenShardFound() {
        this.throttleOperation(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectIncompleteBatchedModifications();
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        });
    }

    @Test
    public void testWriteThrottlingWhenShardNotFound() {
        this.completeOperation(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectBatchedModifications(2);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        }, false);
    }

    @Test
    public void testWriteCompletion() {
        this.completeOperation(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectBatchedModifications(2);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        });
    }

    @Test
    public void testMergeThrottlingWhenShardFound() {
        this.throttleOperation(transactionProxy -> {
            ContainerNode nodeToMerge = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectIncompleteBatchedModifications();
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToMerge);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToMerge);
        });
    }

    @Test
    public void testMergeThrottlingWhenShardNotFound() {
        this.completeOperation(transactionProxy -> {
            ContainerNode nodeToMerge = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectBatchedModifications(2);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToMerge);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToMerge);
        }, false);
    }

    @Test
    public void testMergeCompletion() {
        this.completeOperation(transactionProxy -> {
            ContainerNode nodeToMerge = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectBatchedModifications(2);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToMerge);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToMerge);
        });
    }

    @Test
    public void testMergeCompletionForLocalShard() {
        this.completeOperationLocal(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.merge(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
        }, TransactionProxyTest.createDataTree());
    }

    @Test
    public void testDeleteThrottlingWhenShardFound() {
        this.throttleOperation(transactionProxy -> {
            this.expectIncompleteBatchedModifications();
            transactionProxy.delete(TestModel.TEST_PATH);
            transactionProxy.delete(TestModel.TEST_PATH);
        });
    }

    @Test
    public void testDeleteThrottlingWhenShardNotFound() {
        this.completeOperation(transactionProxy -> {
            this.expectBatchedModifications(2);
            transactionProxy.delete(TestModel.TEST_PATH);
            transactionProxy.delete(TestModel.TEST_PATH);
        }, false);
    }

    @Test
    public void testDeleteCompletionForLocalShard() {
        this.completeOperationLocal(transactionProxy -> {
            transactionProxy.delete(TestModel.TEST_PATH);
            transactionProxy.delete(TestModel.TEST_PATH);
        }, TransactionProxyTest.createDataTree());
    }

    @Test
    public void testDeleteCompletion() {
        this.completeOperation(transactionProxy -> {
            this.expectBatchedModifications(2);
            transactionProxy.delete(TestModel.TEST_PATH);
            transactionProxy.delete(TestModel.TEST_PATH);
        });
    }

    @Test
    public void testReadThrottlingWhenShardFound() {
        this.throttleOperation(transactionProxy -> {
            ((ActorUtils)Mockito.doReturn(this.incompleteFuture()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), (Object)this.eqReadData());
            transactionProxy.read(TestModel.TEST_PATH);
            transactionProxy.read(TestModel.TEST_PATH);
        });
    }

    @Test
    public void testReadThrottlingWhenShardNotFound() {
        this.completeOperation(transactionProxy -> {
            ((ActorUtils)Mockito.doReturn(this.incompleteFuture()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), (Object)this.eqReadData());
            transactionProxy.read(TestModel.TEST_PATH);
            transactionProxy.read(TestModel.TEST_PATH);
        }, false);
    }

    @Test
    public void testReadCompletion() {
        this.completeOperation(transactionProxy -> {
            ContainerNode nodeToRead = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            ((ActorUtils)Mockito.doReturn(this.readDataReply((NormalizedNode)nodeToRead)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), (Object)this.eqReadData(), (Timeout)ArgumentMatchers.any(Timeout.class));
            transactionProxy.read(TestModel.TEST_PATH);
            transactionProxy.read(TestModel.TEST_PATH);
        });
    }

    @Test
    public void testReadCompletionForLocalShard() {
        ContainerNode nodeToRead = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.completeOperationLocal(transactionProxy -> {
            transactionProxy.read(TestModel.TEST_PATH);
            transactionProxy.read(TestModel.TEST_PATH);
        }, TransactionProxyTest.createDataTree((NormalizedNode)nodeToRead));
    }

    @Test
    public void testReadCompletionForLocalShardWhenExceptionOccurs() {
        this.completeOperationLocal(transactionProxy -> {
            transactionProxy.read(TestModel.TEST_PATH);
            transactionProxy.read(TestModel.TEST_PATH);
        }, TransactionProxyTest.createDataTree());
    }

    @Test
    public void testExistsThrottlingWhenShardFound() {
        this.throttleOperation(transactionProxy -> {
            ((ActorUtils)Mockito.doReturn(this.incompleteFuture()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), (Object)this.eqDataExists());
            transactionProxy.exists(TestModel.TEST_PATH);
            transactionProxy.exists(TestModel.TEST_PATH);
        });
    }

    @Test
    public void testExistsThrottlingWhenShardNotFound() {
        this.completeOperation(transactionProxy -> {
            ((ActorUtils)Mockito.doReturn(this.incompleteFuture()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), (Object)this.eqDataExists());
            transactionProxy.exists(TestModel.TEST_PATH);
            transactionProxy.exists(TestModel.TEST_PATH);
        }, false);
    }

    @Test
    public void testExistsCompletion() {
        this.completeOperation(transactionProxy -> {
            ((ActorUtils)Mockito.doReturn(this.dataExistsReply(true)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
            transactionProxy.exists(TestModel.TEST_PATH);
            transactionProxy.exists(TestModel.TEST_PATH);
        });
    }

    @Test
    public void testExistsCompletionForLocalShard() {
        ContainerNode nodeToRead = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        this.completeOperationLocal(transactionProxy -> {
            transactionProxy.exists(TestModel.TEST_PATH);
            transactionProxy.exists(TestModel.TEST_PATH);
        }, TransactionProxyTest.createDataTree((NormalizedNode)nodeToRead));
    }

    @Test
    public void testExistsCompletionForLocalShardWhenExceptionOccurs() {
        this.completeOperationLocal(transactionProxy -> {
            transactionProxy.exists(TestModel.TEST_PATH);
            transactionProxy.exists(TestModel.TEST_PATH);
        }, TransactionProxyTest.createDataTree());
    }

    @Test
    public void testReadyThrottling() {
        this.throttleOperation(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            this.expectBatchedModifications(1);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.ready();
        });
    }

    @Test
    public void testReadyThrottlingWithTwoTransactionContexts() {
        this.throttleOperation(transactionProxy -> {
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            ContainerNode carsNode = ImmutableNodes.containerNode((QName)CarsModel.BASE_QNAME);
            this.expectBatchedModifications(2);
            transactionProxy.write(TestModel.TEST_PATH, (NormalizedNode)nodeToWrite);
            transactionProxy.write(CarsModel.BASE_PATH, (NormalizedNode)carsNode);
            transactionProxy.ready();
        }, 1, true, TimeUnit.MILLISECONDS.toNanos(this.mockActorContext.getDatastoreContext().getOperationTimeoutInMillis()) * 2L);
    }

    private void testModificationOperationBatching(TransactionType type) {
        int shardBatchedModificationCount = 3;
        this.dataStoreContextBuilder.shardBatchedModificationCount(shardBatchedModificationCount);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), type);
        this.expectBatchedModifications(actorRef, shardBatchedModificationCount);
        YangInstanceIdentifier writePath1 = TestModel.TEST_PATH;
        ContainerNode writeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        YangInstanceIdentifier writePath2 = TestModel.OUTER_LIST_PATH;
        ContainerNode writeNode2 = ImmutableNodes.containerNode((QName)TestModel.OUTER_LIST_QNAME);
        YangInstanceIdentifier writePath3 = TestModel.INNER_LIST_PATH;
        ContainerNode writeNode3 = ImmutableNodes.containerNode((QName)TestModel.INNER_LIST_QNAME);
        YangInstanceIdentifier mergePath1 = TestModel.TEST_PATH;
        ContainerNode mergeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        YangInstanceIdentifier mergePath2 = TestModel.OUTER_LIST_PATH;
        ContainerNode mergeNode2 = ImmutableNodes.containerNode((QName)TestModel.OUTER_LIST_QNAME);
        YangInstanceIdentifier mergePath3 = TestModel.INNER_LIST_PATH;
        ContainerNode mergeNode3 = ImmutableNodes.containerNode((QName)TestModel.INNER_LIST_QNAME);
        YangInstanceIdentifier deletePath1 = TestModel.TEST_PATH;
        YangInstanceIdentifier deletePath2 = TestModel.OUTER_LIST_PATH;
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, type);
        transactionProxy.write(writePath1, (NormalizedNode)writeNode1);
        transactionProxy.write(writePath2, (NormalizedNode)writeNode2);
        transactionProxy.delete(deletePath1);
        transactionProxy.merge(mergePath1, (NormalizedNode)mergeNode1);
        transactionProxy.merge(mergePath2, (NormalizedNode)mergeNode2);
        transactionProxy.write(writePath3, (NormalizedNode)writeNode3);
        transactionProxy.merge(mergePath3, (NormalizedNode)mergeNode3);
        transactionProxy.delete(deletePath2);
        transactionProxy.ready();
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)3L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), false, new Modification[]{new WriteModification(writePath1, (NormalizedNode)writeNode1), new WriteModification(writePath2, (NormalizedNode)writeNode2), new DeleteModification(deletePath1)});
        this.verifyBatchedModifications((Object)batchedModifications.get(1), false, new Modification[]{new MergeModification(mergePath1, (NormalizedNode)mergeNode1), new MergeModification(mergePath2, (NormalizedNode)mergeNode2), new WriteModification(writePath3, (NormalizedNode)writeNode3)});
        this.verifyBatchedModifications((Object)batchedModifications.get(2), true, true, new Modification[]{new MergeModification(mergePath3, (NormalizedNode)mergeNode3), new DeleteModification(deletePath2)});
        Assert.assertEquals((String)"getTotalMessageCount", (long)3L, (long)batchedModifications.get(2).getTotalMessagesSent());
    }

    @Test
    public void testReadWriteModificationOperationBatching() {
        this.testModificationOperationBatching(TransactionType.READ_WRITE);
    }

    @Test
    public void testWriteOnlyModificationOperationBatching() {
        this.testModificationOperationBatching(TransactionType.WRITE_ONLY);
    }

    @Test
    public void testOptimizedWriteOnlyModificationOperationBatching() {
        this.dataStoreContextBuilder.writeOnlyTransactionOptimizationsEnabled(true);
        this.testModificationOperationBatching(TransactionType.WRITE_ONLY);
    }

    @Test
    public void testModificationOperationBatchingWithInterleavedReads() throws Exception {
        int shardBatchedModificationCount = 10;
        this.dataStoreContextBuilder.shardBatchedModificationCount(shardBatchedModificationCount);
        ActorRef actorRef = this.setupActorContextWithInitialCreateTransaction(this.getSystem(), TransactionType.READ_WRITE);
        this.expectBatchedModifications(actorRef, shardBatchedModificationCount);
        YangInstanceIdentifier writePath1 = TestModel.TEST_PATH;
        ContainerNode writeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        YangInstanceIdentifier writePath2 = TestModel.OUTER_LIST_PATH;
        ContainerNode writeNode2 = ImmutableNodes.containerNode((QName)TestModel.OUTER_LIST_QNAME);
        YangInstanceIdentifier mergePath1 = TestModel.TEST_PATH;
        ContainerNode mergeNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        YangInstanceIdentifier mergePath2 = TestModel.INNER_LIST_PATH;
        ContainerNode mergeNode2 = ImmutableNodes.containerNode((QName)TestModel.INNER_LIST_QNAME);
        YangInstanceIdentifier deletePath = TestModel.OUTER_LIST_PATH;
        ((ActorUtils)Mockito.doReturn(this.readDataReply((NormalizedNode)writeNode2)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(writePath2), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)Mockito.doReturn(this.readDataReply((NormalizedNode)mergeNode2)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(mergePath2), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)Mockito.doReturn(this.dataExistsReply(true)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_WRITE);
        transactionProxy.write(writePath1, (NormalizedNode)writeNode1);
        transactionProxy.write(writePath2, (NormalizedNode)writeNode2);
        Optional readOptional = (Optional)transactionProxy.read(writePath2).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Response NormalizedNode", Optional.of(writeNode2), (Object)readOptional);
        transactionProxy.merge(mergePath1, (NormalizedNode)mergeNode1);
        transactionProxy.merge(mergePath2, (NormalizedNode)mergeNode2);
        readOptional = (Optional)transactionProxy.read(mergePath2).get(5L, TimeUnit.SECONDS);
        transactionProxy.delete(deletePath);
        Boolean exists = (Boolean)transactionProxy.exists(TestModel.TEST_PATH).get();
        Assert.assertEquals((String)"Exists response", (Object)Boolean.TRUE, (Object)exists);
        Assert.assertEquals((String)"Response NormalizedNode", Optional.of(mergeNode2), (Object)readOptional);
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)3L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), false, new Modification[]{new WriteModification(writePath1, (NormalizedNode)writeNode1), new WriteModification(writePath2, (NormalizedNode)writeNode2)});
        this.verifyBatchedModifications((Object)batchedModifications.get(1), false, new Modification[]{new MergeModification(mergePath1, (NormalizedNode)mergeNode1), new MergeModification(mergePath2, (NormalizedNode)mergeNode2)});
        this.verifyBatchedModifications((Object)batchedModifications.get(2), false, new Modification[]{new DeleteModification(deletePath)});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockActorContext});
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(writePath2), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqReadData(mergePath2), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)inOrder.verify((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), (Object)this.eqDataExists(), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    @Test
    public void testReadRoot() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
        EffectiveModelContext schemaContext = SchemaContextHelper.full();
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        ((ActorUtils)Mockito.doReturn((Object)configuration).when((Object)this.mockActorContext)).getConfiguration();
        ((ActorUtils)Mockito.doReturn((Object)schemaContext).when((Object)this.mockActorContext)).getSchemaContext();
        ((Configuration)Mockito.doReturn((Object)Sets.newHashSet((Object[])new String[]{"test", "cars"})).when((Object)configuration)).getAllShardNames();
        ContainerNode expectedNode1 = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        ContainerNode expectedNode2 = ImmutableNodes.containerNode((QName)CarsModel.CARS_QNAME);
        this.setUpReadData("test", NormalizedNodeAggregatorTest.getRootNode((NormalizedNode)expectedNode1, schemaContext));
        this.setUpReadData("cars", NormalizedNodeAggregatorTest.getRootNode((NormalizedNode)expectedNode2, schemaContext));
        ((ActorUtils)Mockito.doReturn((Object)MemberName.forName((String)"mock-member")).when((Object)this.mockActorContext)).getCurrentMemberName();
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().dispatchers().defaultGlobalDispatcher()).when((Object)this.mockActorContext)).getClientDispatcher();
        TransactionProxy transactionProxy = new TransactionProxy((AbstractTransactionContextFactory)this.mockComponentFactory, TransactionType.READ_ONLY);
        Optional readOptional = (Optional)transactionProxy.read(YangInstanceIdentifier.empty()).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"NormalizedNode isPresent", (boolean)readOptional.isPresent());
        NormalizedNode normalizedNode = (NormalizedNode)readOptional.orElseThrow();
        Assert.assertTrue((String)"Expect value to be a Collection", (boolean)(normalizedNode.body() instanceof Collection));
        Collection collection = (Collection)normalizedNode.body();
        for (NormalizedNode node : collection) {
            Assert.assertTrue((String)("Expected " + node + " to be a ContainerNode"), (boolean)(node instanceof ContainerNode));
        }
        Assert.assertTrue((String)("Child with QName = " + TestModel.TEST_QNAME + " not found"), (NormalizedNodeAggregatorTest.findChildWithQName(collection, TestModel.TEST_QNAME) != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedNode1, (Object)NormalizedNodeAggregatorTest.findChildWithQName(collection, TestModel.TEST_QNAME));
        Assert.assertTrue((String)("Child with QName = " + CarsModel.BASE_QNAME + " not found"), (NormalizedNodeAggregatorTest.findChildWithQName(collection, CarsModel.BASE_QNAME) != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedNode2, (Object)NormalizedNodeAggregatorTest.findChildWithQName(collection, CarsModel.BASE_QNAME));
    }

    private void setUpReadData(String shardName, NormalizedNode expectedNode) {
        ActorSystem actorSystem = this.getSystem();
        ActorRef shardActorRef = this.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().actorSelection(shardActorRef.path())).when((Object)this.mockActorContext)).actorSelection(shardActorRef.path().toString());
        ((ActorUtils)Mockito.doReturn(this.primaryShardInfoReply(this.getSystem(), shardActorRef)).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)shardName));
        ActorRef txActorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(txActorRef.path())).when((Object)this.mockActorContext)).actorSelection(txActorRef.path().toString());
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.createTransactionReply(txActorRef, (short)12))).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)actorSystem.actorSelection(shardActorRef.path())), (Object)this.eqCreateTransaction("mock-member", TransactionType.READ_ONLY), (Timeout)ArgumentMatchers.any(Timeout.class));
        ((ActorUtils)Mockito.doReturn(this.readDataReply(expectedNode)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(txActorRef)), (Object)this.eqReadData(YangInstanceIdentifier.empty()), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    static class TestException
    extends RuntimeException {
        TestException() {
        }
    }

    static interface Invoker {
        public FluentFuture<?> invoke(TransactionProxy var1);
    }

    private static interface TransactionProxyOperation {
        public void run(TransactionProxy var1);
    }
}

