/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.List;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImplBaseTest;
import org.opendaylight.controller.cluster.datastore.config.HybridModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;

public class ConfigurationImplHybridTest
extends ConfigurationImplBaseTest {
    @Override
    public ConfigurationImpl createConfiguration() {
        Config moduleShardsConf = ConfigurationImplHybridTest.generateModuleShards(List.of(ConfigurationImplHybridTest.generateShard("default", "default", List.of("member-1", "member-2", "member-3")), ConfigurationImplHybridTest.generateShard("people", "people-1", List.of("member-1")), ConfigurationImplHybridTest.generateShard("cars", "cars-1", List.of("member-1")), ConfigurationImplHybridTest.generateShard("test", "test-1", List.of("member-1"))));
        return new ConfigurationImpl((ModuleShardConfigProvider)new HybridModuleShardConfigProvider(moduleShardsConf, "modules.conf"));
    }

    @Test(expected=NullPointerException.class)
    public void testNullModuleShardsConf() {
        new HybridModuleShardConfigProvider(null, "modules.conf");
    }

    private static Config generateModuleShards(List<String> shards) {
        String moduleShardsContent = String.format("module-shards = [%n%s]", String.join((CharSequence)",\n", shards));
        return ConfigFactory.parseString((String)moduleShardsContent);
    }

    private static String generateShard(String name, String shardsName, List<String> replicas) {
        return "    {        name = \"" + name + "\"\n        shards = [\n            {\n                name=\"" + shardsName + "\"\n                replicas = " + replicas + "                \n            }\n        ]\n    }";
    }
}

