/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;

abstract class AbstractIdentifiablePayloadTest<T extends AbstractIdentifiablePayload<?>>
extends AbstractTest {
    private final T object;
    private final int expectedSize;

    AbstractIdentifiablePayloadTest(T object, int expectedSize) {
        this.object = (AbstractIdentifiablePayload)Objects.requireNonNull(object);
        this.expectedSize = expectedSize;
    }

    @Test
    public void testSerialization() {
        byte[] bytes = SerializationUtils.serialize(this.object);
        Assert.assertEquals((long)this.expectedSize, (long)bytes.length);
        AbstractIdentifiablePayload cloned = (AbstractIdentifiablePayload)SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals((Object)this.object.getIdentifier(), (Object)cloned.getIdentifier());
    }
}

