/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

public class ShardDataTreeSnapshotTest {
    @Test
    public void testShardDataTreeSnapshotWithNoMetadata() throws Exception {
        ShardDataTreeSnapshot deserialized;
        ContainerNode expectedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        MetadataShardDataTreeSnapshot snapshot = new MetadataShardDataTreeSnapshot((NormalizedNode)expectedNode);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bos);){
            snapshot.serialize((ObjectOutput)out);
        }
        byte[] bytes = bos.toByteArray();
        Assert.assertEquals((long)202L, (long)bytes.length);
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            deserialized = ShardDataTreeSnapshot.deserialize((ObjectInput)in).getSnapshot();
        }
        Assert.assertEquals((String)"rootNode", Optional.of(expectedNode), (Object)deserialized.getRootNode());
        Assert.assertEquals((String)"Deserialized type", MetadataShardDataTreeSnapshot.class, deserialized.getClass());
        Assert.assertEquals((String)"Metadata size", (long)0L, (long)((MetadataShardDataTreeSnapshot)deserialized).getMetadata().size());
    }

    @Test
    public void testShardDataTreeSnapshotWithMetadata() throws Exception {
        ShardDataTreeSnapshot deserialized;
        ContainerNode expectedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        Map<Class<TestShardDataTreeSnapshotMetadata>, TestShardDataTreeSnapshotMetadata> expMetadata = Map.of(TestShardDataTreeSnapshotMetadata.class, new TestShardDataTreeSnapshotMetadata("test"));
        MetadataShardDataTreeSnapshot snapshot = new MetadataShardDataTreeSnapshot((NormalizedNode)expectedNode, expMetadata);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bos);){
            snapshot.serialize((ObjectOutput)out);
        }
        byte[] bytes = bos.toByteArray();
        Assert.assertEquals((long)350L, (long)bytes.length);
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            deserialized = ShardDataTreeSnapshot.deserialize((ObjectInput)in).getSnapshot();
        }
        Assert.assertEquals((String)"rootNode", Optional.of(expectedNode), (Object)deserialized.getRootNode());
        Assert.assertEquals((String)"Deserialized type", MetadataShardDataTreeSnapshot.class, deserialized.getClass());
        Assert.assertEquals((String)"Metadata", expMetadata, (Object)((MetadataShardDataTreeSnapshot)deserialized).getMetadata());
    }

    static class TestShardDataTreeSnapshotMetadata
    extends ShardDataTreeSnapshotMetadata<TestShardDataTreeSnapshotMetadata> {
        private static final long serialVersionUID = 1L;
        private final String data;

        TestShardDataTreeSnapshotMetadata(String data) {
            this.data = data;
        }

        public Class<TestShardDataTreeSnapshotMetadata> getType() {
            return TestShardDataTreeSnapshotMetadata.class;
        }

        protected Externalizable externalizableProxy() {
            return new Proxy(this.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof TestShardDataTreeSnapshotMetadata)) return false;
            TestShardDataTreeSnapshotMetadata other = (TestShardDataTreeSnapshotMetadata)((Object)obj);
            if (!this.data.equals(other.data)) return false;
            return true;
        }

        private static class Proxy
        implements Externalizable {
            private static final long serialVersionUID = 7534948936595056176L;
            private String data;

            public Proxy() {
            }

            Proxy(String data) {
                this.data = data;
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeObject(this.data);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.data = (String)in.readObject();
            }

            Object readResolve() {
                return new TestShardDataTreeSnapshotMetadata(this.data);
            }
        }
    }
}

