/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

public class MockDataTreeChangeListener
implements DOMDataTreeChangeListener {
    private final List<DataTreeCandidate> changeList = new ArrayList<DataTreeCandidate>();
    private final CountDownLatch onInitialDataLatch = new CountDownLatch(1);
    private final AtomicInteger onInitialDataEventCount = new AtomicInteger();
    private volatile CountDownLatch changeLatch;
    private int expChangeEventCount;

    public MockDataTreeChangeListener(int expChangeEventCount) {
        this.reset(expChangeEventCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int newExpChangeEventCount) {
        this.changeLatch = new CountDownLatch(newExpChangeEventCount);
        this.expChangeEventCount = newExpChangeEventCount;
        List<DataTreeCandidate> list = this.changeList;
        synchronized (list) {
            this.changeList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataTreeChanged(List<DataTreeCandidate> changes) {
        if (this.changeLatch.getCount() > 0L) {
            List<DataTreeCandidate> list = this.changeList;
            synchronized (list) {
                this.changeList.addAll(changes);
            }
            this.changeLatch.countDown();
        }
    }

    public void onInitialData() {
        this.onInitialDataEventCount.incrementAndGet();
        this.onInitialDataLatch.countDown();
    }

    public void verifyOnInitialDataEvent() {
        Assert.assertTrue((String)"onInitialData was not triggered", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.onInitialDataLatch, (long)5L, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertEquals((String)"onInitialDataEventCount", (long)1L, (long)this.onInitialDataEventCount.get());
    }

    public void verifyNoOnInitialDataEvent() {
        Assert.assertFalse((String)"onInitialData was triggered unexpectedly", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.onInitialDataLatch, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public void waitForChangeEvents(YangInstanceIdentifier ... expPaths) {
        boolean done = Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.changeLatch, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        if (!done) {
            Assert.fail((String)String.format("Missing change notifications. Expected: %d. Actual: %d", this.expChangeEventCount, (long)this.expChangeEventCount - this.changeLatch.getCount()));
        }
        for (int i = 0; i < expPaths.length; ++i) {
            DataTreeCandidate candidate = this.changeList.get(i);
            Optional maybeDataAfter = candidate.getRootNode().getDataAfter();
            if (!maybeDataAfter.isPresent()) {
                Assert.fail((String)String.format("Change %d does not contain data after. Actual: %s", i + 1, candidate.getRootNode()));
            }
            NormalizedNode dataAfter = (NormalizedNode)maybeDataAfter.orElseThrow();
            Optional relativePath = expPaths[i].relativeTo(candidate.getRootPath());
            if (!relativePath.isPresent()) {
                Assert.assertEquals((String)String.format("Change %d does not contain %s. Actual: %s", i + 1, expPaths[i], dataAfter), (Object)expPaths[i].getLastPathArgument(), (Object)dataAfter.getIdentifier());
                continue;
            }
            NormalizedNode nextChild = dataAfter;
            for (YangInstanceIdentifier.PathArgument pathArg : ((YangInstanceIdentifier)relativePath.orElseThrow()).getPathArguments()) {
                Optional maybeChild;
                boolean found = false;
                if (nextChild instanceof DistinctNodeContainer && (maybeChild = ((DistinctNodeContainer)nextChild).findChildByArg(pathArg)).isPresent()) {
                    found = true;
                    nextChild = (NormalizedNode)maybeChild.orElseThrow();
                }
                if (found) continue;
                Assert.fail((String)String.format("Change %d does not contain %s. Actual: %s", i + 1, expPaths[i], dataAfter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyNotifiedData(YangInstanceIdentifier ... paths) {
        HashSet<YangInstanceIdentifier> pathSet = new HashSet<YangInstanceIdentifier>(Arrays.asList(paths));
        List<DataTreeCandidate> list = this.changeList;
        synchronized (list) {
            for (DataTreeCandidate c : this.changeList) {
                pathSet.remove(c.getRootPath());
            }
        }
        if (!pathSet.isEmpty()) {
            Assert.fail((String)(pathSet + " not present in " + this.changeList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expectNoMoreChanges(String assertMsg) {
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        List<DataTreeCandidate> list = this.changeList;
        synchronized (list) {
            Assert.assertEquals((String)assertMsg, (long)this.expChangeEventCount, (long)this.changeList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyNoNotifiedData(YangInstanceIdentifier ... paths) {
        HashSet<YangInstanceIdentifier> pathSet = new HashSet<YangInstanceIdentifier>(Arrays.asList(paths));
        List<DataTreeCandidate> list = this.changeList;
        synchronized (list) {
            for (DataTreeCandidate c : this.changeList) {
                Assert.assertFalse((String)("Unexpected " + c.getRootPath() + " present in DataTreeCandidate"), (boolean)pathSet.contains(c.getRootPath()));
            }
        }
    }
}

