/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.ReusableNormalizedNodePruner;
import org.opendaylight.controller.cluster.datastore.utils.PruningDataTreeModification;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.CompositeModel;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

@RunWith(value=MockitoJUnitRunner.class)
public class PruningDataTreeModificationTest {
    static final QName INVALID_TEST_QNAME = QName.create((QName)TestModel.TEST_QNAME, (String)"invalid");
    static final YangInstanceIdentifier INVALID_TEST_PATH = YangInstanceIdentifier.of((QName)INVALID_TEST_QNAME);
    private static EffectiveModelContext SCHEMA_CONTEXT;
    private static DataSchemaContextTree CONTEXT_TREE;
    @Mock
    private DataTreeModification mockModification;
    private DataTree dataTree;
    private DataTreeModification realModification;
    private DataTreeModification proxyModification;
    private PruningDataTreeModification pruningDataTreeModification;

    @BeforeClass
    public static void beforeClass() {
        SCHEMA_CONTEXT = SchemaContextHelper.select("/cars.yang", "/odl-datastore-test.yang");
        CONTEXT_TREE = DataSchemaContextTree.from((EffectiveModelContext)SCHEMA_CONTEXT);
    }

    @Before
    public void setUp() {
        this.dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION, SCHEMA_CONTEXT);
        this.realModification = this.dataTree.takeSnapshot().newModification();
        this.proxyModification = (DataTreeModification)Reflection.newProxy(DataTreeModification.class, (proxy, method, args) -> {
            try {
                method.invoke((Object)this.mockModification, args);
                return method.invoke((Object)this.realModification, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
        this.pruningDataTreeModification = new PruningDataTreeModification.Reactive(this.proxyModification, this.dataTree, ReusableNormalizedNodePruner.forDataSchemaContext((DataSchemaContextTree)CONTEXT_TREE));
    }

    @Test
    public void testDelete() {
        this.pruningDataTreeModification.delete(CarsModel.BASE_PATH);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).delete(CarsModel.BASE_PATH);
    }

    @Test
    public void testDeleteOnException() {
        YangInstanceIdentifier path = CarsModel.BASE_PATH;
        ((DataTreeModification)Mockito.doThrow(SchemaValidationFailedException.class).when((Object)this.mockModification)).delete(path);
        this.pruningDataTreeModification.delete(path);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).delete(path);
    }

    @Test
    public void testMerge() {
        ContainerNode normalizedNode = CarsModel.create();
        YangInstanceIdentifier path = CarsModel.BASE_PATH;
        this.pruningDataTreeModification.merge(path, (NormalizedNode)normalizedNode);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).merge(path, (NormalizedNode)normalizedNode);
    }

    @Test
    public void testMergeWithInvalidNamespace() throws DataValidationFailedException {
        ContainerNode normalizedNode = PeopleModel.emptyContainer();
        YangInstanceIdentifier path = PeopleModel.BASE_PATH;
        this.pruningDataTreeModification.merge(path, (NormalizedNode)normalizedNode);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).merge(path, (NormalizedNode)normalizedNode);
        DataTreeCandidate candidate = this.getCandidate();
        Assert.assertEquals((String)"getModificationType", (Object)ModificationType.UNMODIFIED, (Object)candidate.getRootNode().getModificationType());
    }

    @Test
    public void testMergeWithInvalidChildNodeNames() throws DataValidationFailedException {
        DataContainerChild outerNode = TestModel.outerNode(TestModel.outerNodeEntry(1, TestModel.innerNode("one", "two")));
        ContainerNode normalizedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild(outerNode).withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CompositeModel.AUG_CONTAINER)).withChild((DataContainerChild)ImmutableNodes.containerNode((QName)CompositeModel.AUG_INNER_CONTAINER)).build()).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CompositeModel.AUG_QNAME, (Object)"aug")).build();
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        this.pruningDataTreeModification.merge(path, (NormalizedNode)normalizedNode);
        this.dataTree.commit(this.getCandidate());
        ContainerNode prunedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild(outerNode).build();
        Assert.assertEquals((String)"After pruning", Optional.of(prunedNode), (Object)this.dataTree.takeSnapshot().readNode(path));
    }

    @Test
    public void testMergeWithValidNamespaceAndInvalidNodeName() throws DataValidationFailedException {
        ContainerNode normalizedNode = ImmutableNodes.containerNode((QName)INVALID_TEST_QNAME);
        YangInstanceIdentifier path = INVALID_TEST_PATH;
        this.pruningDataTreeModification.merge(path, (NormalizedNode)normalizedNode);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).merge(path, (NormalizedNode)normalizedNode);
        DataTreeCandidate candidate = this.getCandidate();
        Assert.assertEquals((String)"getModificationType", (Object)ModificationType.UNMODIFIED, (Object)candidate.getRootNode().getModificationType());
    }

    @Test
    public void testWrite() {
        ContainerNode normalizedNode = CarsModel.create();
        YangInstanceIdentifier path = CarsModel.BASE_PATH;
        this.pruningDataTreeModification.write(path, (NormalizedNode)normalizedNode);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).write(path, (NormalizedNode)normalizedNode);
    }

    @Test
    public void testWriteRootNode() throws Exception {
        DataTree localDataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION, SCHEMA_CONTEXT);
        DataTreeModification mod = localDataTree.takeSnapshot().newModification();
        mod.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.create());
        mod.ready();
        localDataTree.validate(mod);
        localDataTree.commit((DataTreeCandidate)localDataTree.prepare(mod));
        NormalizedNode normalizedNode = (NormalizedNode)this.dataTree.takeSnapshot().readNode(YangInstanceIdentifier.empty()).orElseThrow();
        this.pruningDataTreeModification.write(YangInstanceIdentifier.empty(), normalizedNode);
        this.dataTree.commit(this.getCandidate());
        Assert.assertEquals(Optional.of(normalizedNode), (Object)this.dataTree.takeSnapshot().readNode(YangInstanceIdentifier.empty()));
    }

    @Test
    public void testWriteRootNodeWithInvalidChild() throws Exception {
        Shard mockShard = (Shard)Mockito.mock(Shard.class);
        ShardDataTree shardDataTree = new ShardDataTree(mockShard, SCHEMA_CONTEXT, TreeType.CONFIGURATION);
        NormalizedNode root = (NormalizedNode)shardDataTree.readNode(YangInstanceIdentifier.empty()).orElseThrow();
        NormalizedNode normalizedNode = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(root.getIdentifier().getNodeType())).withChild((DataContainerChild)ImmutableNodes.containerNode((QName)CompositeModel.AUG_CONTAINER)).build();
        this.pruningDataTreeModification.write(YangInstanceIdentifier.empty(), normalizedNode);
        this.dataTree.commit(this.getCandidate());
        Assert.assertEquals(Optional.of(root), (Object)this.dataTree.takeSnapshot().readNode(YangInstanceIdentifier.empty()));
    }

    @Test
    public void testWriteWithInvalidNamespace() throws DataValidationFailedException {
        ContainerNode normalizedNode = PeopleModel.emptyContainer();
        YangInstanceIdentifier path = PeopleModel.BASE_PATH;
        this.pruningDataTreeModification.write(path, (NormalizedNode)normalizedNode);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification, (VerificationMode)Mockito.times((int)1))).write(path, (NormalizedNode)normalizedNode);
        DataTreeCandidate candidate = this.getCandidate();
        Assert.assertEquals((String)"getModificationType", (Object)ModificationType.UNMODIFIED, (Object)candidate.getRootNode().getModificationType());
    }

    @Test
    public void testWriteWithInvalidChildNodeNames() throws DataValidationFailedException {
        DataContainerChild outerNode = TestModel.outerNode(TestModel.outerNodeEntry(1, TestModel.innerNode("one", "two")));
        ContainerNode normalizedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild(outerNode).withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CompositeModel.AUG_CONTAINER)).withChild((DataContainerChild)ImmutableNodes.containerNode((QName)CompositeModel.AUG_INNER_CONTAINER)).build()).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)CompositeModel.AUG_QNAME, (Object)"aug")).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.NAME_QNAME, (Object)"name")).build();
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        this.pruningDataTreeModification.write(path, (NormalizedNode)normalizedNode);
        this.dataTree.commit(this.getCandidate());
        ContainerNode prunedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild(outerNode).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.NAME_QNAME, (Object)"name")).build();
        Assert.assertEquals(Optional.of(prunedNode), (Object)this.dataTree.takeSnapshot().readNode(path));
    }

    @Test
    public void testReady() {
        this.pruningDataTreeModification.ready();
        ((DataTreeModification)Mockito.verify((Object)this.mockModification)).ready();
    }

    @Test
    public void testApplyToCursor() {
        DataTreeModificationCursor dataTreeModificationCursor = (DataTreeModificationCursor)Mockito.mock(DataTreeModificationCursor.class);
        this.pruningDataTreeModification.applyToCursor(dataTreeModificationCursor);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification)).applyToCursor(dataTreeModificationCursor);
    }

    @Test
    public void testReadNode() {
        this.pruningDataTreeModification.readNode(CarsModel.BASE_PATH);
        ((DataTreeModification)Mockito.verify((Object)this.mockModification)).readNode(CarsModel.BASE_PATH);
    }

    @Test
    public void testNewModification() {
        this.realModification.ready();
        DataTreeModification dataTreeModification = this.pruningDataTreeModification.newModification();
        Assert.assertTrue((String)"new modification not of type PruningDataTreeModification", (boolean)(dataTreeModification instanceof PruningDataTreeModification));
    }

    private DataTreeCandidate getCandidate() throws DataValidationFailedException {
        this.pruningDataTreeModification.ready();
        DataTreeModification mod = this.pruningDataTreeModification.delegate();
        mod = mod == this.proxyModification ? this.realModification : mod;
        this.dataTree.validate(mod);
        return this.dataTree.prepare(mod);
    }
}

