/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.dispatch.Futures;
import akka.testkit.javadsl.TestKit;
import akka.util.Timeout;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FluentFuture;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.MockIdentifiers;
import org.opendaylight.controller.cluster.datastore.TransactionContextFactory;
import org.opendaylight.controller.cluster.datastore.TransactionProxyTest;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModificationsReply;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.DataExistsReply;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.cluster.datastore.messages.ReadDataReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.messages.ReadyTransactionReply;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.MockConfiguration;
import org.opendaylight.controller.cluster.raft.utils.DoNothingActor;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractTransactionProxyTest
extends AbstractTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static ActorSystem system;
    private static SchemaContext SCHEMA_CONTEXT;
    private final Configuration configuration = new MockConfiguration(){
        Map<String, ShardStrategy> strategyMap = ImmutableMap.builder().put((Object)TestModel.JUNK_QNAME.getLocalName(), (Object)new ShardStrategy(){

            public String findShard(YangInstanceIdentifier path) {
                return TestModel.JUNK_QNAME.getLocalName();
            }
        }).put((Object)CarsModel.BASE_QNAME.getLocalName(), (Object)new ShardStrategy(){

            public String findShard(YangInstanceIdentifier path) {
                return CarsModel.BASE_QNAME.getLocalName();
            }
        }).build();

        public ShardStrategy getStrategyForModule(String moduleName) {
            return this.strategyMap.get(moduleName);
        }

        public String getModuleNameFromNameSpace(String nameSpace) {
            if (TestModel.JUNK_QNAME.getNamespace().toString().equals(nameSpace)) {
                return TestModel.JUNK_QNAME.getLocalName();
            }
            if (CarsModel.BASE_QNAME.getNamespace().toString().equals(nameSpace)) {
                return CarsModel.BASE_QNAME.getLocalName();
            }
            return null;
        }
    };
    @Mock
    protected ActorUtils mockActorContext;
    protected TransactionContextFactory mockComponentFactory;
    @Mock
    private ClusterWrapper mockClusterWrapper;
    protected final String memberName = "mock-member";
    private final int operationTimeoutInSeconds = 2;
    protected final DatastoreContext.Builder dataStoreContextBuilder = DatastoreContext.newBuilder().operationTimeoutInSeconds(2);

    @BeforeClass
    public static void setUpClass() {
        Config config = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"akka.actor.default-dispatcher.type", (Object)"akka.testkit.CallingThreadDispatcherConfigurator").build()).withFallback((ConfigMergeable)ConfigFactory.load());
        system = ActorSystem.create((String)"test", (Config)config);
        SCHEMA_CONTEXT = TestModel.createTestContext();
    }

    @AfterClass
    public static void tearDownClass() {
        TestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
        SCHEMA_CONTEXT = null;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem()).when((Object)this.mockActorContext)).getActorSystem();
        ((ActorUtils)Mockito.doReturn((Object)this.getSystem().dispatchers().defaultGlobalDispatcher()).when((Object)this.mockActorContext)).getClientDispatcher();
        ((ActorUtils)Mockito.doReturn((Object)MemberName.forName((String)"mock-member")).when((Object)this.mockActorContext)).getCurrentMemberName();
        ((ActorUtils)Mockito.doReturn((Object)new ShardStrategyFactory(this.configuration)).when((Object)this.mockActorContext)).getShardStrategyFactory();
        ((ActorUtils)Mockito.doReturn((Object)SCHEMA_CONTEXT).when((Object)this.mockActorContext)).getSchemaContext();
        ((ActorUtils)Mockito.doReturn((Object)new Timeout(2L, TimeUnit.SECONDS)).when((Object)this.mockActorContext)).getOperationTimeout();
        ((ActorUtils)Mockito.doReturn((Object)this.mockClusterWrapper).when((Object)this.mockActorContext)).getClusterWrapper();
        ((ActorUtils)Mockito.doReturn((Object)this.mockClusterWrapper).when((Object)this.mockActorContext)).getClusterWrapper();
        ((ActorUtils)Mockito.doReturn((Object)this.dataStoreContextBuilder.build()).when((Object)this.mockActorContext)).getDatastoreContext();
        ((ActorUtils)Mockito.doReturn((Object)new Timeout(5L, TimeUnit.SECONDS)).when((Object)this.mockActorContext)).getTransactionCommitOperationTimeout();
        ClientIdentifier mockClientId = MockIdentifiers.clientIdentifier(this.getClass(), "mock-member");
        this.mockComponentFactory = new TransactionContextFactory(this.mockActorContext, mockClientId);
        Timer timer = new MetricRegistry().timer("test");
        ((ActorUtils)Mockito.doReturn((Object)timer).when((Object)this.mockActorContext)).getOperationTimer((String)ArgumentMatchers.any(String.class));
    }

    protected ActorSystem getSystem() {
        return system;
    }

    protected CreateTransaction eqCreateTransaction(final String expMemberName, final TransactionType type) {
        class CreateTransactionArgumentMatcher
        implements ArgumentMatcher<CreateTransaction> {
            CreateTransactionArgumentMatcher() {
            }

            public boolean matches(CreateTransaction argument) {
                return argument.getTransactionId().getHistoryId().getClientId().getFrontendId().getMemberName().getName().equals(expMemberName) && argument.getTransactionType() == type.ordinal();
            }
        }
        return (CreateTransaction)ArgumentMatchers.argThat((ArgumentMatcher)new CreateTransactionArgumentMatcher());
    }

    protected DataExists eqDataExists() {
        class DataExistsArgumentMatcher
        implements ArgumentMatcher<DataExists> {
            DataExistsArgumentMatcher() {
            }

            public boolean matches(DataExists argument) {
                return argument.getPath().equals((Object)TestModel.TEST_PATH);
            }
        }
        return (DataExists)ArgumentMatchers.argThat((ArgumentMatcher)new DataExistsArgumentMatcher());
    }

    protected ReadData eqReadData() {
        return this.eqReadData(TestModel.TEST_PATH);
    }

    protected ReadData eqReadData(final YangInstanceIdentifier path) {
        class ReadDataArgumentMatcher
        implements ArgumentMatcher<ReadData> {
            ReadDataArgumentMatcher() {
            }

            public boolean matches(ReadData argument) {
                return argument.getPath().equals((Object)path);
            }
        }
        return (ReadData)ArgumentMatchers.argThat((ArgumentMatcher)new ReadDataArgumentMatcher());
    }

    protected Future<Object> readyTxReply(String path) {
        return Futures.successful((Object)new ReadyTransactionReply(path));
    }

    protected Future<ReadDataReply> readDataReply(NormalizedNode data) {
        return Futures.successful((Object)new ReadDataReply(data, 13));
    }

    protected Future<DataExistsReply> dataExistsReply(boolean exists) {
        return Futures.successful((Object)new DataExistsReply(exists, 13));
    }

    protected Future<BatchedModificationsReply> batchedModificationsReply(int count) {
        return Futures.successful((Object)new BatchedModificationsReply(count));
    }

    protected Future<Object> incompleteFuture() {
        return (Future)Mockito.mock(Future.class);
    }

    protected ActorSelection actorSelection(ActorRef actorRef) {
        return this.getSystem().actorSelection(actorRef.path());
    }

    protected void expectBatchedModifications(ActorRef actorRef, int count) {
        ((ActorUtils)Mockito.doReturn(this.batchedModificationsReply(count)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    protected void expectBatchedModifications(int count) {
        ((ActorUtils)Mockito.doReturn(this.batchedModificationsReply(count)).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    protected void expectBatchedModificationsReady(ActorRef actorRef) {
        this.expectBatchedModificationsReady(actorRef, false);
    }

    protected void expectBatchedModificationsReady(ActorRef actorRef, boolean doCommitOnReady) {
        ((ActorUtils)Mockito.doReturn(doCommitOnReady ? Futures.successful((Object)new CommitTransactionReply().toSerializable()) : this.readyTxReply(actorRef.path().toString())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    protected void expectIncompleteBatchedModifications() {
        ((ActorUtils)Mockito.doReturn(this.incompleteFuture()).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.any(ActorSelection.class), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    protected void expectFailedBatchedModifications(ActorRef actorRef) {
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new TransactionProxyTest.TestException())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(BatchedModifications.class), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    protected void expectReadyLocalTransaction(ActorRef actorRef, boolean doCommitOnReady) {
        ((ActorUtils)Mockito.doReturn(doCommitOnReady ? Futures.successful((Object)new CommitTransactionReply().toSerializable()) : this.readyTxReply(actorRef.path().toString())).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), ArgumentMatchers.isA(ReadyLocalTransaction.class), (Timeout)ArgumentMatchers.any(Timeout.class));
    }

    protected CreateTransactionReply createTransactionReply(ActorRef actorRef, short transactionVersion) {
        return new CreateTransactionReply(actorRef.path().toString(), AbstractTransactionProxyTest.nextTransactionId(), transactionVersion);
    }

    protected ActorRef setupActorContextWithoutInitialCreateTransaction(ActorSystem actorSystem) {
        return this.setupActorContextWithoutInitialCreateTransaction(actorSystem, "default");
    }

    protected ActorRef setupActorContextWithoutInitialCreateTransaction(ActorSystem actorSystem, String shardName) {
        return this.setupActorContextWithoutInitialCreateTransaction(actorSystem, shardName, (short)13);
    }

    protected ActorRef setupActorContextWithoutInitialCreateTransaction(ActorSystem actorSystem, String shardName, short transactionVersion) {
        ActorRef actorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
        this.log.info("Created mock shard actor {}", (Object)actorRef);
        ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(actorRef.path())).when((Object)this.mockActorContext)).actorSelection(actorRef.path().toString());
        ((ActorUtils)Mockito.doReturn(this.primaryShardInfoReply(actorSystem, actorRef, transactionVersion)).when((Object)this.mockActorContext)).findPrimaryShardAsync((String)ArgumentMatchers.eq((Object)shardName));
        return actorRef;
    }

    protected Future<PrimaryShardInfo> primaryShardInfoReply(ActorSystem actorSystem, ActorRef actorRef) {
        return this.primaryShardInfoReply(actorSystem, actorRef, (short)13);
    }

    protected Future<PrimaryShardInfo> primaryShardInfoReply(ActorSystem actorSystem, ActorRef actorRef, short transactionVersion) {
        return Futures.successful((Object)new PrimaryShardInfo(actorSystem.actorSelection(actorRef.path()), transactionVersion));
    }

    protected ActorRef setupActorContextWithInitialCreateTransaction(ActorSystem actorSystem, TransactionType type, short transactionVersion, String shardName) {
        ActorRef shardActorRef = this.setupActorContextWithoutInitialCreateTransaction(actorSystem, shardName, transactionVersion);
        return this.setupActorContextWithInitialCreateTransaction(actorSystem, type, transactionVersion, "mock-member", shardActorRef);
    }

    protected ActorRef setupActorContextWithInitialCreateTransaction(ActorSystem actorSystem, TransactionType type, short transactionVersion, String prefix, ActorRef shardActorRef) {
        ActorRef txActorRef;
        if (type == TransactionType.WRITE_ONLY && this.dataStoreContextBuilder.build().isWriteOnlyTransactionOptimizationsEnabled()) {
            txActorRef = shardActorRef;
        } else {
            txActorRef = actorSystem.actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]));
            this.log.info("Created mock shard Tx actor {}", (Object)txActorRef);
            ((ActorUtils)Mockito.doReturn((Object)actorSystem.actorSelection(txActorRef.path())).when((Object)this.mockActorContext)).actorSelection(txActorRef.path().toString());
            ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)this.createTransactionReply(txActorRef, transactionVersion))).when((Object)this.mockActorContext)).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)actorSystem.actorSelection(shardActorRef.path())), (Object)this.eqCreateTransaction(prefix, type), (Timeout)ArgumentMatchers.any(Timeout.class));
        }
        return txActorRef;
    }

    protected ActorRef setupActorContextWithInitialCreateTransaction(ActorSystem actorSystem, TransactionType type) {
        return this.setupActorContextWithInitialCreateTransaction(actorSystem, type, (short)13, "default");
    }

    protected ActorRef setupActorContextWithInitialCreateTransaction(ActorSystem actorSystem, TransactionType type, String shardName) {
        return this.setupActorContextWithInitialCreateTransaction(actorSystem, type, (short)13, shardName);
    }

    protected void propagateReadFailedExceptionCause(FluentFuture<?> future) throws Throwable {
        try {
            future.get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected ReadFailedException");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)("Unexpected cause: " + cause.getClass()), (boolean)(cause instanceof ReadFailedException));
            throw Throwables.getRootCause((Throwable)cause);
        }
    }

    protected List<BatchedModifications> captureBatchedModifications(ActorRef actorRef) {
        ArgumentCaptor batchedModificationsCaptor = ArgumentCaptor.forClass(BatchedModifications.class);
        ((ActorUtils)Mockito.verify((Object)this.mockActorContext, (VerificationMode)Mockito.atLeastOnce())).executeOperationAsync((ActorSelection)ArgumentMatchers.eq((Object)this.actorSelection(actorRef)), batchedModificationsCaptor.capture(), (Timeout)ArgumentMatchers.any(Timeout.class));
        List<BatchedModifications> batchedModifications = this.filterCaptured(batchedModificationsCaptor, BatchedModifications.class);
        return batchedModifications;
    }

    protected <T> List<T> filterCaptured(ArgumentCaptor<T> captor, Class<T> type) {
        ArrayList captured = new ArrayList();
        for (Object c : captor.getAllValues()) {
            if (!type.isInstance(c)) continue;
            captured.add(c);
        }
        return captured;
    }

    protected void verifyOneBatchedModification(ActorRef actorRef, Modification expected, boolean expIsReady) {
        List<BatchedModifications> batchedModifications = this.captureBatchedModifications(actorRef);
        Assert.assertEquals((String)"Captured BatchedModifications count", (long)1L, (long)batchedModifications.size());
        this.verifyBatchedModifications((Object)batchedModifications.get(0), expIsReady, expIsReady, expected);
    }

    protected void verifyBatchedModifications(Object message, boolean expIsReady, Modification ... expected) {
        this.verifyBatchedModifications(message, expIsReady, false, expected);
    }

    protected void verifyBatchedModifications(Object message, boolean expIsReady, boolean expIsDoCommitOnReady, Modification ... expected) {
        Assert.assertEquals((String)"Message type", BatchedModifications.class, message.getClass());
        BatchedModifications batchedModifications = (BatchedModifications)message;
        Assert.assertEquals((String)"BatchedModifications size", (long)expected.length, (long)batchedModifications.getModifications().size());
        Assert.assertEquals((String)"isReady", (Object)expIsReady, (Object)batchedModifications.isReady());
        Assert.assertEquals((String)"isDoCommitOnReady", (Object)expIsDoCommitOnReady, (Object)batchedModifications.isDoCommitOnReady());
        for (int i = 0; i < batchedModifications.getModifications().size(); ++i) {
            Modification actual = (Modification)batchedModifications.getModifications().get(i);
            Assert.assertEquals((String)"Modification type", expected[i].getClass(), actual.getClass());
            Assert.assertEquals((String)"getPath", (Object)((AbstractModification)expected[i]).getPath(), (Object)((AbstractModification)actual).getPath());
            if (!(actual instanceof WriteModification)) continue;
            Assert.assertEquals((String)"getData", (Object)((WriteModification)expected[i]).getData(), (Object)((WriteModification)actual).getData());
        }
    }

    protected void verifyCohortFutures(AbstractThreePhaseCommitCohort<?> proxy, Object ... expReplies) {
        Assert.assertEquals((String)"getReadyOperationFutures size", (long)expReplies.length, (long)proxy.getCohortFutures().size());
        ArrayList<Object> futureResults = new ArrayList<Object>();
        for (Future future : proxy.getCohortFutures()) {
            Assert.assertNotNull((String)"Ready operation Future is null", (Object)future);
            try {
                futureResults.add(Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS)));
            }
            catch (Exception e) {
                futureResults.add(e);
            }
        }
        for (Object expReply : expReplies) {
            boolean found = false;
            Iterator iter = futureResults.iterator();
            while (iter.hasNext()) {
                Object actual = iter.next();
                if (CommitTransactionReply.isSerializedType((Object)expReply) && CommitTransactionReply.isSerializedType(actual) || expReply instanceof ActorSelection && Objects.equals(expReply, actual)) {
                    found = true;
                } else if (expReply instanceof Class && ((Class)expReply).isInstance(actual)) {
                    found = true;
                }
                if (!found) continue;
                iter.remove();
                break;
            }
            if (found) continue;
            Assert.fail((String)String.format("No cohort Future response found for %s. Actual: %s", expReply, futureResults));
        }
    }
}

