/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.DebugThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.MockIdentifiers;
import org.slf4j.Logger;

public class DebugThreePhaseCommitCohortTest {
    private final TransactionIdentifier transactionId = MockIdentifiers.transactionIdentifier(DebugThreePhaseCommitCohortTest.class, "mock");

    @Test
    public void test() {
        AbstractThreePhaseCommitCohort mockDelegate = (AbstractThreePhaseCommitCohort)Mockito.mock(AbstractThreePhaseCommitCohort.class);
        Exception failure = new Exception("mock failure");
        ListenableFuture expFailedFuture = Futures.immediateFailedFuture((Throwable)failure);
        ((AbstractThreePhaseCommitCohort)Mockito.doReturn((Object)expFailedFuture).when((Object)mockDelegate)).canCommit();
        ((AbstractThreePhaseCommitCohort)Mockito.doReturn((Object)expFailedFuture).when((Object)mockDelegate)).preCommit();
        ((AbstractThreePhaseCommitCohort)Mockito.doReturn((Object)expFailedFuture).when((Object)mockDelegate)).commit();
        ListenableFuture expAbortFuture = Futures.immediateFuture(null);
        ((AbstractThreePhaseCommitCohort)Mockito.doReturn((Object)expAbortFuture).when((Object)mockDelegate)).abort();
        ArrayList expCohortFutures = new ArrayList();
        ((AbstractThreePhaseCommitCohort)Mockito.doReturn(expCohortFutures).when((Object)mockDelegate)).getCohortFutures();
        RuntimeException debugContext = new RuntimeException("mock");
        DebugThreePhaseCommitCohort cohort = new DebugThreePhaseCommitCohort(this.transactionId, mockDelegate, (Throwable)debugContext);
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        cohort.setLogger(mockLogger);
        Assert.assertSame((String)"canCommit", (Object)expFailedFuture, (Object)cohort.canCommit());
        ((Logger)Mockito.verify((Object)mockLogger)).warn(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.same((Object)this.transactionId), ArgumentMatchers.same((Object)failure), ArgumentMatchers.same((Object)debugContext)});
        Mockito.reset((Object[])new Logger[]{mockLogger});
        Assert.assertSame((String)"preCommit", (Object)expFailedFuture, (Object)cohort.preCommit());
        ((Logger)Mockito.verify((Object)mockLogger)).warn(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.same((Object)this.transactionId), ArgumentMatchers.same((Object)failure), ArgumentMatchers.same((Object)debugContext)});
        Mockito.reset((Object[])new Logger[]{mockLogger});
        Assert.assertSame((String)"commit", (Object)expFailedFuture, (Object)cohort.commit());
        ((Logger)Mockito.verify((Object)mockLogger)).warn(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.same((Object)this.transactionId), ArgumentMatchers.same((Object)failure), ArgumentMatchers.same((Object)debugContext)});
        Assert.assertSame((String)"abort", (Object)expAbortFuture, (Object)cohort.abort());
        Assert.assertSame((String)"getCohortFutures", expCohortFutures, (Object)cohort.getCohortFutures());
        Mockito.reset((Object[])new Logger[]{mockLogger});
        ListenableFuture expSuccessFuture = Futures.immediateFuture((Object)Boolean.TRUE);
        ((AbstractThreePhaseCommitCohort)Mockito.doReturn((Object)expSuccessFuture).when((Object)mockDelegate)).canCommit();
        Assert.assertSame((String)"canCommit", (Object)expSuccessFuture, (Object)cohort.canCommit());
        ((Logger)Mockito.verify((Object)mockLogger, (VerificationMode)Mockito.never())).warn(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.any(TransactionIdentifier.class), ArgumentMatchers.any(Throwable.class), ArgumentMatchers.any(Throwable.class)});
    }
}

