/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.ShardStats;

public class ShardStatsTest {
    private MBeanServer mbeanServer;
    private ShardStats shardStats;
    private ObjectName testMBeanName;

    @Before
    public void setUp() throws Exception {
        this.shardStats = new ShardStats("shard-1", "DataStore", null);
        this.shardStats.registerMBean();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        String objectName = "org.opendaylight.controller:type=" + this.shardStats.getMBeanType() + ",Category=" + this.shardStats.getMBeanCategory() + ",name=" + this.shardStats.getMBeanName();
        this.testMBeanName = new ObjectName(objectName);
    }

    @After
    public void tearDown() {
        this.shardStats.unregisterMBean();
    }

    @Test
    public void testGetShardName() throws Exception {
        Assert.assertEquals((Object)"shard-1", (Object)this.mbeanServer.getAttribute(this.testMBeanName, "ShardName"));
    }

    @Test
    public void testGetCommittedTransactionsCount() throws Exception {
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        Assert.assertEquals((Object)3L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "CommittedTransactionsCount"));
    }

    @Test
    public void testGetLastCommittedTransactionTime() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Assert.assertEquals((Object)sdf.format(new Date(0L)), (Object)this.shardStats.getLastCommittedTransactionTime());
        long millis = System.currentTimeMillis();
        this.shardStats.setLastCommittedTransactionTime(millis);
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "LastCommittedTransactionTime");
        Assert.assertEquals((Object)sdf.format(new Date(millis)), (Object)attribute);
        Assert.assertNotEquals((Object)attribute, (Object)sdf.format(new Date(millis - 1L)));
    }

    @Test
    public void testGetFailedTransactionsCount() throws Exception {
        this.shardStats.incrementFailedTransactionsCount();
        this.shardStats.incrementFailedTransactionsCount();
        Assert.assertEquals((Object)2L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "FailedTransactionsCount"));
    }

    @Test
    public void testGetAbortTransactionsCount() throws Exception {
        this.shardStats.incrementAbortTransactionsCount();
        this.shardStats.incrementAbortTransactionsCount();
        Assert.assertEquals((Object)2L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "AbortTransactionsCount"));
    }

    @Test
    public void testGetFailedReadTransactionsCount() throws Exception {
        this.shardStats.incrementFailedReadTransactionsCount();
        this.shardStats.incrementFailedReadTransactionsCount();
        Assert.assertEquals((Object)2L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "FailedReadTransactionsCount"));
    }

    @Test
    public void testResetTransactionCounters() throws Exception {
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        Assert.assertEquals((Object)3L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "CommittedTransactionsCount"));
        this.shardStats.incrementFailedReadTransactionsCount();
        this.shardStats.incrementFailedReadTransactionsCount();
        Assert.assertEquals((Object)2L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "FailedReadTransactionsCount"));
        this.mbeanServer.invoke(this.testMBeanName, "resetTransactionCounters", null, null);
        Assert.assertEquals((Object)0L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "CommittedTransactionsCount"));
        Assert.assertEquals((Object)0L, (Object)this.mbeanServer.getAttribute(this.testMBeanName, "FailedReadTransactionsCount"));
    }
}

