/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.ImmutableSortedSet;
import java.io.NotSerializableException;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransactionSerializer;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;

public class ReadyLocalTransactionSerializerTest
extends AbstractTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToAndFromBinary() throws NotSerializableException {
        Object deserialized;
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, TestModel.createTestContext());
        DataTreeModification modification = dataTree.takeSnapshot().newModification();
        ContainerNode writeData = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        new WriteModification(TestModel.TEST_PATH, (NormalizedNode)writeData).apply(modification);
        MapNode mergeData = (MapNode)ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build();
        new MergeModification(TestModel.OUTER_LIST_PATH, (NormalizedNode)mergeData).apply(modification);
        ImmutableSortedSet shardNames = ImmutableSortedSet.of((Comparable)((Object)"one"), (Comparable)((Object)"two"));
        TransactionIdentifier txId = ReadyLocalTransactionSerializerTest.nextTransactionId();
        ReadyLocalTransaction readyMessage = new ReadyLocalTransaction(txId, modification, true, Optional.of(shardNames));
        ExtendedActorSystem system = (ExtendedActorSystem)ExtendedActorSystem.create((String)"test");
        try {
            ReadyLocalTransactionSerializer serializer = new ReadyLocalTransactionSerializer(system);
            byte[] bytes = serializer.toBinary((Object)readyMessage);
            deserialized = serializer.fromBinary(bytes, ReadyLocalTransaction.class);
        }
        finally {
            TestKit.shutdownActorSystem((ActorSystem)system);
        }
        Assert.assertNotNull((String)"fromBinary returned null", (Object)deserialized);
        Assert.assertEquals((String)"fromBinary return type", BatchedModifications.class, deserialized.getClass());
        BatchedModifications batched = (BatchedModifications)deserialized;
        Assert.assertEquals((String)"getTransactionID", (Object)txId, (Object)batched.getTransactionId());
        Assert.assertEquals((String)"getVersion", (long)13L, (long)batched.getVersion());
        Assert.assertTrue((String)"isReady", (boolean)batched.isReady());
        Assert.assertTrue((String)"isDoCommitOnReady", (boolean)batched.isDoCommitOnReady());
        Assert.assertEquals((String)"participatingShardNames", Optional.of(shardNames), (Object)batched.getParticipatingShardNames());
        List batchedMods = batched.getModifications();
        Assert.assertEquals((String)"getModifications size", (long)2L, (long)batchedMods.size());
        Modification mod = (Modification)batchedMods.get(0);
        Assert.assertEquals((String)"Modification type", WriteModification.class, mod.getClass());
        Assert.assertEquals((String)"Modification getPath", (Object)TestModel.TEST_PATH, (Object)((WriteModification)mod).getPath());
        Assert.assertEquals((String)"Modification getData", (Object)writeData, (Object)((WriteModification)mod).getData());
        mod = (Modification)batchedMods.get(1);
        Assert.assertEquals((String)"Modification type", MergeModification.class, mod.getClass());
        Assert.assertEquals((String)"Modification getPath", (Object)TestModel.OUTER_LIST_PATH, (Object)((MergeModification)mod).getPath());
        Assert.assertEquals((String)"Modification getData", (Object)mergeData, (Object)((MergeModification)mod).getData());
    }
}

