/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModificationTest;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DeleteModificationTest
extends AbstractModificationTest {
    @Test
    public void testApply() throws Exception {
        DOMStoreReadWriteTransaction writeTransaction = this.store.newReadWriteTransaction();
        WriteModification writeModification = new WriteModification(TestModel.TEST_PATH, (NormalizedNode)TEST_CONTAINER);
        writeModification.apply((DOMStoreWriteTransaction)writeTransaction);
        this.commitTransaction((DOMStoreWriteTransaction)writeTransaction);
        Assert.assertEquals(Optional.of(TEST_CONTAINER), this.readData(TestModel.TEST_PATH));
        DOMStoreWriteTransaction deleteTransaction = this.store.newWriteOnlyTransaction();
        DeleteModification deleteModification = new DeleteModification(TestModel.TEST_PATH);
        deleteModification.apply(deleteTransaction);
        this.commitTransaction(deleteTransaction);
        Assert.assertEquals(Optional.empty(), this.readData(TestModel.TEST_PATH));
    }

    @Test
    public void testSerialization() {
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        DeleteModification expected = new DeleteModification(path);
        DeleteModification clone = (DeleteModification)SerializationUtils.clone((Serializable)expected);
        Assert.assertEquals((String)"getPath", (Object)expected.getPath(), (Object)clone.getPath());
    }
}

