/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.DataTreeCandidateInputOutput;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;

public class CommitTransactionPayloadTest
extends AbstractTest {
    static final QName LEAF_SET = QName.create((QName)TestModel.TEST_QNAME, (String)"leaf-set");
    private DataTreeCandidate candidate;

    private static DataTreeCandidateNode findNode(Collection<DataTreeCandidateNode> nodes, YangInstanceIdentifier.PathArgument arg) {
        for (DataTreeCandidateNode node : nodes) {
            if (!arg.equals((Object)node.name())) continue;
            return node;
        }
        return null;
    }

    private static void assertChildrenEquals(Collection<DataTreeCandidateNode> expected, Collection<DataTreeCandidateNode> actual) {
        for (DataTreeCandidateNode exp : expected) {
            DataTreeCandidateNode act = CommitTransactionPayloadTest.findNode(actual, exp.name());
            Assert.assertNotNull((String)"missing expected child", (Object)act);
            CommitTransactionPayloadTest.assertCandidateNodeEquals(exp, act);
        }
        for (DataTreeCandidateNode act : actual) {
            DataTreeCandidateNode exp = CommitTransactionPayloadTest.findNode(expected, act.name());
            Assert.assertNull((String)"unexpected child", (Object)exp);
        }
    }

    private static void assertCandidateEquals(DataTreeCandidate expected, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion actual) {
        DataTreeCandidate candidate = actual.candidate();
        Assert.assertEquals((String)"root path", (Object)expected.getRootPath(), (Object)candidate.getRootPath());
        CommitTransactionPayloadTest.assertCandidateNodeEquals(expected.getRootNode(), candidate.getRootNode());
    }

    private static void assertCandidateNodeEquals(DataTreeCandidateNode expected, DataTreeCandidateNode actual) {
        Assert.assertEquals((String)"child type", (Object)expected.modificationType(), (Object)actual.modificationType());
        switch (actual.modificationType()) {
            case DELETE: 
            case WRITE: {
                Assert.assertEquals((String)"child identifier", (Object)expected.name(), (Object)actual.name());
                Assert.assertEquals((String)"child data", (Object)expected.dataAfter(), (Object)actual.dataAfter());
                break;
            }
            case SUBTREE_MODIFIED: {
                Assert.assertEquals((String)"child identifier", (Object)expected.name(), (Object)actual.name());
                CommitTransactionPayloadTest.assertChildrenEquals(expected.childNodes(), actual.childNodes());
                break;
            }
            case UNMODIFIED: {
                break;
            }
            default: {
                Assert.fail((String)("Unexpect root type " + actual.modificationType()));
            }
        }
    }

    @Before
    public void setUp() {
        CommitTransactionPayloadTest.setUpStatic();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)TestModel.TEST_PATH, (NormalizedNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build());
    }

    @Test
    public void testCandidateSerialization() throws IOException {
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        Assert.assertEquals((String)"payload size", (long)156L, (long)payload.size());
        Assert.assertEquals((String)"serialized size", (long)242L, (long)SerializationUtils.serialize((Serializable)payload).length);
    }

    @Test
    public void testCandidateSerDes() throws IOException {
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testPayloadSerDes() throws IOException {
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)((CommitTransactionPayload)SerializationUtils.clone((Serializable)payload)).getCandidate().getValue());
    }

    @Test
    public void testLeafSetEntryNodeCandidate() throws Exception {
        YangInstanceIdentifier.NodeWithValue entryPathArg = new YangInstanceIdentifier.NodeWithValue(LEAF_SET, (Object)"one");
        YangInstanceIdentifier leafSetEntryPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(LEAF_SET).node((YangInstanceIdentifier.PathArgument)entryPathArg).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafSetEntryPath, (NormalizedNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)entryPathArg).withValue((Object)"one").build());
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testLeafSetNodeCandidate() throws Exception {
        YangInstanceIdentifier leafSetPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(LEAF_SET).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafSetPath, (NormalizedNode)Builders.leafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(LEAF_SET)).withChild((LeafSetEntryNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(LEAF_SET, (Object)"one")).withValue((Object)"one").build()).build());
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testOrderedLeafSetNodeCandidate() throws Exception {
        YangInstanceIdentifier leafSetPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(LEAF_SET).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafSetPath, (NormalizedNode)Builders.orderedLeafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(LEAF_SET)).withChild((LeafSetEntryNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(LEAF_SET, (Object)"one")).withValue((Object)"one").build()).build());
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testLeafNodeCandidate() throws Exception {
        YangInstanceIdentifier leafPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(TestModel.DESC_QNAME).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafPath, (NormalizedNode)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"test"));
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testUnmodifiedRootCandidate() throws Exception {
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION, SchemaContextHelper.select("/cars.yang"));
        DataTreeModification modification = dataTree.takeSnapshot().newModification();
        modification.ready();
        this.candidate = dataTree.prepare(modification);
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }
}

