/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorRef;
import akka.actor.Props;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.TestShard;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.AbstractShardManagerCreator;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardInformation;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManager;

public class TestShardManager
extends ShardManager {
    TestShardManager(AbstractShardManagerCreator<?> builder) {
        super(builder);
    }

    public void handleCommand(Object message) throws Exception {
        if (GetLocalShards.INSTANCE.equals(message)) {
            this.sender().tell((Object)new GetLocalShardsReply(this.localShards), null);
        } else {
            super.handleCommand(message);
        }
    }

    protected ActorRef newShardActor(ShardInformation info) {
        Map peerAddresses = this.getPeerAddresses(info.getShardName());
        ShardInformation newInfo = new ShardInformation(info.getShardName(), info.getShardId(), peerAddresses, info.getDatastoreContext(), TestShard.builder().restoreFromSnapshot(info.getBuilder().getRestoreFromSnapshot()), this.peerAddressResolver);
        newInfo.setSchemaContext(info.getSchemaContext());
        newInfo.setActiveMember(info.isActiveMember());
        this.localShards.put(info.getShardName(), info);
        return this.getContext().actorOf(newInfo.newProps().withDispatcher(this.shardDispatcherPath), info.getShardId().toString());
    }

    ShardInformation createShardInfoFor(String shardName, ShardIdentifier shardId, Map<String, String> peerAddresses, DatastoreContext datastoreContext, Map<String, DatastoreSnapshot.ShardSnapshot> shardSnapshots) {
        return new ShardInformation(shardName, shardId, peerAddresses, datastoreContext, TestShard.builder().restoreFromSnapshot(shardSnapshots.get(shardName)), this.peerAddressResolver);
    }

    public static final class GetLocalShards {
        public static final GetLocalShards INSTANCE = new GetLocalShards();

        private GetLocalShards() {
        }
    }

    public static class GetLocalShardsReply {
        private final Map<String, ShardInformation> localShards;

        public GetLocalShardsReply(Map<String, ShardInformation> localShards) {
            this.localShards = localShards;
        }

        public Map<String, ShardInformation> getLocalShards() {
            return this.localShards;
        }
    }

    public static class TestShardManagerCreator
    extends AbstractShardManagerCreator<TestShardManagerCreator> {
        public Props props() {
            this.verify();
            return Props.create(TestShardManager.class, (Object[])new Object[]{this});
        }
    }
}

