/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongSet;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class UnsignedLongSetTest {
    @Test
    public void testOperations() {
        MutableUnsignedLongSet set = MutableUnsignedLongSet.of();
        Assert.assertEquals((Object)"MutableUnsignedLongSet{size=0}", (Object)set.toString());
        Assert.assertFalse((boolean)set.contains(0L));
        set.add(0L);
        Assert.assertTrue((boolean)set.contains(0L));
        UnsignedLongSetTest.assertRanges("[[0..0]]", (UnsignedLongSet)set);
        set.add(1L);
        Assert.assertTrue((boolean)set.contains(1L));
        UnsignedLongSetTest.assertRanges("[[0..1]]", (UnsignedLongSet)set);
        set.add(1L);
        UnsignedLongSetTest.assertRanges("[[0..1]]", (UnsignedLongSet)set);
        set.add(4L);
        UnsignedLongSetTest.assertRanges("[[0..1], [4..4]]", (UnsignedLongSet)set);
        set.add(3L);
        UnsignedLongSetTest.assertRanges("[[0..1], [3..4]]", (UnsignedLongSet)set);
        set.add(2L);
        UnsignedLongSetTest.assertRanges("[[0..4]]", (UnsignedLongSet)set);
        Assert.assertTrue((boolean)set.contains(2L));
        Assert.assertTrue((boolean)set.contains(3L));
        Assert.assertTrue((boolean)set.contains(4L));
        set.add(8L);
        UnsignedLongSetTest.assertRanges("[[0..4], [8..8]]", (UnsignedLongSet)set);
        set.add(6L);
        UnsignedLongSetTest.assertRanges("[[0..4], [6..6], [8..8]]", (UnsignedLongSet)set);
        set.add(7L);
        UnsignedLongSetTest.assertRanges("[[0..4], [6..8]]", (UnsignedLongSet)set);
        set.add(5L);
        UnsignedLongSetTest.assertRanges("[[0..8]]", (UnsignedLongSet)set);
        set.add(11L);
        UnsignedLongSetTest.assertRanges("[[0..8], [11..11]]", (UnsignedLongSet)set);
        set.add(9L);
        UnsignedLongSetTest.assertRanges("[[0..9], [11..11]]", (UnsignedLongSet)set);
    }

    @Test
    public void testSerialization() throws IOException {
        ImmutableUnsignedLongSet read;
        ImmutableUnsignedLongSet set = MutableUnsignedLongSet.of((long[])new long[]{0L, 1L, 4L, 3L}).immutableCopy();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bos);){
            set.writeTo((DataOutput)out);
        }
        byte[] bytes = bos.toByteArray();
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 2, 16, 2, 17, 3, 5}, (byte[])bytes);
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));){
            read = ImmutableUnsignedLongSet.readFrom((DataInput)in);
            Assert.assertEquals((long)0L, (long)in.available());
        }
        Assert.assertEquals((Object)set, (Object)read);
    }

    @Test
    public void testToRangeSet() {
        MutableUnsignedLongSet set = MutableUnsignedLongSet.of((long[])new long[]{0L, 1L, 4L, 3L});
        Assert.assertEquals((Object)"[[0..2), [3..5)]", (Object)set.toRangeSet().toString());
    }

    @Test
    public void testEmptyCopy() {
        MutableUnsignedLongSet orig = MutableUnsignedLongSet.of();
        Assert.assertSame((Object)ImmutableUnsignedLongSet.of(), (Object)orig.immutableCopy());
        MutableUnsignedLongSet copy = orig.mutableCopy();
        Assert.assertEquals((Object)orig, (Object)copy);
        Assert.assertNotSame((Object)orig, (Object)copy);
    }

    @Test
    public void testMutableCopy() {
        MutableUnsignedLongSet orig = MutableUnsignedLongSet.of();
        orig.add(-1L);
        Assert.assertEquals((Object)"MutableUnsignedLongSet{span=[18446744073709551615..18446744073709551615], size=1}", (Object)orig.toString());
        MutableUnsignedLongSet copy = orig.mutableCopy();
        Assert.assertEquals((Object)orig, (Object)copy);
        Assert.assertNotSame((Object)orig, (Object)copy);
        orig.add(-2L);
        Assert.assertNotEquals((Object)orig, (Object)copy);
        Assert.assertEquals((Object)"MutableUnsignedLongSet{span=[18446744073709551614..18446744073709551615], size=1}", (Object)orig.toString());
    }

    @Test
    public void testWriteRangesTo() throws IOException {
        ImmutableUnsignedLongSet.of().writeRangesTo((DataOutput)Mockito.mock(DataOutput.class), 0);
    }

    @Test
    public void testWriteRangesToViolation() {
        IOException ex = (IOException)Assert.assertThrows(IOException.class, () -> ImmutableUnsignedLongSet.of().writeRangesTo((DataOutput)Mockito.mock(DataOutput.class), 1));
        Assert.assertEquals((Object)"Mismatched size: expected 0, got 1", (Object)ex.getMessage());
    }

    @Test
    public void testAddRange() {
        MutableUnsignedLongSet set = UnsignedLongSetTest.sparseSet();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{1L, 2L}));
        UnsignedLongSetTest.assertRanges("[[1..2], [5..6], [9..10], [13..14]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{3L, 4L}));
        UnsignedLongSetTest.assertRanges("[[1..6], [9..10], [13..14]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L}));
        UnsignedLongSetTest.assertRanges("[[1..15]]", (UnsignedLongSet)set);
        set = UnsignedLongSetTest.sparseSet();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{2L, 3L, 4L, 5L}));
        UnsignedLongSetTest.assertRanges("[[1..6], [9..10], [13..14]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{6L, 7L}));
        UnsignedLongSetTest.assertRanges("[[1..7], [9..10], [13..14]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{8L}));
        UnsignedLongSetTest.assertRanges("[[1..10], [13..14]]", (UnsignedLongSet)set);
        set = MutableUnsignedLongSet.of();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{1L, 2L}));
        UnsignedLongSetTest.assertRanges("[[1..2]]", (UnsignedLongSet)set);
        set = UnsignedLongSetTest.sparseSet();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{4L, 5L}));
        UnsignedLongSetTest.assertRanges("[[1..2], [4..6], [9..10], [13..14]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{12L, 13L, 14L, 15L}));
        UnsignedLongSetTest.assertRanges("[[1..2], [4..6], [9..10], [12..15]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{8L, 9L, 10L, 11L}));
        UnsignedLongSetTest.assertRanges("[[1..2], [4..6], [8..15]]", (UnsignedLongSet)set);
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L}));
        UnsignedLongSetTest.assertRanges("[[0..16]]", (UnsignedLongSet)set);
        set = UnsignedLongSetTest.sparseSet();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{0L, 1L, 2L, 3L}));
        UnsignedLongSetTest.assertRanges("[[0..3], [5..6], [9..10], [13..14]]", (UnsignedLongSet)set);
        set = UnsignedLongSetTest.sparseSet();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}));
        UnsignedLongSetTest.assertRanges("[[0..10], [13..14]]", (UnsignedLongSet)set);
        set = UnsignedLongSetTest.sparseSet();
        set.addAll((UnsignedLongSet)MutableUnsignedLongSet.of((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}));
        UnsignedLongSetTest.assertRanges("[[0..10], [13..14]]", (UnsignedLongSet)set);
    }

    private static MutableUnsignedLongSet sparseSet() {
        MutableUnsignedLongSet ret = MutableUnsignedLongSet.of((long[])new long[]{1L, 2L, 5L, 6L, 9L, 10L, 13L, 14L});
        UnsignedLongSetTest.assertRanges("[[1..2], [5..6], [9..10], [13..14]]", (UnsignedLongSet)ret);
        return ret;
    }

    private static void assertRanges(String expected, UnsignedLongSet set) {
        Assert.assertEquals((Object)expected, (Object)set.ranges().toString());
    }
}

