/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.cluster.datastore.model;

import java.io.InputStream;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;

public final class SchemaContextHelper {
    public static final String ODL_DATASTORE_TEST_YANG = "/odl-datastore-test.yang";
    public static final String PEOPLE_YANG = "/people.yang";
    public static final String CARS_YANG = "/cars.yang";
    private static volatile EffectiveModelContext FULL;

    private SchemaContextHelper() {
    }

    public static InputStream getInputStream(String yangFileName) {
        return SchemaContextHelper.class.getResourceAsStream(yangFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EffectiveModelContext full() {
        EffectiveModelContext ret = FULL;
        if (ret != null) return ret;
        Class<SchemaContextHelper> clazz = SchemaContextHelper.class;
        synchronized (SchemaContextHelper.class) {
            ret = FULL;
            if (ret != null) return ret;
            FULL = SchemaContextHelper.select(ODL_DATASTORE_TEST_YANG, PEOPLE_YANG, CARS_YANG);
            return FULL;
        }
    }

    public static EffectiveModelContext select(String ... schemaFiles) {
        return YangParserTestUtils.parseYangResources(SchemaContextHelper.class, (String[])schemaFiles);
    }
}

