/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBrokerWriteTransaction;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.common.api.TransactionDatastoreMismatchException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class AbstractDOMBrokerWriteTransactionTest {
    @Mock
    private DOMStoreTransactionFactory txFactory;
    @Mock
    private AbstractDOMTransactionFactory<?> abstractDOMTransactionFactory;
    @Mock
    private DOMStoreWriteTransaction domStoreWriteTransaction;

    @Test
    public void readyRuntimeExceptionAndCancel() {
        RuntimeException thrown = new RuntimeException();
        ((DOMStoreWriteTransaction)Mockito.doThrow((Throwable[])new Throwable[]{thrown}).when((Object)this.domStoreWriteTransaction)).ready();
        AbstractDOMBrokerWriteTransactionTestImpl abstractDOMBrokerWriteTransactionTestImpl = new AbstractDOMBrokerWriteTransactionTestImpl();
        FluentFuture submitFuture = abstractDOMBrokerWriteTransactionTestImpl.commit();
        Throwable cause = ((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ((FluentFuture)submitFuture).get())).getCause();
        Assert.assertTrue((boolean)(cause instanceof TransactionCommitFailedException));
        Assert.assertSame((Object)thrown, (Object)cause.getCause());
        abstractDOMBrokerWriteTransactionTestImpl.cancel();
    }

    @Test
    public void submitRuntimeExceptionAndCancel() throws InterruptedException {
        RuntimeException thrown = new RuntimeException();
        ((AbstractDOMTransactionFactory)Mockito.doThrow((Throwable[])new Throwable[]{thrown}).when(this.abstractDOMTransactionFactory)).commit((DOMDataTreeWriteTransaction)ArgumentMatchers.any(), (DOMStoreThreePhaseCommitCohort)ArgumentMatchers.any());
        AbstractDOMBrokerWriteTransactionTestImpl abstractDOMBrokerWriteTransactionTestImpl = new AbstractDOMBrokerWriteTransactionTestImpl();
        FluentFuture submitFuture = abstractDOMBrokerWriteTransactionTestImpl.commit();
        Throwable cause = ((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ((FluentFuture)submitFuture).get())).getCause();
        Assert.assertTrue((boolean)(cause instanceof TransactionCommitFailedException));
        Assert.assertSame((Object)thrown, (Object)cause.getCause());
        abstractDOMBrokerWriteTransactionTestImpl.cancel();
    }

    @Test
    public void getSubtransactionStoreMismatch() {
        AbstractDOMBrokerWriteTransactionTestImpl testTx = new AbstractDOMBrokerWriteTransactionTestImpl(Map.of(LogicalDatastoreType.CONFIGURATION, this.txFactory, LogicalDatastoreType.OPERATIONAL, this.txFactory));
        Assert.assertEquals((Object)this.domStoreWriteTransaction, (Object)testTx.getSubtransaction(LogicalDatastoreType.CONFIGURATION));
        TransactionDatastoreMismatchException exception = (TransactionDatastoreMismatchException)Assert.assertThrows(TransactionDatastoreMismatchException.class, () -> testTx.getSubtransaction(LogicalDatastoreType.OPERATIONAL));
        Assert.assertEquals((Object)LogicalDatastoreType.CONFIGURATION, (Object)exception.expected());
        Assert.assertEquals((Object)LogicalDatastoreType.OPERATIONAL, (Object)exception.encountered());
    }

    @Test
    public void getSubtransactionStoreUndefined() {
        AbstractDOMBrokerWriteTransactionTestImpl testTx = new AbstractDOMBrokerWriteTransactionTestImpl(Map.of(LogicalDatastoreType.OPERATIONAL, this.txFactory));
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> testTx.getSubtransaction(LogicalDatastoreType.CONFIGURATION));
        Assert.assertEquals((Object)"CONFIGURATION is not supported", (Object)exception.getMessage());
    }

    private class AbstractDOMBrokerWriteTransactionTestImpl
    extends AbstractDOMBrokerWriteTransaction<DOMStoreWriteTransaction> {
        AbstractDOMBrokerWriteTransactionTestImpl() {
            this(Map.of(LogicalDatastoreType.CONFIGURATION, abstractDOMBrokerWriteTransactionTest.txFactory));
        }

        AbstractDOMBrokerWriteTransactionTestImpl(Map<LogicalDatastoreType, DOMStoreTransactionFactory> txFactoryMap) {
            super(new Object(), txFactoryMap, AbstractDOMBrokerWriteTransactionTest.this.abstractDOMTransactionFactory);
        }

        protected DOMStoreWriteTransaction createTransaction(LogicalDatastoreType key) {
            return AbstractDOMBrokerWriteTransactionTest.this.domStoreWriteTransaction;
        }

        protected DOMStoreWriteTransaction getSubtransaction() {
            return AbstractDOMBrokerWriteTransactionTest.this.domStoreWriteTransaction;
        }
    }
}

