/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ClientBackedDataStoreTest {
    private static final ClientIdentifier UNKNOWN_ID = ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)MemberName.forName((String)"local"), (FrontendType)FrontendType.forName((String)"unknown")), (long)0L);
    private static final FrontendIdentifier FRONTEND_IDENTIFIER = FrontendIdentifier.create((MemberName)MemberName.forName((String)"member"), (FrontendType)FrontendType.forName((String)"frontend"));
    private static final ClientIdentifier CLIENT_IDENTIFIER = ClientIdentifier.create((FrontendIdentifier)FRONTEND_IDENTIFIER, (long)0L);
    private static final TransactionIdentifier TRANSACTION_IDENTIFIER = new TransactionIdentifier(new LocalHistoryIdentifier(CLIENT_IDENTIFIER, 0L), 0L);
    @Mock
    private DataStoreClient clientActor;
    @Mock
    private ActorUtils actorUtils;
    @Mock
    private ClientLocalHistory clientLocalHistory;
    @Mock
    private ClientTransaction clientTransaction;
    @Mock
    private ClientSnapshot clientSnapshot;

    @Before
    public void setUp() {
        ((ActorUtils)Mockito.doReturn((Object)DatastoreContext.newBuilder().build()).when((Object)this.actorUtils)).getDatastoreContext();
        ((ClientTransaction)Mockito.doReturn((Object)TRANSACTION_IDENTIFIER).when((Object)this.clientTransaction)).getIdentifier();
        ((ClientSnapshot)Mockito.doReturn((Object)TRANSACTION_IDENTIFIER).when((Object)this.clientSnapshot)).getIdentifier();
        ((DataStoreClient)Mockito.doReturn((Object)this.clientTransaction).when((Object)this.clientActor)).createTransaction();
        ((DataStoreClient)Mockito.doReturn((Object)this.clientLocalHistory).when((Object)this.clientActor)).createLocalHistory();
        ((DataStoreClient)Mockito.doReturn((Object)this.clientSnapshot).when((Object)this.clientActor)).createSnapshot();
    }

    @Test
    public void testCreateTransactionChain() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            Assert.assertNotNull((Object)clientBackedDataStore.createTransactionChain());
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createLocalHistory();
        }
    }

    @Test
    public void testNewReadOnlyTransaction() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            Assert.assertNotNull((Object)clientBackedDataStore.newReadOnlyTransaction());
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createSnapshot();
        }
    }

    @Test
    public void testNewWriteOnlyTransaction() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            Assert.assertNotNull((Object)clientBackedDataStore.newWriteOnlyTransaction());
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createTransaction();
        }
    }

    @Test
    public void testNewReadWriteTransaction() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            Assert.assertNotNull((Object)clientBackedDataStore.newReadWriteTransaction());
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createTransaction();
        }
    }
}

