/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Throwables;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.databroker.ConcurrentDOMDataBroker;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.broker.TransactionCommitFailedExceptionMapper;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class ConcurrentDOMDataBrokerTest {
    private final DOMDataTreeWriteTransaction transaction = (DOMDataTreeWriteTransaction)Mockito.mock(DOMDataTreeWriteTransaction.class);
    private final DOMStoreThreePhaseCommitCohort mockCohort = (DOMStoreThreePhaseCommitCohort)Mockito.mock(DOMStoreThreePhaseCommitCohort.class);
    private final ThreadPoolExecutor futureExecutor = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private ConcurrentDOMDataBroker coordinator;

    @Before
    public void setup() {
        ((DOMDataTreeWriteTransaction)Mockito.doReturn((Object)"tx").when((Object)this.transaction)).getIdentifier();
        InMemoryDOMDataStore store = new InMemoryDOMDataStore("OPER", (ExecutorService)MoreExecutors.newDirectExecutorService());
        this.coordinator = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)store), (Executor)this.futureExecutor);
    }

    @After
    public void tearDown() {
        this.futureExecutor.shutdownNow();
    }

    @Test
    public void testSuccessfulSubmitAsync() throws Exception {
        this.testSuccessfulSubmit(true);
    }

    @Test
    public void testSuccessfulSubmitSync() throws Exception {
        this.testSuccessfulSubmit(false);
    }

    private void testSuccessfulSubmit(boolean doAsync) throws InterruptedException {
        CountDownLatch asyncCanCommitContinue = new CountDownLatch(1);
        Answer asyncCanCommit = invocation -> {
            SettableFuture future = SettableFuture.create();
            if (doAsync) {
                new Thread(() -> {
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)asyncCanCommitContinue, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                    future.set((Object)Boolean.TRUE);
                }).start();
            } else {
                future.set((Object)Boolean.TRUE);
            }
            return future;
        };
        ((DOMStoreThreePhaseCommitCohort)Mockito.doAnswer((Answer)asyncCanCommit).when((Object)this.mockCohort)).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).preCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).commit();
        FluentFuture future = this.coordinator.commit(this.transaction, this.mockCohort);
        final CountDownLatch doneLatch = new CountDownLatch(1);
        final AtomicReference caughtEx = new AtomicReference();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                doneLatch.countDown();
            }

            public void onFailure(Throwable failure) {
                caughtEx.set(failure);
                doneLatch.countDown();
            }
        }, (Executor)MoreExecutors.directExecutor());
        asyncCanCommitContinue.countDown();
        Assert.assertTrue((String)"Submit complete", (boolean)doneLatch.await(5L, TimeUnit.SECONDS));
        if (caughtEx.get() != null) {
            Throwables.throwIfUnchecked((Throwable)((Throwable)caughtEx.get()));
            throw new RuntimeException((Throwable)caughtEx.get());
        }
        Assert.assertEquals((String)"Task count", (long)(doAsync ? 1L : 0L), (long)this.futureExecutor.getTaskCount());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCohort});
        ((DOMStoreThreePhaseCommitCohort)inOrder.verify((Object)this.mockCohort, Mockito.times((int)1))).canCommit();
        ((DOMStoreThreePhaseCommitCohort)inOrder.verify((Object)this.mockCohort, Mockito.times((int)1))).preCommit();
        ((DOMStoreThreePhaseCommitCohort)inOrder.verify((Object)this.mockCohort, Mockito.times((int)1))).commit();
    }

    @Test
    public void testSubmitWithNegativeCanCommitResponse() throws Exception {
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.immediateFuture((Object)Boolean.FALSE)).when((Object)this.mockCohort)).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).abort();
        ConcurrentDOMDataBrokerTest.assertFailure(this.coordinator.commit(this.transaction, this.mockCohort), null, this.mockCohort);
    }

    private static void assertFailure(ListenableFuture<?> future, Exception expCause, DOMStoreThreePhaseCommitCohort mockCohort) throws Exception {
        try {
            future.get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected TransactionCommitFailedException");
        }
        catch (ExecutionException e) {
            TransactionCommitFailedException tcf = (TransactionCommitFailedException)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply((Exception)e);
            if (expCause != null) {
                Assert.assertSame((String)"Expected cause", expCause.getClass(), tcf.getCause().getClass());
            }
            ((DOMStoreThreePhaseCommitCohort)Mockito.verify((Object)mockCohort, (VerificationMode)Mockito.times((int)1))).abort();
        }
        catch (TimeoutException e) {
            throw e;
        }
    }

    @Test
    public void testSubmitWithCanCommitException() throws Exception {
        IllegalStateException cause = new IllegalStateException("mock");
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)cause)).when((Object)this.mockCohort)).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).abort();
        ConcurrentDOMDataBrokerTest.assertFailure(this.coordinator.commit(this.transaction, this.mockCohort), cause, this.mockCohort);
    }

    @Test
    public void testSubmitWithPreCommitException() throws Exception {
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateTrueFluentFuture()).when((Object)this.mockCohort)).canCommit();
        IllegalStateException cause = new IllegalStateException("mock");
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)cause)).when((Object)this.mockCohort)).preCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).abort();
        ConcurrentDOMDataBrokerTest.assertFailure(this.coordinator.commit(this.transaction, this.mockCohort), cause, this.mockCohort);
    }

    @Test
    public void testSubmitWithCommitException() throws Exception {
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateTrueFluentFuture()).when((Object)this.mockCohort)).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).preCommit();
        IllegalStateException cause = new IllegalStateException("mock");
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)cause)).when((Object)this.mockCohort)).commit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).abort();
        ConcurrentDOMDataBrokerTest.assertFailure(this.coordinator.commit(this.transaction, this.mockCohort), cause, this.mockCohort);
    }

    @Test
    public void testSubmitWithAbortException() throws Exception {
        IllegalStateException canCommitCause = new IllegalStateException("canCommit error");
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)canCommitCause)).when((Object)this.mockCohort)).canCommit();
        IllegalStateException abortCause = new IllegalStateException("abort error");
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)abortCause)).when((Object)this.mockCohort)).abort();
        ConcurrentDOMDataBrokerTest.assertFailure(this.coordinator.commit(this.transaction, this.mockCohort), canCommitCause, this.mockCohort);
    }

    @Test
    public void testCreateReadWriteTransaction() {
        DOMStore domStore = (DOMStore)Mockito.mock(DOMStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)domStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)domStore), (Executor)this.futureExecutor);){
            dataBroker.newReadWriteTransaction();
            ((DOMStore)Mockito.verify((Object)domStore, (VerificationMode)Mockito.never())).newReadWriteTransaction();
        }
    }

    @Test
    public void testCreateWriteOnlyTransaction() {
        DOMStore domStore = (DOMStore)Mockito.mock(DOMStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)domStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)domStore), (Executor)this.futureExecutor);){
            dataBroker.newWriteOnlyTransaction();
            ((DOMStore)Mockito.verify((Object)domStore, (VerificationMode)Mockito.never())).newWriteOnlyTransaction();
        }
    }

    @Test
    public void testCreateReadOnlyTransaction() {
        DOMStore domStore = (DOMStore)Mockito.mock(DOMStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)domStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)domStore), (Executor)this.futureExecutor);){
            dataBroker.newReadOnlyTransaction();
            ((DOMStore)Mockito.verify((Object)domStore, (VerificationMode)Mockito.never())).newReadOnlyTransaction();
        }
    }

    @Test
    public void testLazySubTransactionCreationForReadWriteTransactions() {
        DOMStore configDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStore operationalDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStoreReadWriteTransaction storeTxn = (DOMStoreReadWriteTransaction)Mockito.mock(DOMStoreReadWriteTransaction.class);
        ((DOMStore)Mockito.doReturn((Object)storeTxn).when((Object)operationalDomStore)).newReadWriteTransaction();
        ((DOMStore)Mockito.doReturn((Object)storeTxn).when((Object)configDomStore)).newReadWriteTransaction();
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)operationalDomStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)configDomStore), (Executor)this.futureExecutor);){
            DOMDataTreeReadWriteTransaction dataTxn = dataBroker.newReadWriteTransaction();
            dataTxn.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of(), (NormalizedNode)Mockito.mock(NormalizedNode.class));
            dataTxn.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of(), (NormalizedNode)Mockito.mock(NormalizedNode.class));
            dataTxn.read(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of());
            ((DOMStore)Mockito.verify((Object)configDomStore, (VerificationMode)Mockito.never())).newReadWriteTransaction();
            ((DOMStore)Mockito.verify((Object)operationalDomStore, (VerificationMode)Mockito.times((int)1))).newReadWriteTransaction();
        }
    }

    @Test
    public void testLazySubTransactionCreationForWriteOnlyTransactions() {
        DOMStore configDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStore operationalDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStoreWriteTransaction storeTxn = (DOMStoreWriteTransaction)Mockito.mock(DOMStoreWriteTransaction.class);
        ((DOMStore)Mockito.doReturn((Object)storeTxn).when((Object)operationalDomStore)).newWriteOnlyTransaction();
        ((DOMStore)Mockito.doReturn((Object)storeTxn).when((Object)configDomStore)).newWriteOnlyTransaction();
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)operationalDomStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)configDomStore), (Executor)this.futureExecutor);){
            DOMDataTreeWriteTransaction dataTxn = dataBroker.newWriteOnlyTransaction();
            dataTxn.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of(), (NormalizedNode)Mockito.mock(NormalizedNode.class));
            dataTxn.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of(), (NormalizedNode)Mockito.mock(NormalizedNode.class));
            ((DOMStore)Mockito.verify((Object)configDomStore, (VerificationMode)Mockito.never())).newWriteOnlyTransaction();
            ((DOMStore)Mockito.verify((Object)operationalDomStore, (VerificationMode)Mockito.times((int)1))).newWriteOnlyTransaction();
        }
    }

    @Test
    public void testLazySubTransactionCreationForReadOnlyTransactions() {
        DOMStore configDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStore operationalDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStoreReadTransaction storeTxn = (DOMStoreReadTransaction)Mockito.mock(DOMStoreReadTransaction.class);
        ((DOMStore)Mockito.doReturn((Object)storeTxn).when((Object)operationalDomStore)).newReadOnlyTransaction();
        ((DOMStore)Mockito.doReturn((Object)storeTxn).when((Object)configDomStore)).newReadOnlyTransaction();
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)operationalDomStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)configDomStore), (Executor)this.futureExecutor);){
            DOMDataTreeReadTransaction dataTxn = dataBroker.newReadOnlyTransaction();
            dataTxn.read(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of());
            dataTxn.read(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of());
            ((DOMStore)Mockito.verify((Object)configDomStore, (VerificationMode)Mockito.never())).newReadOnlyTransaction();
            ((DOMStore)Mockito.verify((Object)operationalDomStore, (VerificationMode)Mockito.times((int)1))).newReadOnlyTransaction();
        }
    }

    @Test
    public void testSubmitWithOnlyOneSubTransaction() throws InterruptedException {
        DOMStore configDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStore operationalDomStore = (DOMStore)Mockito.mock(DOMStore.class);
        DOMStoreReadWriteTransaction mockStoreReadWriteTransaction = (DOMStoreReadWriteTransaction)Mockito.mock(DOMStoreReadWriteTransaction.class);
        ((DOMStore)Mockito.doReturn((Object)mockStoreReadWriteTransaction).when((Object)operationalDomStore)).newReadWriteTransaction();
        ((DOMStoreReadWriteTransaction)Mockito.doReturn((Object)this.mockCohort).when((Object)mockStoreReadWriteTransaction)).ready();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateFalseFluentFuture()).when((Object)this.mockCohort)).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateNullFluentFuture()).when((Object)this.mockCohort)).abort();
        final CountDownLatch latch = new CountDownLatch(1);
        final ArrayList commitCohorts = new ArrayList();
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)operationalDomStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)configDomStore), this.futureExecutor){

            public FluentFuture<? extends CommitInfo> commit(DOMDataTreeWriteTransaction writeTx, DOMStoreThreePhaseCommitCohort cohort) {
                commitCohorts.add(cohort);
                latch.countDown();
                return super.commit(writeTx, cohort);
            }
        };){
            DOMDataTreeReadWriteTransaction domDataReadWriteTransaction = dataBroker.newReadWriteTransaction();
            domDataReadWriteTransaction.delete(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of());
            domDataReadWriteTransaction.commit();
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((commitCohorts.size() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateTransactionChain() {
        DOMStore domStore = (DOMStore)Mockito.mock(DOMStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)domStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)domStore), (Executor)this.futureExecutor);){
            dataBroker.createTransactionChain((DOMTransactionChainListener)Mockito.mock(DOMTransactionChainListener.class));
            ((DOMStore)Mockito.verify((Object)domStore, (VerificationMode)Mockito.times((int)2))).createTransactionChain();
        }
    }

    @Test
    public void testCreateTransactionOnChain() {
        DOMStore domStore = (DOMStore)Mockito.mock(DOMStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)domStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)domStore), (Executor)this.futureExecutor);){
            DOMStoreReadWriteTransaction operationalTransaction = (DOMStoreReadWriteTransaction)Mockito.mock(DOMStoreReadWriteTransaction.class);
            DOMStoreTransactionChain mockChain = (DOMStoreTransactionChain)Mockito.mock(DOMStoreTransactionChain.class);
            ((DOMStore)Mockito.doReturn((Object)mockChain).when((Object)domStore)).createTransactionChain();
            ((DOMStoreTransactionChain)Mockito.doReturn((Object)operationalTransaction).when((Object)mockChain)).newWriteOnlyTransaction();
            DOMTransactionChain transactionChain = dataBroker.createTransactionChain((DOMTransactionChainListener)Mockito.mock(DOMTransactionChainListener.class));
            DOMDataTreeWriteTransaction domDataWriteTransaction = transactionChain.newWriteOnlyTransaction();
            ((DOMStoreTransactionChain)Mockito.verify((Object)mockChain, (VerificationMode)Mockito.never())).newWriteOnlyTransaction();
            domDataWriteTransaction.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of(), (NormalizedNode)Mockito.mock(NormalizedNode.class));
        }
    }

    @Test
    public void testEmptyTransactionSubmitSucceeds() throws ExecutionException, InterruptedException {
        DOMStore domStore = (DOMStore)Mockito.mock(DOMStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)domStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)domStore), (Executor)this.futureExecutor);){
            FluentFuture submit1 = dataBroker.newWriteOnlyTransaction().commit();
            Assert.assertNotNull((Object)submit1);
            submit1.get();
            FluentFuture submit2 = dataBroker.newReadWriteTransaction().commit();
            Assert.assertNotNull((Object)submit2);
            submit2.get();
        }
    }

    @Test
    public void testExtensions() {
        AbstractDataStore mockConfigStore = (AbstractDataStore)Mockito.mock(AbstractDataStore.class);
        AbstractDataStore mockOperStore = (AbstractDataStore)Mockito.mock(AbstractDataStore.class);
        try (ConcurrentDOMDataBroker dataBroker = new ConcurrentDOMDataBroker((Map)ImmutableMap.of((Object)LogicalDatastoreType.OPERATIONAL, (Object)mockOperStore, (Object)LogicalDatastoreType.CONFIGURATION, (Object)mockConfigStore), (Executor)this.futureExecutor);){
            ClassToInstanceMap supportedExtensions = dataBroker.getExtensions();
            Assert.assertNotNull((Object)supportedExtensions.getInstance(DOMDataTreeChangeService.class));
            DOMDataTreeCommitCohortRegistry cohortRegistry = (DOMDataTreeCommitCohortRegistry)supportedExtensions.getInstance(DOMDataTreeCommitCohortRegistry.class);
            Assert.assertNotNull((Object)cohortRegistry);
            DOMDataTreeCommitCohort cohort = (DOMDataTreeCommitCohort)Mockito.mock(DOMDataTreeCommitCohort.class);
            DOMDataTreeIdentifier path = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of());
            cohortRegistry.registerCommitCohort(path, cohort);
            ((AbstractDataStore)Mockito.verify((Object)mockConfigStore)).registerCommitCohort(path, cohort);
        }
    }
}

