/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequest;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccess;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Envelope;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.SingleClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import scala.concurrent.impl.Promise;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public abstract class AbstractClientHandleTest<T extends AbstractClientHandle<AbstractProxyTransaction>> {
    private static final String PERSISTENCE_ID = "per-1";
    private static final YangInstanceIdentifier PATH = YangInstanceIdentifier.of();
    @Mock
    private DataTree dataTree;
    @Mock
    private DataTreeSnapshot dataTreeSnapshot;
    private ActorSystem system;
    private TestProbe backendProbe;
    private AbstractClientHistory parent;
    private AbstractDataStoreClientBehavior client;
    private T handle;

    @Before
    public void setUp() throws Exception {
        this.system = ActorSystem.apply();
        TestProbe contextProbe = new TestProbe(this.system, "context");
        TestProbe clientContextProbe = new TestProbe(this.system, "client-context");
        this.backendProbe = new TestProbe(this.system, "backend");
        ActorUtils actorUtils = AbstractClientHandleTest.createActorContextMock(this.system, contextProbe.ref());
        ClientActorContext clientContext = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)TestUtils.CLIENT_ID, (String)PERSISTENCE_ID);
        this.client = new SimpleDataStoreClientBehavior(clientContext, actorUtils, "shard");
        this.client.createLocalHistory();
        this.parent = new SingleClientHistory(this.client, TestUtils.HISTORY_ID);
        this.client.getConnection(Long.valueOf(0L));
        contextProbe.expectMsgClass(ConnectClientRequest.class);
        long sequence = 0L;
        contextProbe.reply((Object)new ConnectClientSuccess(TestUtils.CLIENT_ID, 0L, this.backendProbe.ref(), List.of(), (ReadOnlyDataTree)this.dataTree, 3));
        InternalCommand command = (InternalCommand)clientContextProbe.expectMsgClass(InternalCommand.class);
        command.execute((ClientActorBehavior)this.client);
        ((DataTree)Mockito.doReturn((Object)this.dataTreeSnapshot).when((Object)this.dataTree)).takeSnapshot();
        this.handle = this.createHandle(this.parent);
    }

    protected abstract T createHandle(AbstractClientHistory var1);

    protected abstract void doHandleOperation(T var1);

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public void testGetIdentifier() {
        Assert.assertEquals((Object)TestUtils.TRANSACTION_ID, (Object)this.handle.getIdentifier());
    }

    @Test
    public void testAbort() throws Exception {
        this.doHandleOperation(this.handle);
        this.handle.abort();
        Envelope envelope = (Envelope)this.backendProbe.expectMsgClass(Envelope.class);
        AbortLocalTransactionRequest request = (AbortLocalTransactionRequest)envelope.getMessage();
        Assert.assertEquals((Object)TestUtils.TRANSACTION_ID, (Object)request.getTarget());
        this.checkClosed();
    }

    @Test
    public void testLocalAbort() throws Exception {
        this.doHandleOperation(this.handle);
        this.handle.localAbort((Throwable)new RuntimeException("fail"));
        Envelope envelope = (Envelope)this.backendProbe.expectMsgClass(Envelope.class);
        AbortLocalTransactionRequest request = (AbortLocalTransactionRequest)envelope.getMessage();
        Assert.assertEquals((Object)TestUtils.TRANSACTION_ID, (Object)request.getTarget());
        this.checkClosed();
    }

    @Test
    public void testEnsureClosed() {
        this.doHandleOperation(this.handle);
        Map transactions = this.handle.ensureClosed();
        Assert.assertNotNull((Object)transactions);
        Assert.assertEquals((long)1L, (long)transactions.size());
    }

    @Test
    public void testEnsureProxy() {
        AbstractProxyTransaction expected = (AbstractProxyTransaction)Mockito.mock(AbstractProxyTransaction.class);
        AbstractProxyTransaction proxy = this.handle.ensureProxy(PATH);
        Assert.assertEquals((long)0L, (long)((TransactionIdentifier)proxy.getIdentifier()).getTransactionId());
    }

    @Test
    public void testParent() {
        Assert.assertEquals((Object)this.parent, (Object)this.handle.parent());
    }

    protected void checkClosed() throws Exception {
        TestUtils.assertOperationThrowsException(() -> this.doHandleOperation(this.handle), IllegalStateException.class);
    }

    protected <R extends Request<?, R>> R backendRespondToRequest(Class<R> expectedRequestClass, Response<?, ?> response) {
        RequestEnvelope envelope = (RequestEnvelope)this.backendProbe.expectMsgClass(RequestEnvelope.class);
        Assert.assertEquals(expectedRequestClass, ((Request)envelope.getMessage()).getClass());
        AbstractClientConnection connection = this.client.getConnection(Long.valueOf(0L));
        long sessionId = envelope.getSessionId();
        long txSequence = envelope.getTxSequence();
        long executionTime = 0L;
        if (response instanceof RequestSuccess) {
            RequestSuccess success = (RequestSuccess)response;
            SuccessEnvelope responseEnvelope = new SuccessEnvelope(success, sessionId, txSequence, 0L);
            AccessClientUtil.completeRequest((AbstractClientConnection)connection, (ResponseEnvelope)responseEnvelope);
        } else if (response instanceof RequestFailure) {
            RequestFailure fail = (RequestFailure)response;
            FailureEnvelope responseEnvelope = new FailureEnvelope(fail, sessionId, txSequence, 0L);
            AccessClientUtil.completeRequest((AbstractClientConnection)connection, (ResponseEnvelope)responseEnvelope);
        }
        return (R)((Request)expectedRequestClass.cast(envelope.getMessage()));
    }

    protected T getHandle() {
        return this.handle;
    }

    protected DataTreeSnapshot getDataTreeSnapshot() {
        return this.dataTreeSnapshot;
    }

    private static ActorUtils createActorContextMock(ActorSystem system, ActorRef actor) {
        ActorUtils mock = (ActorUtils)Mockito.mock(ActorUtils.class);
        Promise.DefaultPromise promise = new Promise.DefaultPromise();
        ActorSelection selection = system.actorSelection(actor.path());
        PrimaryShardInfo shardInfo = new PrimaryShardInfo(selection, 0);
        promise.success((Object)shardInfo);
        ((ActorUtils)Mockito.doReturn((Object)promise.future()).when((Object)mock)).findPrimaryShardAsync((String)ArgumentMatchers.any());
        EffectiveModelContext context = (EffectiveModelContext)Mockito.mock(EffectiveModelContext.class);
        ((EffectiveModelContext)Mockito.lenient().doCallRealMethod().when((Object)context)).getQName();
        ((ActorUtils)Mockito.lenient().doReturn((Object)context).when((Object)mock)).getSchemaContext();
        ((ActorUtils)Mockito.lenient().doReturn((Object)DatastoreContext.newBuilder().build()).when((Object)mock)).getDatastoreContext();
        return mock;
    }
}

