/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.ListenableFuture;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.EmptyTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class EmptyTransactionCommitCohortTest {
    @Mock
    private AbstractClientHistory history;
    private EmptyTransactionCommitCohort cohort;

    @Before
    public void setUp() {
        this.cohort = new EmptyTransactionCommitCohort(this.history, TestUtils.TRANSACTION_ID);
    }

    @Test
    public void testCanCommit() throws Exception {
        ListenableFuture canCommit = this.cohort.canCommit();
        Assert.assertEquals((Object)Boolean.TRUE, TestUtils.getWithTimeout(canCommit));
    }

    @Test
    public void testPreCommit() throws Exception {
        Assert.assertNotNull(TestUtils.getWithTimeout(this.cohort.preCommit()));
    }

    @Test
    public void testAbort() throws Exception {
        ListenableFuture abort = this.cohort.abort();
        ((AbstractClientHistory)Mockito.verify((Object)this.history)).onTransactionComplete(TestUtils.TRANSACTION_ID);
        Assert.assertNotNull(TestUtils.getWithTimeout(abort));
    }

    @Test
    public void testCommit() throws Exception {
        ListenableFuture commit = this.cohort.commit();
        ((AbstractClientHistory)Mockito.verify((Object)this.history)).onTransactionComplete(TestUtils.TRANSACTION_ID);
        Assert.assertNotNull(TestUtils.getWithTimeout(commit));
    }
}

