/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.DeadLetter;
import akka.actor.Props;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChangedReply;
import org.opendaylight.controller.cluster.datastore.messages.EnableNotification;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

public class DataTreeChangeListenerActorTest
extends AbstractActorTest {
    private TestKit testKit;

    @Before
    public void before() {
        this.testKit = new TestKit(DataTreeChangeListenerActorTest.getSystem());
    }

    @Test
    public void testDataChangedWhenNotificationsAreEnabled() {
        DataTreeCandidate mockTreeCandidate = (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class);
        ImmutableList mockCandidates = ImmutableList.of((Object)mockTreeCandidate);
        DOMDataTreeChangeListener mockListener = (DOMDataTreeChangeListener)Mockito.mock(DOMDataTreeChangeListener.class);
        Props props = DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)mockListener, (YangInstanceIdentifier)TestModel.TEST_PATH);
        ActorRef subject = DataTreeChangeListenerActorTest.getSystem().actorOf(props, "testDataTreeChangedNotificationsEnabled");
        subject.tell((Object)new EnableNotification(true, "test"), this.testKit.getRef());
        subject.tell((Object)new DataTreeChanged((List)mockCandidates), this.testKit.getRef());
        this.testKit.expectMsgClass(DataTreeChangedReply.class);
        ((DOMDataTreeChangeListener)Mockito.verify((Object)mockListener)).onDataTreeChanged((List)mockCandidates);
    }

    @Test
    public void testDataChangedWhenNotificationsAreDisabled() {
        DataTreeCandidate mockTreeCandidate = (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class);
        ImmutableList mockCandidates = ImmutableList.of((Object)mockTreeCandidate);
        DOMDataTreeChangeListener mockListener = (DOMDataTreeChangeListener)Mockito.mock(DOMDataTreeChangeListener.class);
        Props props = DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)mockListener, (YangInstanceIdentifier)TestModel.TEST_PATH);
        ActorRef subject = DataTreeChangeListenerActorTest.getSystem().actorOf(props, "testDataTreeChangedNotificationsDisabled");
        subject.tell((Object)new DataTreeChanged((List)mockCandidates), this.testKit.getRef());
        this.testKit.within(Duration.ofSeconds(1L), () -> {
            this.testKit.expectNoMessage();
            ((DOMDataTreeChangeListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.never())).onDataTreeChanged(ArgumentMatchers.anyList());
            return null;
        });
    }

    @Test
    public void testDataChangedWithNoSender() {
        DataTreeCandidate mockTreeCandidate = (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class);
        ImmutableList mockCandidates = ImmutableList.of((Object)mockTreeCandidate);
        DOMDataTreeChangeListener mockListener = (DOMDataTreeChangeListener)Mockito.mock(DOMDataTreeChangeListener.class);
        Props props = DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)mockListener, (YangInstanceIdentifier)TestModel.TEST_PATH);
        ActorRef subject = DataTreeChangeListenerActorTest.getSystem().actorOf(props, "testDataTreeChangedWithNoSender");
        DataTreeChangeListenerActorTest.getSystem().eventStream().subscribe(this.testKit.getRef(), DeadLetter.class);
        subject.tell((Object)new DataTreeChanged((List)mockCandidates), ActorRef.noSender());
        while (true) {
            DeadLetter deadLetter;
            try {
                deadLetter = (DeadLetter)this.testKit.expectMsgClass(Duration.ofSeconds(1L), DeadLetter.class);
            }
            catch (AssertionError e) {
                break;
            }
            Assert.assertFalse((String)"Unexpected DataTreeChangedReply", (boolean)(deadLetter.message() instanceof DataTreeChangedReply));
        }
    }

    @Test
    public void testDataChangedWithListenerRuntimeEx() {
        DataTreeCandidate mockTreeCandidate1 = (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class);
        ImmutableList mockCandidates1 = ImmutableList.of((Object)mockTreeCandidate1);
        DataTreeCandidate mockTreeCandidate2 = (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class);
        ImmutableList mockCandidates2 = ImmutableList.of((Object)mockTreeCandidate2);
        DataTreeCandidate mockTreeCandidate3 = (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class);
        ImmutableList mockCandidates3 = ImmutableList.of((Object)mockTreeCandidate3);
        DOMDataTreeChangeListener mockListener = (DOMDataTreeChangeListener)Mockito.mock(DOMDataTreeChangeListener.class);
        ((DOMDataTreeChangeListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("mock")}).when((Object)mockListener)).onDataTreeChanged((List)mockCandidates2);
        Props props = DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)mockListener, (YangInstanceIdentifier)TestModel.TEST_PATH);
        ActorRef subject = DataTreeChangeListenerActorTest.getSystem().actorOf(props, "testDataTreeChangedWithListenerRuntimeEx");
        subject.tell((Object)new EnableNotification(true, "test"), this.testKit.getRef());
        subject.tell((Object)new DataTreeChanged((List)mockCandidates1), this.testKit.getRef());
        this.testKit.expectMsgClass(DataTreeChangedReply.class);
        subject.tell((Object)new DataTreeChanged((List)mockCandidates2), this.testKit.getRef());
        this.testKit.expectMsgClass(DataTreeChangedReply.class);
        subject.tell((Object)new DataTreeChanged((List)mockCandidates3), this.testKit.getRef());
        this.testKit.expectMsgClass(DataTreeChangedReply.class);
        ((DOMDataTreeChangeListener)Mockito.verify((Object)mockListener)).onDataTreeChanged((List)mockCandidates1);
        ((DOMDataTreeChangeListener)Mockito.verify((Object)mockListener)).onDataTreeChanged((List)mockCandidates2);
        ((DOMDataTreeChangeListener)Mockito.verify((Object)mockListener)).onDataTreeChanged((List)mockCandidates3);
    }
}

