/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.dispatch.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.LocalThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.LocalTransactionContext;
import org.opendaylight.controller.cluster.datastore.LocalTransactionReadySupport;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import scala.concurrent.Future;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class LocalTransactionContextTest {
    @Mock
    private DOMStoreReadWriteTransaction readWriteTransaction;
    @Mock
    private LocalTransactionReadySupport mockReadySupport;
    private LocalTransactionContext localTransactionContext;

    @Before
    public void setUp() {
        TransactionIdentifier txId = new TransactionIdentifier(new LocalHistoryIdentifier(ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)MemberName.forName((String)"member"), (FrontendType)FrontendType.forName((String)"type")), (long)0L), 0L), 0L);
        this.localTransactionContext = new LocalTransactionContext((DOMStoreTransaction)this.readWriteTransaction, txId, this.mockReadySupport){

            DOMStoreWriteTransaction getWriteDelegate() {
                return LocalTransactionContextTest.this.readWriteTransaction;
            }

            DOMStoreReadTransaction getReadDelegate() {
                return LocalTransactionContextTest.this.readWriteTransaction;
            }
        };
    }

    @Test
    public void testWrite() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        NormalizedNode normalizedNode = (NormalizedNode)Mockito.mock(NormalizedNode.class);
        this.localTransactionContext.executeWrite(yangInstanceIdentifier, normalizedNode, null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).write(yangInstanceIdentifier, normalizedNode);
    }

    @Test
    public void testMerge() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        NormalizedNode normalizedNode = (NormalizedNode)Mockito.mock(NormalizedNode.class);
        this.localTransactionContext.executeMerge(yangInstanceIdentifier, normalizedNode, null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).merge(yangInstanceIdentifier, normalizedNode);
    }

    @Test
    public void testDelete() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        this.localTransactionContext.executeDelete(yangInstanceIdentifier, null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).delete(yangInstanceIdentifier);
    }

    @Test
    public void testRead() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        NormalizedNode normalizedNode = (NormalizedNode)Mockito.mock(NormalizedNode.class);
        ((DOMStoreReadWriteTransaction)Mockito.doReturn((Object)FluentFutures.immediateFluentFuture(Optional.of(normalizedNode))).when((Object)this.readWriteTransaction)).read(yangInstanceIdentifier);
        this.localTransactionContext.executeRead((AbstractRead)new ReadData(yangInstanceIdentifier, 13), SettableFuture.create(), null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).read(yangInstanceIdentifier);
    }

    @Test
    public void testExists() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        ((DOMStoreReadWriteTransaction)Mockito.doReturn((Object)FluentFutures.immediateTrueFluentFuture()).when((Object)this.readWriteTransaction)).exists(yangInstanceIdentifier);
        this.localTransactionContext.executeRead((AbstractRead)new DataExists(yangInstanceIdentifier, 13), SettableFuture.create(), null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).exists(yangInstanceIdentifier);
    }

    @Test
    public void testReady() {
        LocalThreePhaseCommitCohort mockCohort = (LocalThreePhaseCommitCohort)Mockito.mock(LocalThreePhaseCommitCohort.class);
        ((LocalThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.successful(null)).when((Object)mockCohort)).initiateCoordinatedCommit(Optional.empty());
        ((LocalTransactionReadySupport)Mockito.doReturn((Object)mockCohort).when((Object)this.mockReadySupport)).onTransactionReady((DOMStoreWriteTransaction)this.readWriteTransaction, null);
        Future future = this.localTransactionContext.readyTransaction(null, Optional.empty());
        Assert.assertTrue((boolean)future.isCompleted());
        ((LocalTransactionReadySupport)Mockito.verify((Object)this.mockReadySupport)).onTransactionReady((DOMStoreWriteTransaction)this.readWriteTransaction, null);
    }

    @Test
    public void testReadyWithWriteError() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        NormalizedNode normalizedNode = (NormalizedNode)Mockito.mock(NormalizedNode.class);
        RuntimeException error = new RuntimeException("mock");
        ((DOMStoreReadWriteTransaction)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)this.readWriteTransaction)).write(yangInstanceIdentifier, normalizedNode);
        this.localTransactionContext.executeWrite(yangInstanceIdentifier, normalizedNode, null);
        this.localTransactionContext.executeWrite(yangInstanceIdentifier, normalizedNode, null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).write(yangInstanceIdentifier, normalizedNode);
        this.doReadyWithExpectedError(error);
    }

    @Test
    public void testReadyWithMergeError() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        NormalizedNode normalizedNode = (NormalizedNode)Mockito.mock(NormalizedNode.class);
        RuntimeException error = new RuntimeException("mock");
        ((DOMStoreReadWriteTransaction)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)this.readWriteTransaction)).merge(yangInstanceIdentifier, normalizedNode);
        this.localTransactionContext.executeMerge(yangInstanceIdentifier, normalizedNode, null);
        this.localTransactionContext.executeMerge(yangInstanceIdentifier, normalizedNode, null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).merge(yangInstanceIdentifier, normalizedNode);
        this.doReadyWithExpectedError(error);
    }

    @Test
    public void testReadyWithDeleteError() {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.of();
        RuntimeException error = new RuntimeException("mock");
        ((DOMStoreReadWriteTransaction)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)this.readWriteTransaction)).delete(yangInstanceIdentifier);
        this.localTransactionContext.executeDelete(yangInstanceIdentifier, null);
        this.localTransactionContext.executeDelete(yangInstanceIdentifier, null);
        ((DOMStoreReadWriteTransaction)Mockito.verify((Object)this.readWriteTransaction)).delete(yangInstanceIdentifier);
        this.doReadyWithExpectedError(error);
    }

    private void doReadyWithExpectedError(RuntimeException expError) {
        LocalThreePhaseCommitCohort mockCohort = (LocalThreePhaseCommitCohort)Mockito.mock(LocalThreePhaseCommitCohort.class);
        ((LocalThreePhaseCommitCohort)Mockito.doReturn((Object)Futures.successful(null)).when((Object)mockCohort)).initiateCoordinatedCommit(Optional.empty());
        ((LocalTransactionReadySupport)Mockito.doReturn((Object)mockCohort).when((Object)this.mockReadySupport)).onTransactionReady((DOMStoreWriteTransaction)this.readWriteTransaction, (Exception)expError);
        this.localTransactionContext.readyTransaction(null, Optional.empty());
    }
}

