/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Status;
import akka.dispatch.ExecutionContexts;
import akka.dispatch.OnComplete;
import akka.testkit.javadsl.TestKit;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.OperationLimiter;
import org.opendaylight.controller.cluster.datastore.RemoteTransactionContext;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import scala.concurrent.Await;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class RemoteTransactionContextTest
extends AbstractActorTest {
    private static final TransactionIdentifier TX_ID = new TransactionIdentifier(new LocalHistoryIdentifier(ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)MemberName.forName((String)"test"), (FrontendType)FrontendType.forName((String)"test")), (long)0L), 0L), 0L);
    private OperationLimiter limiter;
    private RemoteTransactionContext txContext;
    private ActorUtils actorUtils;
    private TestKit kit;

    @Before
    public void before() {
        this.kit = new TestKit(RemoteTransactionContextTest.getSystem());
        this.actorUtils = (ActorUtils)Mockito.spy((Object)new ActorUtils(RemoteTransactionContextTest.getSystem(), this.kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class)));
        this.limiter = new OperationLimiter(TX_ID, 4, 0L);
        this.txContext = new RemoteTransactionContext(TX_ID, this.actorUtils.actorSelection(this.kit.getRef().path()), this.actorUtils, 13, this.limiter);
        this.txContext.operationHandOffComplete();
    }

    @Test
    public void testLimiterOnFailure() throws TimeoutException, InterruptedException {
        this.txContext.executeDelete(null, null);
        this.txContext.executeDelete(null, null);
        Assert.assertEquals((long)2L, (long)this.limiter.availablePermits());
        Future sendFuture = this.txContext.sendBatchedModifications();
        Assert.assertEquals((long)2L, (long)this.limiter.availablePermits());
        BatchedModifications msg = (BatchedModifications)this.kit.expectMsgClass(BatchedModifications.class);
        Assert.assertEquals((long)2L, (long)msg.getModifications().size());
        Assert.assertEquals((long)1L, (long)msg.getTotalMessagesSent());
        this.sendReply(new Status.Failure((Throwable)new NullPointerException()));
        RemoteTransactionContextTest.assertFuture((Future<Object>)sendFuture, new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) {
                Assert.assertTrue((boolean)(failure instanceof NullPointerException));
                Assert.assertEquals((long)4L, (long)RemoteTransactionContextTest.this.limiter.availablePermits());
                RemoteTransactionContextTest.this.txContext.executeDelete(null, null);
                Assert.assertEquals((long)4L, (long)RemoteTransactionContextTest.this.limiter.availablePermits());
                SettableFuture readFuture = SettableFuture.create();
                RemoteTransactionContextTest.this.txContext.executeRead((AbstractRead)new DataExists(), readFuture, null);
                Assert.assertTrue((boolean)readFuture.isDone());
                try {
                    readFuture.get();
                    Assert.fail((String)"Read future did not fail");
                }
                catch (InterruptedException | ExecutionException e) {
                    Assert.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
                }
            }
        });
        Future commitFuture = this.txContext.directCommit(null);
        msg = (BatchedModifications)this.kit.expectMsgClass(BatchedModifications.class);
        Assert.assertEquals((long)0L, (long)msg.getModifications().size());
        Assert.assertTrue((boolean)msg.isDoCommitOnReady());
        Assert.assertTrue((boolean)msg.isReady());
        Assert.assertEquals((long)2L, (long)msg.getTotalMessagesSent());
        this.sendReply(new Status.Failure((Throwable)new IllegalStateException()));
        RemoteTransactionContextTest.assertFuture((Future<Object>)commitFuture, new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) {
                Assert.assertTrue((boolean)(failure instanceof IllegalStateException));
            }
        });
        this.kit.expectNoMessage();
    }

    @Test
    public void testLimiterOnOverflowFailure() throws TimeoutException, InterruptedException {
        this.txContext.executeDelete(null, null);
        this.txContext.executeDelete(null, null);
        this.txContext.executeDelete(null, null);
        this.txContext.executeDelete(null, null);
        Assert.assertEquals((long)0L, (long)this.limiter.availablePermits());
        this.txContext.executeDelete(null, null);
        Assert.assertEquals((long)0L, (long)this.limiter.availablePermits());
        Future future = this.txContext.sendBatchedModifications();
        Assert.assertEquals((long)0L, (long)this.limiter.availablePermits());
        BatchedModifications msg = (BatchedModifications)this.kit.expectMsgClass(BatchedModifications.class);
        Assert.assertEquals((long)5L, (long)msg.getModifications().size());
        Assert.assertEquals((long)1L, (long)msg.getTotalMessagesSent());
        this.sendReply(new Status.Failure((Throwable)new NullPointerException()));
        RemoteTransactionContextTest.assertFuture((Future<Object>)future, new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) {
                Assert.assertTrue((boolean)(failure instanceof NullPointerException));
                Assert.assertEquals((long)4L, (long)RemoteTransactionContextTest.this.limiter.availablePermits());
            }
        });
        this.kit.expectNoMessage();
    }

    private void sendReply(Object message) {
        ActorRef askActor = this.kit.getLastSender();
        this.kit.watch(askActor);
        this.kit.reply((Object)new Status.Failure((Throwable)new IllegalStateException()));
        this.kit.expectTerminated(askActor);
    }

    private static void assertFuture(Future<Object> future, OnComplete<Object> complete) throws TimeoutException, InterruptedException {
        Await.ready(future, (Duration)FiniteDuration.apply((long)3L, (TimeUnit)TimeUnit.SECONDS));
        future.onComplete(complete, (ExecutionContext)ExecutionContexts.fromExecutor((Executor)MoreExecutors.directExecutor()));
    }
}

