/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.io.IOException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardRecoveryCoordinator;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardRecoveryCoordinatorTest
extends AbstractTest {
    private static final Logger FOO_LOGGER = LoggerFactory.getLogger((String)"foo");
    private ShardDataTree peopleDataTree;
    private EffectiveModelContext peopleSchemaContext;
    private EffectiveModelContext carsSchemaContext;
    private ShardRecoveryCoordinator coordinator;

    @Before
    public void setUp() {
        this.peopleSchemaContext = SchemaContextHelper.select("/people.yang");
        this.carsSchemaContext = SchemaContextHelper.select("/cars.yang");
        Shard mockShard = (Shard)Mockito.mock(Shard.class);
        this.peopleDataTree = new ShardDataTree(mockShard, this.peopleSchemaContext, TreeType.OPERATIONAL);
        this.coordinator = ShardRecoveryCoordinator.create((ShardDataTree)this.peopleDataTree, (String)"foobar", (Logger)FOO_LOGGER);
        this.coordinator.startLogRecoveryBatch(10);
    }

    @Test
    public void testAppendRecoveredLogEntryCommitTransactionPayload() throws IOException, DataValidationFailedException {
        try {
            this.coordinator.appendRecoveredLogEntry((Payload)CommitTransactionPayload.create((TransactionIdentifier)ShardRecoveryCoordinatorTest.nextTransactionId(), (DataTreeCandidate)this.createCar()));
        }
        catch (SchemaValidationFailedException e) {
            Assert.fail((String)"SchemaValidationFailedException should not happen if pruning is done");
        }
        this.coordinator.applyCurrentLogRecoveryBatch();
    }

    @Test
    public void testApplyRecoverySnapshot() throws DataValidationFailedException {
        this.coordinator.applyRecoverySnapshot((Snapshot.State)ShardRecoveryCoordinatorTest.createSnapshot());
        Assert.assertFalse((boolean)this.readCars(this.peopleDataTree).isPresent());
        Assert.assertTrue((boolean)this.readPeople(this.peopleDataTree).isPresent());
    }

    @Test
    public void testApplyCurrentLogRecoveryBatch() {
        try {
            this.coordinator.applyCurrentLogRecoveryBatch();
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"IllegalArgumentException should not happen - if the pruning modification delegate is passed");
        }
    }

    private DataTreeCandidate createCar() throws DataValidationFailedException {
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, this.carsSchemaContext);
        DataTreeSnapshot snapshot = dataTree.takeSnapshot();
        DataTreeModification modification = snapshot.newModification();
        modification.merge(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.create());
        modification.ready();
        return dataTree.prepare(modification);
    }

    private Optional<NormalizedNode> readCars(ShardDataTree shardDataTree) {
        DataTree dataTree = shardDataTree.getDataTree();
        dataTree.setEffectiveModelContext(this.peopleSchemaContext);
        return shardDataTree.readNode(CarsModel.BASE_PATH);
    }

    private Optional<NormalizedNode> readPeople(ShardDataTree shardDataTree) {
        DataTree dataTree = shardDataTree.getDataTree();
        dataTree.setEffectiveModelContext(this.peopleSchemaContext);
        return shardDataTree.readNode(PeopleModel.BASE_PATH);
    }

    private static ShardSnapshotState createSnapshot() throws DataValidationFailedException {
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SchemaContextHelper.select("/cars.yang", "/people.yang"));
        DataTreeSnapshot snapshot = dataTree.takeSnapshot();
        DataTreeModification modification = snapshot.newModification();
        modification.merge(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.create());
        modification.merge(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.create());
        modification.ready();
        dataTree.commit((DataTreeCandidate)dataTree.prepare(modification));
        return new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot((NormalizedNode)dataTree.takeSnapshot().readNode(YangInstanceIdentifier.of()).orElseThrow()));
    }
}

