/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Props;
import akka.actor.Status;
import akka.dispatch.Dispatchers;
import akka.dispatch.OnComplete;
import akka.japi.Creator;
import akka.pattern.Patterns;
import akka.persistence.SaveSnapshotSuccess;
import akka.testkit.TestActorRef;
import akka.util.Timeout;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.DelegatingPersistentDataProvider;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.ShardTestKit;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransaction;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModificationsReply;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistrationReply;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.PeerAddressResolved;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.cluster.datastore.messages.ReadDataReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.messages.ReadyTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.messages.ShardLeaderStateChanged;
import org.opendaylight.controller.cluster.datastore.messages.UpdateSchemaContext;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.datastore.utils.MockDataTreeChangeListener;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListenerReply;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.base.messages.ApplySnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.ElectionTimeout;
import org.opendaylight.controller.cluster.raft.base.messages.FollowerInitialSyncUpStatus;
import org.opendaylight.controller.cluster.raft.base.messages.TimeoutNow;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeader;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeaderReply;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.ServerRemoved;
import org.opendaylight.controller.cluster.raft.persisted.ApplyJournalEntries;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.cluster.raft.policy.DisableElectionsRaftPolicy;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.cluster.raft.utils.MessageCollectorActor;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ShardTest
extends AbstractShardTest {
    private static final String DUMMY_DATA = "Dummy data as snapshot sequence number is set to 0 in InMemorySnapshotStore and journal recovery seq number will start from 1";

    @Test
    public void testRegisterDataTreeChangeListener() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testRegisterDataTreeChangeListener");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        shard.tell((Object)new UpdateSchemaContext(SchemaContextHelper.full()), ActorRef.noSender());
        MockDataTreeChangeListener listener = new MockDataTreeChangeListener(1);
        ActorRef dclActor = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener, (YangInstanceIdentifier)TestModel.TEST_PATH), "testRegisterDataTreeChangeListener-DataTreeChangeListener");
        shard.tell((Object)new RegisterDataTreeChangeListener(TestModel.TEST_PATH, dclActor, false), testKit.getRef());
        RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(3L), RegisterDataTreeNotificationListenerReply.class);
        String replyPath = reply.getListenerRegistrationPath().toString();
        Assert.assertTrue((String)("Incorrect reply path: " + replyPath), (boolean)replyPath.matches("akka:\\/\\/test\\/user\\/testRegisterDataTreeChangeListener\\/\\$.*"));
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        this.writeToStore((TestActorRef<Shard>)shard, path, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyOnInitialDataEvent();
        MockDataTreeChangeListener listener2 = new MockDataTreeChangeListener(1);
        ActorRef dclActor2 = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener2, (YangInstanceIdentifier)TestModel.TEST_PATH), "testRegisterDataTreeChangeListener-DataTreeChangeListener2");
        shard.tell((Object)new RegisterDataTreeChangeListener(TestModel.TEST_PATH, dclActor2, false), testKit.getRef());
        testKit.expectMsgClass(java.time.Duration.ofSeconds(3L), RegisterDataTreeNotificationListenerReply.class);
        listener2.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener2.verifyNoOnInitialDataEvent();
    }

    @Test
    public void testDataTreeChangeListenerNotifiedWhenNotTheLeaderOnRegistration() throws Exception {
        final CountDownLatch onFirstElectionTimeout = new CountDownLatch(1);
        final CountDownLatch onChangeListenerRegistered = new CountDownLatch(1);
        Creator<Shard> creator = new Creator<Shard>(){
            boolean firstElectionTimeout = true;

            public Shard create() {
                return new Shard((Shard.AbstractBuilder)ShardTest.this.newShardBuilder()){

                    public void handleCommand(Object message) {
                        if (message instanceof ElectionTimeout && firstElectionTimeout) {
                            firstElectionTimeout = false;
                            ActorRef self = this.getSelf();
                            new Thread(() -> {
                                Uninterruptibles.awaitUninterruptibly((CountDownLatch)onChangeListenerRegistered, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                                self.tell(message, self);
                            }).start();
                            onFirstElectionTimeout.countDown();
                        } else {
                            super.handleCommand(message);
                        }
                    }
                };
            }
        };
        this.setupInMemorySnapshotStore();
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        MockDataTreeChangeListener listener = new MockDataTreeChangeListener(1);
        ActorRef dclActor = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener, (YangInstanceIdentifier)path), "testDataTreeChangeListenerNotifiedWhenNotTheLeaderOnRegistration-DataChangeListener");
        TestActorRef shard = this.actorFactory.createTestActor(Props.create(Shard.class, (Creator)new AbstractShardTest.DelegatingShardCreator(creator)).withDispatcher(Dispatchers.DefaultDispatcherId()), "testDataTreeChangeListenerNotifiedWhenNotTheLeaderOnRegistration");
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        Assert.assertTrue((String)"Got first ElectionTimeout", (boolean)onFirstElectionTimeout.await(5L, TimeUnit.SECONDS));
        shard.tell((Object)new RegisterDataTreeChangeListener(path, dclActor, false), testKit.getRef());
        RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), RegisterDataTreeNotificationListenerReply.class);
        Assert.assertNotNull((String)"getListenerRegistratioznPath", (Object)reply.getListenerRegistrationPath());
        shard.tell((Object)FindLeader.INSTANCE, testKit.getRef());
        FindLeaderReply findLeadeReply = (FindLeaderReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), FindLeaderReply.class);
        Assert.assertFalse((String)"Expected the shard not to be the leader", (boolean)findLeadeReply.getLeaderActor().isPresent());
        onChangeListenerRegistered.countDown();
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
    }

    @Test
    public void testCreateTransaction() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        ActorRef shard = this.actorFactory.createActor(this.newShardProps(), "testCreateTransaction");
        ShardTestKit.waitUntilLeader(shard);
        shard.tell((Object)new UpdateSchemaContext(TestModel.createTestContext()), testKit.getRef());
        shard.tell(new CreateTransaction(ShardTest.nextTransactionId(), TransactionType.READ_ONLY.ordinal(), 13).toSerializable(), testKit.getRef());
        CreateTransactionReply reply = (CreateTransactionReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(3L), CreateTransactionReply.class);
        String path = reply.getTransactionPath().toString();
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.containsString((String)String.format("/user/testCreateTransaction/shard-%s-%s:ShardTransactionTest@0:", this.shardID.getShardName(), this.shardID.getMemberName().getName())));
    }

    @Test
    public void testCreateTransactionOnChain() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        ActorRef shard = this.actorFactory.createActor(this.newShardProps(), "testCreateTransactionOnChain");
        ShardTestKit.waitUntilLeader(shard);
        shard.tell(new CreateTransaction(ShardTest.nextTransactionId(), TransactionType.READ_ONLY.ordinal(), 13).toSerializable(), testKit.getRef());
        CreateTransactionReply reply = (CreateTransactionReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(3L), CreateTransactionReply.class);
        String path = reply.getTransactionPath().toString();
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.containsString((String)String.format("/user/testCreateTransactionOnChain/shard-%s-%s:ShardTransactionTest@0:", this.shardID.getShardName(), this.shardID.getMemberName().getName())));
    }

    @Test
    public void testPeerAddressResolved() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        ShardIdentifier peerID = ShardIdentifier.create((String)"inventory", (MemberName)MemberName.forName((String)"member-2"), (String)"config");
        TestActorRef shard = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().peerAddresses(Collections.singletonMap(peerID.toString(), null))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testPeerAddressResolved");
        String address = "akka://foobar";
        shard.tell((Object)new PeerAddressResolved(peerID.toString(), "akka://foobar"), ActorRef.noSender());
        shard.tell((Object)GetOnDemandRaftState.INSTANCE, testKit.getRef());
        OnDemandRaftState state = (OnDemandRaftState)testKit.expectMsgClass(OnDemandRaftState.class);
        Assert.assertEquals((String)"getPeerAddress", (Object)"akka://foobar", state.getPeerAddresses().get(peerID.toString()));
    }

    @Test
    public void testApplySnapshot() throws Exception {
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testApplySnapshot");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        DataTree store = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SCHEMA_CONTEXT);
        ContainerNode container = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).addChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1)).build()).build();
        ShardTest.writeToStore(store, TestModel.TEST_PATH, (NormalizedNode)container);
        YangInstanceIdentifier root = YangInstanceIdentifier.of();
        NormalizedNode expected = ShardTest.readStore(store, root);
        Snapshot snapshot = Snapshot.create((Snapshot.State)new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(expected)), Collections.emptyList(), (long)1L, (long)2L, (long)3L, (long)4L, (long)-1L, null, null);
        shard.tell((Object)new ApplySnapshot(snapshot), ActorRef.noSender());
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            Uninterruptibles.sleepUninterruptibly((long)75L, (TimeUnit)TimeUnit.MILLISECONDS);
            try {
                Assert.assertEquals((String)"Root node", (Object)expected, (Object)ShardTest.readStore((TestActorRef<? extends Shard>)shard, root));
                return;
            }
            catch (AssertionError assertionError) {
            }
        }
        Assert.fail((String)"Snapshot was not applied");
    }

    @Test
    public void testApplyState() throws Exception {
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testApplyState");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        DataTree store = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SCHEMA_CONTEXT);
        DataTreeModification writeMod = store.takeSnapshot().newModification();
        ContainerNode node = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        writeMod.write(TestModel.TEST_PATH, (NormalizedNode)node);
        writeMod.ready();
        TransactionIdentifier tx = ShardTest.nextTransactionId();
        ((Shard)shard.underlyingActor()).applyState(null, null, (Object)ShardTest.payloadForModification(store, writeMod, tx));
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            Uninterruptibles.sleepUninterruptibly((long)75L, (TimeUnit)TimeUnit.MILLISECONDS);
            NormalizedNode actual = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.TEST_PATH);
            if (actual == null) continue;
            Assert.assertEquals((String)"Applied state", (Object)node, (Object)actual);
            return;
        }
        Assert.fail((String)"State was not applied");
    }

    @Test
    public void testDataTreeCandidateRecovery() throws Exception {
        DataTree source = this.setupInMemorySnapshotStore();
        DataTreeModification writeMod = source.takeSnapshot().newModification();
        writeMod.write(TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build());
        writeMod.ready();
        InMemoryJournal.addEntry((String)this.shardID.toString(), (long)0L, (Object)DUMMY_DATA);
        InMemoryJournal.addEntry((String)this.shardID.toString(), (long)1L, (Object)new SimpleReplicatedLogEntry(0L, 1L, (Payload)ShardTest.payloadForModification(source, writeMod, ShardTest.nextTransactionId())));
        int nListEntries = 16;
        HashSet<Integer> listEntryKeys = new HashSet<Integer>();
        for (int i = 1; i <= 16; ++i) {
            listEntryKeys.add(i);
            YangInstanceIdentifier path = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)i).build();
            DataTreeModification mod = source.takeSnapshot().newModification();
            mod.merge(path, (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)i));
            mod.ready();
            InMemoryJournal.addEntry((String)this.shardID.toString(), (long)(i + 1), (Object)new SimpleReplicatedLogEntry((long)i, 1L, (Payload)ShardTest.payloadForModification(source, mod, ShardTest.nextTransactionId())));
        }
        InMemoryJournal.addEntry((String)this.shardID.toString(), (long)18L, (Object)new ApplyJournalEntries(16L));
        this.testRecovery(listEntryKeys, true);
    }

    @Test
    public void testConcurrentThreePhaseCommits() throws Exception {
        final AtomicReference caughtEx = new AtomicReference();
        final CountDownLatch commitLatch = new CountDownLatch(2);
        long timeoutSec = 5L;
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        final Timeout timeout = Timeout.create((java.time.Duration)duration);
        final TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testConcurrentThreePhaseCommits");
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        TransactionIdentifier transactionID3 = ShardTest.nextTransactionId();
        Map<TransactionIdentifier, AbstractShardTest.CapturingShardDataTreeCohort> cohortMap = this.setupCohortDecorator((Shard)shard.underlyingActor(), transactionID1, transactionID2, transactionID3);
        AbstractShardTest.CapturingShardDataTreeCohort cohort1 = cohortMap.get(transactionID1);
        AbstractShardTest.CapturingShardDataTreeCohort cohort2 = cohortMap.get(transactionID2);
        AbstractShardTest.CapturingShardDataTreeCohort cohort3 = cohortMap.get(transactionID3);
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false), testKit.getRef());
        ReadyTransactionReply readyReply = ReadyTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, ReadyTransactionReply.class));
        String pathSuffix = shard.path().toString().replaceFirst("akka://test", "");
        MatcherAssert.assertThat((Object)readyReply.getCohortPath(), (Matcher)CoreMatchers.endsWith((String)pathSuffix));
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID2, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build(), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID3, YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)1).build(), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        Future canCommitFuture1 = Patterns.ask((ActorRef)shard, (Object)new CanCommitTransaction(transactionID2, 13).toSerializable(), (Timeout)timeout);
        Future canCommitFuture2 = Patterns.ask((ActorRef)shard, (Object)new CanCommitTransaction(transactionID3, 13).toSerializable(), (Timeout)timeout);
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        class OnCanCommitFutureComplete
        extends 1OnFutureComplete {
            private final TransactionIdentifier transactionID;

            OnCanCommitFutureComplete(TransactionIdentifier transactionID) {
                class OnFutureComplete
                extends OnComplete<Object> {
                    private final Class<?> expRespType;
                    final /* synthetic */ AtomicReference val$caughtEx;
                    final /* synthetic */ ShardTest this$0;

                    OnFutureComplete(Class<?> expRespType) {
                        this.this$0 = this$0;
                        this.val$caughtEx = var3_3;
                        this.expRespType = expRespType;
                    }

                    public void onComplete(Throwable error, Object resp) {
                        if (error != null) {
                            this.val$caughtEx.set(new AssertionError(((Object)((Object)this)).getClass().getSimpleName() + " failure", error));
                        } else {
                            try {
                                Assert.assertEquals((String)"Commit response type", this.expRespType, resp.getClass());
                                this.onSuccess(resp);
                            }
                            catch (Exception e) {
                                this.val$caughtEx.set(e);
                            }
                        }
                    }

                    void onSuccess(Object resp) {
                    }
                }
                super(ShardTest.this, CanCommitTransactionReply.class, atomicReference);
                this.transactionID = transactionID;
            }

            @Override
            void onSuccess(Object resp) {
                CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)resp);
                Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
                Future commitFuture = Patterns.ask((ActorRef)shard, (Object)new CommitTransaction(this.transactionID, 13).toSerializable(), (Timeout)timeout);
                class OnCommitFutureComplete
                extends 1OnFutureComplete {
                    final /* synthetic */ AtomicReference val$caughtEx;
                    final /* synthetic */ CountDownLatch val$commitLatch;

                    OnCommitFutureComplete() {
                        this.val$caughtEx = atomicReference;
                        this.val$commitLatch = countDownLatch;
                        super(ShardTest.this, CommitTransactionReply.class, atomicReference);
                    }

                    @Override
                    public void onComplete(Throwable error, Object resp) {
                        super.onComplete(error, resp);
                        this.val$commitLatch.countDown();
                    }
                }
                commitFuture.onComplete((Function1)new OnCommitFutureComplete(ShardTest.this, caughtEx, commitLatch), (ExecutionContext)AbstractActorTest.getSystem().dispatcher());
            }
        }
        canCommitFuture1.onComplete((Function1)new OnCanCommitFutureComplete(transactionID2), (ExecutionContext)ShardTest.getSystem().dispatcher());
        canCommitFuture2.onComplete((Function1)new OnCanCommitFutureComplete(transactionID3), (ExecutionContext)ShardTest.getSystem().dispatcher());
        boolean done = commitLatch.await(5L, TimeUnit.SECONDS);
        Throwable t = (Throwable)caughtEx.get();
        if (t != null) {
            Throwables.propagateIfPossible((Throwable)t, Exception.class);
            throw new RuntimeException(t);
        }
        Assert.assertTrue((String)"Commits complete", (boolean)done);
        ShardTest.verifyOuterListEntry((TestActorRef<Shard>)shard, 1);
        this.verifyLastApplied((TestActorRef<Shard>)shard, 3L);
    }

    @Test
    public void testBatchedModificationsWithNoCommitOnReady() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testBatchedModificationsWithNoCommitOnReady");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, BatchedModificationsReply.class);
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build(), false, false, 2), testKit.getRef());
        testKit.expectMsgClass(duration, BatchedModificationsReply.class);
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID, YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)1).build(), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1), true, false, 3), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        shard.tell(new CommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        ShardTest.verifyOuterListEntry((TestActorRef<Shard>)shard, 1);
    }

    @Test
    public void testBatchedModificationsWithCommitOnReady() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testBatchedModificationsWithCommitOnReady");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, BatchedModificationsReply.class);
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build(), false, false, 2), testKit.getRef());
        testKit.expectMsgClass(duration, BatchedModificationsReply.class);
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID, YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)1).build(), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1), true, true, 3), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        ShardTest.verifyOuterListEntry((TestActorRef<Shard>)shard, 1);
    }

    @Test(expected=IllegalStateException.class)
    public void testBatchedModificationsReadyWithIncorrectTotalMessageCount() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testBatchedModificationsReadyWithIncorrectTotalMessageCount");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        BatchedModifications batched = new BatchedModifications(transactionID, 13);
        batched.setReady();
        batched.setTotalMessagesSent(2);
        shard.tell((Object)batched, testKit.getRef());
        Status.Failure failure = (Status.Failure)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        if (failure != null) {
            Throwables.propagateIfPossible((Throwable)failure.cause(), Exception.class);
            throw new RuntimeException(failure.cause());
        }
    }

    @Test
    public void testBatchedModificationsWithOperationFailure() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testBatchedModificationsWithOperationFailure");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        ContainerNode invalidData = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.JUNK_QNAME, (Object)"junk")).build();
        BatchedModifications batched = new BatchedModifications(transactionID, 13);
        batched.addModification((Modification)new MergeModification(TestModel.TEST_PATH, (NormalizedNode)invalidData));
        shard.tell((Object)batched, testKit.getRef());
        Status.Failure failure = (Status.Failure)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Throwable cause = failure.cause();
        batched = new BatchedModifications(transactionID, 13);
        batched.setReady();
        batched.setTotalMessagesSent(2);
        shard.tell((Object)batched, testKit.getRef());
        failure = (Status.Failure)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertEquals((String)"Failure cause", (Object)cause, (Object)failure.cause());
    }

    @Test
    public void testBatchedModificationsOnTransactionChain() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testBatchedModificationsOnTransactionChain");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        LocalHistoryIdentifier historyId = ShardTest.nextHistoryId();
        TransactionIdentifier transactionID1 = new TransactionIdentifier(historyId, 0L);
        TransactionIdentifier transactionID2 = new TransactionIdentifier(historyId, 1L);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        ContainerNode containerNode = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, path, (NormalizedNode)containerNode, true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CreateTransaction(transactionID2, TransactionType.READ_ONLY.ordinal(), 13).toSerializable(), testKit.getRef());
        CreateTransactionReply createReply = (CreateTransactionReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(3L), CreateTransactionReply.class);
        ShardTest.getSystem().actorSelection(createReply.getTransactionPath()).tell((Object)new ReadData(path, 13), testKit.getRef());
        ReadDataReply readReply = (ReadDataReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(3L), ReadDataReply.class);
        Assert.assertEquals((String)"Read node", (Object)containerNode, (Object)readReply.getNormalizedNode());
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        NormalizedNode actualNode = ShardTest.readStore((TestActorRef<? extends Shard>)shard, path);
        Assert.assertEquals((String)"Stored node", (Object)containerNode, (Object)actualNode);
    }

    @Test
    public void testOnBatchedModificationsWhenNotLeader() {
        final AtomicBoolean overrideLeaderCalls = new AtomicBoolean();
        final ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        Creator<Shard> creator = new Creator<Shard>(){
            private static final long serialVersionUID = 1L;

            public Shard create() {
                return new Shard((Shard.AbstractBuilder)ShardTest.this.newShardBuilder()){

                    protected boolean isLeader() {
                        return overrideLeaderCalls.get() ? false : super.isLeader();
                    }

                    public ActorSelection getLeader() {
                        return overrideLeaderCalls.get() ? AbstractActorTest.getSystem().actorSelection(testKit.getRef().path()) : super.getLeader();
                    }
                };
            }
        };
        TestActorRef shard = this.actorFactory.createTestActor(Props.create(Shard.class, (Creator)new AbstractShardTest.DelegatingShardCreator(creator)).withDispatcher(Dispatchers.DefaultDispatcherId()), "testOnBatchedModificationsWhenNotLeader");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        overrideLeaderCalls.set(true);
        BatchedModifications batched = new BatchedModifications(ShardTest.nextTransactionId(), 13);
        shard.tell((Object)batched, ActorRef.noSender());
        testKit.expectMsgEquals(batched);
    }

    @Test
    public void testTransactionMessagesWithNoLeader() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        this.dataStoreContextBuilder.customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName()).shardHeartbeatIntervalInMillis(50).shardElectionTimeoutFactor(1L);
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testTransactionMessagesWithNoLeader");
        testKit.waitUntilNoLeader((ActorRef)shard);
        TransactionIdentifier txId = ShardTest.nextTransactionId();
        shard.tell((Object)new BatchedModifications(txId, 13), testKit.getRef());
        Status.Failure failure = (Status.Failure)testKit.expectMsgClass(Status.Failure.class);
        Assert.assertEquals((String)"Failure cause type", NoShardLeaderException.class, failure.cause().getClass());
        shard.tell((Object)ShardTest.prepareForwardedReadyTransaction((TestActorRef<Shard>)shard, txId, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true), testKit.getRef());
        failure = (Status.Failure)testKit.expectMsgClass(Status.Failure.class);
        Assert.assertEquals((String)"Failure cause type", NoShardLeaderException.class, failure.cause().getClass());
        shard.tell((Object)new ReadyLocalTransaction(txId, (DataTreeModification)Mockito.mock(DataTreeModification.class), true, Optional.empty()), testKit.getRef());
        failure = (Status.Failure)testKit.expectMsgClass(Status.Failure.class);
        Assert.assertEquals((String)"Failure cause type", NoShardLeaderException.class, failure.cause().getClass());
    }

    @Test
    public void testReadyWithReadWriteImmediateCommit() {
        this.testReadyWithImmediateCommit(true);
    }

    @Test
    public void testReadyWithWriteOnlyImmediateCommit() {
        this.testReadyWithImmediateCommit(false);
    }

    private void testReadyWithImmediateCommit(boolean readWrite) {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testReadyWithImmediateCommit-" + readWrite);
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        ContainerNode containerNode = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        if (readWrite) {
            shard.tell((Object)ShardTest.prepareForwardedReadyTransaction((TestActorRef<Shard>)shard, transactionID, TestModel.TEST_PATH, (NormalizedNode)containerNode, true), testKit.getRef());
        } else {
            shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID, TestModel.TEST_PATH, (NormalizedNode)containerNode, true), testKit.getRef());
        }
        testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), CommitTransactionReply.class);
        NormalizedNode actualNode = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.TEST_PATH);
        Assert.assertEquals((String)TestModel.TEST_QNAME.getLocalName(), (Object)containerNode, (Object)actualNode);
    }

    @Test
    public void testReadyLocalTransactionWithImmediateCommit() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testReadyLocalTransactionWithImmediateCommit");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        ShardDataTree dataStore = ((Shard)shard.underlyingActor()).getDataStore();
        DataTreeModification modification = dataStore.newModification();
        ContainerNode writeData = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        new WriteModification(TestModel.TEST_PATH, (NormalizedNode)writeData).apply(modification);
        MapNode mergeData = (MapNode)ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).addChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build();
        new MergeModification(TestModel.OUTER_LIST_PATH, (NormalizedNode)mergeData).apply(modification);
        TransactionIdentifier txId = ShardTest.nextTransactionId();
        modification.ready();
        ReadyLocalTransaction readyMessage = new ReadyLocalTransaction(txId, modification, true, Optional.empty());
        shard.tell((Object)readyMessage, testKit.getRef());
        testKit.expectMsgClass(CommitTransactionReply.class);
        NormalizedNode actualNode = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.OUTER_LIST_PATH);
        Assert.assertEquals((String)TestModel.OUTER_LIST_QNAME.getLocalName(), (Object)mergeData, (Object)actualNode);
    }

    @Test
    public void testReadyLocalTransactionWithThreePhaseCommit() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testReadyLocalTransactionWithThreePhaseCommit");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        ShardDataTree dataStore = ((Shard)shard.underlyingActor()).getDataStore();
        DataTreeModification modification = dataStore.newModification();
        ContainerNode writeData = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        new WriteModification(TestModel.TEST_PATH, (NormalizedNode)writeData).apply(modification);
        MapNode mergeData = (MapNode)ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).addChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build();
        new MergeModification(TestModel.OUTER_LIST_PATH, (NormalizedNode)mergeData).apply(modification);
        TransactionIdentifier txId = ShardTest.nextTransactionId();
        modification.ready();
        ReadyLocalTransaction readyMessage = new ReadyLocalTransaction(txId, modification, false, Optional.empty());
        shard.tell((Object)readyMessage, testKit.getRef());
        testKit.expectMsgClass(ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(txId, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        shard.tell(new CommitTransaction(txId, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(CommitTransactionReply.class);
        NormalizedNode actualNode = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.OUTER_LIST_PATH);
        Assert.assertEquals((String)TestModel.OUTER_LIST_QNAME.getLocalName(), (Object)mergeData, (Object)actualNode);
    }

    @Test
    public void testReadWriteCommitWithPersistenceDisabled() {
        this.dataStoreContextBuilder.persistent(false);
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testCommitWithPersistenceDisabled");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        ContainerNode containerNode = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID, TestModel.TEST_PATH, (NormalizedNode)containerNode, false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        shard.tell(new CommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        NormalizedNode actualNode = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.TEST_PATH);
        Assert.assertEquals((String)TestModel.TEST_QNAME.getLocalName(), (Object)containerNode, (Object)actualNode);
    }

    @Test
    public void testReadWriteCommitWhenTransactionHasModifications() throws Exception {
        this.testCommitWhenTransactionHasModifications(true);
    }

    @Test
    public void testWriteOnlyCommitWhenTransactionHasModifications() throws Exception {
        this.testCommitWhenTransactionHasModifications(false);
    }

    private void testCommitWhenTransactionHasModifications(boolean readWrite) throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        DataTree dataTree = this.createDelegatingMockDataTree();
        TestActorRef shard = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().dataTree(dataTree)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testCommitWhenTransactionHasModifications-" + readWrite);
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        if (readWrite) {
            shard.tell((Object)ShardTest.prepareForwardedReadyTransaction((TestActorRef<Shard>)shard, transactionID, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false), testKit.getRef());
        } else {
            shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false), testKit.getRef());
        }
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        shard.tell(new CommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dataTree});
        ((DataTree)inOrder.verify((Object)dataTree)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)inOrder.verify((Object)dataTree)).prepare((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)inOrder.verify((Object)dataTree)).commit((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class));
        Thread.sleep(200L);
        shard.tell(Shard.GET_SHARD_MBEAN_MESSAGE, testKit.getRef());
        ShardStats shardStats = (ShardStats)testKit.expectMsgClass(duration, ShardStats.class);
        Assert.assertEquals((long)1L, (long)shardStats.getCommittedTransactionsCount());
        Assert.assertEquals((long)1L, (long)shardStats.getCommitIndex());
    }

    @Test
    public void testCommitPhaseFailure() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        DataTree dataTree = this.createDelegatingMockDataTree();
        TestActorRef shard = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().dataTree(dataTree)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testCommitPhaseFailure");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        Timeout timeout = Timeout.create((java.time.Duration)duration);
        ((DataTree)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("mock commit failure")}).when((Object)dataTree)).commit((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class));
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        Future canCommitFuture = Patterns.ask((ActorRef)shard, (Object)new CanCommitTransaction(transactionID2, 13).toSerializable(), (Timeout)timeout);
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, Status.Failure.class);
        final CountDownLatch latch = new CountDownLatch(1);
        canCommitFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object resp) {
                latch.countDown();
            }
        }, (ExecutionContext)ShardTest.getSystem().dispatcher());
        Assert.assertTrue((String)"2nd CanCommit complete", (boolean)latch.await(5L, TimeUnit.SECONDS));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dataTree});
        ((DataTree)inOrder.verify((Object)dataTree)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)inOrder.verify((Object)dataTree)).prepare((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)inOrder.verify((Object)dataTree)).commit((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class));
    }

    @Test
    public void testPreCommitPhaseFailure() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        DataTree dataTree = this.createDelegatingMockDataTree();
        TestActorRef shard = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().dataTree(dataTree)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testPreCommitPhaseFailure");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        Timeout timeout = Timeout.create((java.time.Duration)duration);
        ((DataTree)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("mock preCommit failure")}).when((Object)dataTree)).prepare((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        Future canCommitFuture = Patterns.ask((ActorRef)shard, (Object)new CanCommitTransaction(transactionID2, 13).toSerializable(), (Timeout)timeout);
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, Status.Failure.class);
        final CountDownLatch latch = new CountDownLatch(1);
        canCommitFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object resp) {
                latch.countDown();
            }
        }, (ExecutionContext)ShardTest.getSystem().dispatcher());
        Assert.assertTrue((String)"2nd CanCommit complete", (boolean)latch.await(5L, TimeUnit.SECONDS));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dataTree});
        ((DataTree)inOrder.verify((Object)dataTree)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)inOrder.verify((Object)dataTree)).prepare((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)inOrder.verify((Object)dataTree)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
    }

    @Test
    public void testCanCommitPhaseFailure() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        DataTree dataTree = this.createDelegatingMockDataTree();
        TestActorRef shard = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().dataTree(dataTree)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testCanCommitPhaseFailure");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        ((DataTree)Mockito.doThrow((Throwable[])new Throwable[]{new DataValidationFailedException(YangInstanceIdentifier.of(), "mock canCommit failure")}).doNothing().when((Object)dataTree)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, Status.Failure.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID2, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply reply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(CanCommitTransactionReply.class));
        Assert.assertTrue((String)"getCanCommit", (boolean)reply.getCanCommit());
    }

    @Test
    public void testImmediateCommitWithCanCommitPhaseFailure() throws Exception {
        this.testImmediateCommitWithCanCommitPhaseFailure(true);
        this.testImmediateCommitWithCanCommitPhaseFailure(false);
    }

    private void testImmediateCommitWithCanCommitPhaseFailure(boolean readWrite) throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        DataTree dataTree = this.createDelegatingMockDataTree();
        TestActorRef shard = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().dataTree(dataTree)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testImmediateCommitWithCanCommitPhaseFailure-" + readWrite);
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        ((DataTree)Mockito.doThrow((Throwable[])new Throwable[]{new DataValidationFailedException(YangInstanceIdentifier.of(), "mock canCommit failure")}).doNothing().when((Object)dataTree)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        if (readWrite) {
            shard.tell((Object)ShardTest.prepareForwardedReadyTransaction((TestActorRef<Shard>)shard, transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true), testKit.getRef());
        } else {
            shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true), testKit.getRef());
        }
        testKit.expectMsgClass(duration, Status.Failure.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        if (readWrite) {
            shard.tell((Object)ShardTest.prepareForwardedReadyTransaction((TestActorRef<Shard>)shard, transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true), testKit.getRef());
        } else {
            shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true), testKit.getRef());
        }
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
    }

    @Test
    public void testAbortWithCommitPending() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        Creator & Serializable creator = (Creator & Serializable)() -> new Shard((Shard.AbstractBuilder)this.newShardBuilder()){

            void persistPayload(Identifier id, Payload payload, boolean batchHint) {
                this.doAbortTransaction(id, null);
                super.persistPayload(id, payload, batchHint);
            }
        };
        TestActorRef shard = this.actorFactory.createTestActor(Props.create(Shard.class, (Creator)new AbstractShardTest.DelegatingShardCreator((Creator<Shard>)creator)).withDispatcher(Dispatchers.DefaultDispatcherId()), "testAbortWithCommitPending");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
        shard.tell(new CommitTransaction(transactionID, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        NormalizedNode node = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.TEST_PATH);
        Assert.assertNotNull((String)(TestModel.TEST_QNAME.getLocalName() + " not found"), (Object)node);
    }

    @Test
    public void testTransactionCommitTimeout() throws Exception {
        this.dataStoreContextBuilder.shardTransactionCommitTimeoutInSeconds(1);
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testTransactionCommitTimeout");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        this.writeToStore((TestActorRef<Shard>)shard, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        this.writeToStore((TestActorRef<Shard>)shard, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build());
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID1, YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)1).build(), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        YangInstanceIdentifier listNodePath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)2).build();
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID2, listNodePath, (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)2), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID2, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, Status.Failure.class);
        shard.tell(new CommitTransaction(transactionID2, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        NormalizedNode node = ShardTest.readStore((TestActorRef<? extends Shard>)shard, listNodePath);
        Assert.assertNotNull((String)(listNodePath + " not found"), (Object)node);
    }

    @Test
    public void testTransactionCommitWithPriorExpiredCohortEntries() {
        this.dataStoreContextBuilder.shardTransactionCommitTimeoutInSeconds(1);
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testTransactionCommitWithPriorExpiredCohortEntries");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID3 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID3, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID3, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
    }

    @Test
    public void testTransactionCommitWithSubsequentExpiredCohortEntry() {
        this.dataStoreContextBuilder.shardTransactionCommitTimeoutInSeconds(1);
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testTransactionCommitWithSubsequentExpiredCohortEntry");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        ShardDataTree dataStore = ((Shard)shard.underlyingActor()).getDataStore();
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.prepareBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), false), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID3 = ShardTest.nextTransactionId();
        DataTreeModification modification3 = dataStore.newModification();
        new WriteModification(TestModel.TEST2_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST2_QNAME)).apply(modification3);
        modification3.ready();
        ReadyLocalTransaction readyMessage = new ReadyLocalTransaction(transactionID3, modification3, true, Optional.empty());
        shard.tell((Object)readyMessage, testKit.getRef());
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        NormalizedNode node = ShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.TEST2_PATH);
        Assert.assertNotNull((String)(TestModel.TEST2_PATH + " not found"), (Object)node);
    }

    @Test
    public void testCanCommitBeforeReadyFailure() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testCanCommitBeforeReadyFailure");
        shard.tell(new CanCommitTransaction(ShardTest.nextTransactionId(), 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
    }

    @Test
    public void testAbortAfterCanCommit() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testAbortAfterCanCommit");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        Timeout timeout = Timeout.create((java.time.Duration)duration);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        CanCommitTransactionReply canCommitReply = CanCommitTransactionReply.fromSerializable((Object)testKit.expectMsgClass(duration, CanCommitTransactionReply.class));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
        Future canCommitFuture = Patterns.ask((ActorRef)shard, (Object)new CanCommitTransaction(transactionID2, 13).toSerializable(), (Timeout)timeout);
        shard.tell(new AbortTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, AbortTransactionReply.class);
        canCommitReply = (CanCommitTransactionReply)Await.result((Awaitable)canCommitFuture, (Duration)FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertTrue((String)"Can commit", (boolean)canCommitReply.getCanCommit());
    }

    @Test
    public void testAbortAfterReady() {
        this.dataStoreContextBuilder.shardTransactionCommitTimeoutInSeconds(1);
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testAbortAfterReady");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new AbortTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, AbortTransactionReply.class);
        Assert.assertEquals((String)"getPendingTxCommitQueueSize", (long)0L, (long)((Shard)shard.underlyingActor()).getPendingTxCommitQueueSize());
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        Throwable failure = ((Status.Failure)testKit.expectMsgClass(duration, Status.Failure.class)).cause();
        Assert.assertTrue((String)"Failure type", (boolean)(failure instanceof IllegalStateException));
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID2, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
    }

    @Test
    public void testAbortQueuedTransaction() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testAbortAfterReady");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        java.time.Duration duration = java.time.Duration.ofSeconds(5L);
        TransactionIdentifier transactionID1 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID2 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        TransactionIdentifier transactionID3 = ShardTest.nextTransactionId();
        shard.tell((Object)ShardTest.newBatchedModifications(transactionID3, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build(), true, false, 1), testKit.getRef());
        testKit.expectMsgClass(duration, ReadyTransactionReply.class);
        shard.tell(new AbortTransaction(transactionID2, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, AbortTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
        shard.tell(new CommitTransaction(transactionID1, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        shard.tell(new CanCommitTransaction(transactionID3, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CanCommitTransactionReply.class);
        shard.tell(new CommitTransaction(transactionID3, 13).toSerializable(), testKit.getRef());
        testKit.expectMsgClass(duration, CommitTransactionReply.class);
        Assert.assertEquals((String)"getPendingTxCommitQueueSize", (long)0L, (long)((Shard)shard.underlyingActor()).getPendingTxCommitQueueSize());
    }

    @Test
    public void testCreateSnapshotWithNonPersistentData() throws Exception {
        this.testCreateSnapshot(false, "testCreateSnapshotWithNonPersistentData");
    }

    @Test
    public void testCreateSnapshot() throws Exception {
        this.testCreateSnapshot(true, "testCreateSnapshot");
    }

    private void testCreateSnapshot(boolean persistent, String shardActorName) throws Exception {
        final class TestShard
        extends Shard {
            TestShard(Shard.AbstractBuilder<?, ?> builder) {
                super(builder);
                class TestPersistentDataProvider
                extends DelegatingPersistentDataProvider {
                    final /* synthetic */ AtomicReference val$savedSnapshot;

                    TestPersistentDataProvider(DataPersistenceProvider delegate) {
                        this.val$savedSnapshot = atomicReference;
                        super(delegate);
                    }

                    public void saveSnapshot(Object obj) {
                        this.val$savedSnapshot.set(obj);
                        super.saveSnapshot(obj);
                    }
                }
                this.setPersistence((DataPersistenceProvider)new TestPersistentDataProvider((ShardTest)this$0, super.persistence(), savedSnapshot));
            }

            public void handleCommand(Object message) {
                super.handleCommand(message);
                if (message instanceof SaveSnapshotSuccess || "commit_snapshot".equals(message.toString())) {
                    ((CountDownLatch)latch.get()).countDown();
                }
            }

            public RaftActorContext getRaftActorContext() {
                return super.getRaftActorContext();
            }
        }
        final AtomicReference<CountDownLatch> latch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        final AtomicReference<Object> savedSnapshot = new AtomicReference<Object>();
        this.dataStoreContextBuilder.persistent(persistent);
        Creator & Serializable creator = (Creator & Serializable)() -> new TestShard((Shard.AbstractBuilder)this.newShardBuilder());
        TestActorRef shard = this.actorFactory.createTestActor(Props.create(Shard.class, (Creator)new AbstractShardTest.DelegatingShardCreator((Creator<Shard>)creator)).withDispatcher(Dispatchers.DefaultDispatcherId()), shardActorName);
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        this.writeToStore((TestActorRef<Shard>)shard, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        NormalizedNode expectedRoot = ShardTest.readStore((TestActorRef<? extends Shard>)shard, YangInstanceIdentifier.of());
        RaftActorContext raftActorContext = ((TestShard)shard.underlyingActor()).getRaftActorContext();
        raftActorContext.getSnapshotManager().capture((ReplicatedLogEntry)Mockito.mock(ReplicatedLogEntry.class), -1L);
        ShardTest.awaitAndValidateSnapshot(latch, savedSnapshot, expectedRoot);
        raftActorContext.getSnapshotManager().capture((ReplicatedLogEntry)Mockito.mock(ReplicatedLogEntry.class), -1L);
        ShardTest.awaitAndValidateSnapshot(latch, savedSnapshot, expectedRoot);
    }

    private static void awaitAndValidateSnapshot(AtomicReference<CountDownLatch> latch, AtomicReference<Object> savedSnapshot, NormalizedNode expectedRoot) throws InterruptedException {
        Assert.assertTrue((String)"Snapshot saved", (boolean)latch.get().await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("Invalid saved snapshot " + savedSnapshot.get()), (boolean)(savedSnapshot.get() instanceof Snapshot));
        ShardTest.verifySnapshot((Snapshot)savedSnapshot.get(), expectedRoot);
        latch.set(new CountDownLatch(1));
        savedSnapshot.set(null);
    }

    private static void verifySnapshot(Snapshot snapshot, NormalizedNode expectedRoot) {
        Assert.assertEquals((String)"Root node", (Object)expectedRoot, ((ShardSnapshotState)snapshot.getState()).getSnapshot().getRootNode().orElseThrow());
    }

    @Test
    public void testInMemoryDataTreeRestore() throws DataValidationFailedException {
        DataTree store = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SCHEMA_CONTEXT);
        DataTreeModification putTransaction = store.takeSnapshot().newModification();
        putTransaction.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        ShardTest.commitTransaction(store, putTransaction);
        NormalizedNode expected = ShardTest.readStore(store, YangInstanceIdentifier.of());
        DataTreeModification writeTransaction = store.takeSnapshot().newModification();
        writeTransaction.delete(YangInstanceIdentifier.of());
        writeTransaction.write(YangInstanceIdentifier.of(), expected);
        ShardTest.commitTransaction(store, writeTransaction);
        NormalizedNode actual = ShardTest.readStore(store, YangInstanceIdentifier.of());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRecoveryApplicable() {
        DatastoreContext persistentContext = DatastoreContext.newBuilder().shardJournalRecoveryLogBatchSize(3).shardSnapshotBatchCount(5000).persistent(true).build();
        Props persistentProps = ((Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(this.shardID)).datastoreContext(persistentContext)).schemaContextProvider(() -> SCHEMA_CONTEXT)).props();
        DatastoreContext nonPersistentContext = DatastoreContext.newBuilder().shardJournalRecoveryLogBatchSize(3).shardSnapshotBatchCount(5000).persistent(false).build();
        Props nonPersistentProps = ((Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(this.shardID)).datastoreContext(nonPersistentContext)).schemaContextProvider(() -> SCHEMA_CONTEXT)).props();
        TestActorRef shard1 = this.actorFactory.createTestActor(persistentProps, "testPersistence1");
        Assert.assertTrue((String)"Recovery Applicable", (boolean)((Shard)shard1.underlyingActor()).persistence().isRecoveryApplicable());
        TestActorRef shard2 = this.actorFactory.createTestActor(nonPersistentProps, "testPersistence2");
        Assert.assertFalse((String)"Recovery Not Applicable", (boolean)((Shard)shard2.underlyingActor()).persistence().isRecoveryApplicable());
    }

    @Test
    public void testOnDatastoreContext() {
        this.dataStoreContextBuilder.persistent(true);
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps(), "testOnDatastoreContext");
        Assert.assertTrue((String)"isRecoveryApplicable", (boolean)((Shard)shard.underlyingActor()).persistence().isRecoveryApplicable());
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        shard.tell((Object)this.dataStoreContextBuilder.persistent(false).build(), ActorRef.noSender());
        Assert.assertFalse((String)"isRecoveryApplicable", (boolean)((Shard)shard.underlyingActor()).persistence().isRecoveryApplicable());
        shard.tell((Object)this.dataStoreContextBuilder.persistent(true).build(), ActorRef.noSender());
        Assert.assertTrue((String)"isRecoveryApplicable", (boolean)((Shard)shard.underlyingActor()).persistence().isRecoveryApplicable());
    }

    @Test
    public void testRegisterRoleChangeListener() {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testRegisterRoleChangeListener");
        ShardTestKit.waitUntilLeader((ActorRef)shard);
        ActorRef listener = ShardTest.getSystem().actorOf(MessageCollectorActor.props());
        shard.tell((Object)new RegisterRoleChangeListener(), listener);
        MessageCollectorActor.expectFirstMatching((ActorRef)listener, RegisterRoleChangeListenerReply.class);
        ShardLeaderStateChanged leaderStateChanged = (ShardLeaderStateChanged)MessageCollectorActor.expectFirstMatching((ActorRef)listener, ShardLeaderStateChanged.class);
        Assert.assertTrue((String)"getLocalShardDataTree present", (boolean)leaderStateChanged.getLocalShardDataTree().isPresent());
        Assert.assertSame((String)"getLocalShardDataTree", (Object)((Shard)shard.underlyingActor()).getDataStore().getDataTree(), leaderStateChanged.getLocalShardDataTree().orElseThrow());
        MessageCollectorActor.clearMessages((ActorRef)listener);
        shard.tell((Object)new RequestVote(10000L, "member2", 50L, 50L), testKit.getRef());
        leaderStateChanged = (ShardLeaderStateChanged)MessageCollectorActor.expectFirstMatching((ActorRef)listener, ShardLeaderStateChanged.class);
        Assert.assertFalse((String)"getLocalShardDataTree present", (boolean)leaderStateChanged.getLocalShardDataTree().isPresent());
    }

    @Test
    public void testFollowerInitialSyncStatus() {
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardProps().withDispatcher(Dispatchers.DefaultDispatcherId()), "testFollowerInitialSyncStatus");
        ((Shard)shard.underlyingActor()).handleNonRaftCommand((Object)new FollowerInitialSyncUpStatus(false, "member-1-shard-inventory-operational"));
        Assert.assertFalse((boolean)((Shard)shard.underlyingActor()).getShardMBean().getFollowerInitialSyncStatus());
        ((Shard)shard.underlyingActor()).handleNonRaftCommand((Object)new FollowerInitialSyncUpStatus(true, "member-1-shard-inventory-operational"));
        Assert.assertTrue((boolean)((Shard)shard.underlyingActor()).getShardMBean().getFollowerInitialSyncStatus());
    }

    @Test
    public void testClusteredDataTreeChangeListenerWithDelayedRegistration() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        String testName = "testClusteredDataTreeChangeListenerWithDelayedRegistration";
        this.dataStoreContextBuilder.shardElectionTimeoutFactor(1000L).customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName());
        MockDataTreeChangeListener listener = new MockDataTreeChangeListener(1);
        ActorRef dclActor = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener, (YangInstanceIdentifier)TestModel.TEST_PATH), this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerWithDelayedRegistration-DataTreeChangeListener"));
        this.setupInMemorySnapshotStore();
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardBuilder().props().withDispatcher(Dispatchers.DefaultDispatcherId()), this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerWithDelayedRegistration-shard"));
        testKit.waitUntilNoLeader((ActorRef)shard);
        shard.tell((Object)new RegisterDataTreeChangeListener(TestModel.TEST_PATH, dclActor, true), testKit.getRef());
        RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), RegisterDataTreeNotificationListenerReply.class);
        Assert.assertNotNull((String)"getListenerRegistrationPath", (Object)reply.getListenerRegistrationPath());
        shard.tell((Object)DatastoreContext.newBuilderFrom((DatastoreContext)this.dataStoreContextBuilder.build()).customRaftPolicyImplementation(null).build(), ActorRef.noSender());
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
    }

    @Test
    public void testClusteredDataTreeChangeListenerWithDelayedRegistrationClosed() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        String testName = "testClusteredDataTreeChangeListenerWithDelayedRegistrationClosed";
        this.dataStoreContextBuilder.shardElectionTimeoutFactor(1000L).customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName());
        MockDataTreeChangeListener listener = new MockDataTreeChangeListener(0);
        ActorRef dclActor = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener, (YangInstanceIdentifier)TestModel.TEST_PATH), this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerWithDelayedRegistrationClosed-DataTreeChangeListener"));
        this.setupInMemorySnapshotStore();
        TestActorRef shard = this.actorFactory.createTestActor(this.newShardBuilder().props().withDispatcher(Dispatchers.DefaultDispatcherId()), this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerWithDelayedRegistrationClosed-shard"));
        testKit.waitUntilNoLeader((ActorRef)shard);
        shard.tell((Object)new RegisterDataTreeChangeListener(TestModel.TEST_PATH, dclActor, true), testKit.getRef());
        RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), RegisterDataTreeNotificationListenerReply.class);
        Assert.assertNotNull((String)"getListenerRegistrationPath", (Object)reply.getListenerRegistrationPath());
        ActorSelection regActor = ShardTest.getSystem().actorSelection(reply.getListenerRegistrationPath());
        regActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), testKit.getRef());
        testKit.expectMsgClass(CloseDataTreeNotificationListenerRegistrationReply.class);
        shard.tell((Object)DatastoreContext.newBuilderFrom((DatastoreContext)this.dataStoreContextBuilder.build()).customRaftPolicyImplementation(null).build(), ActorRef.noSender());
        listener.expectNoMoreChanges("Received unexpected change after close");
    }

    @Test
    public void testClusteredDataTreeChangeListenerRegistration() throws Exception {
        ShardTestKit testKit = new ShardTestKit(ShardTest.getSystem());
        String testName = "testClusteredDataTreeChangeListenerRegistration";
        ShardIdentifier followerShardID = ShardIdentifier.create((String)"inventory", (MemberName)MemberName.forName((String)this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerRegistration-follower")), (String)"config");
        ShardIdentifier leaderShardID = ShardIdentifier.create((String)"inventory", (MemberName)MemberName.forName((String)this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerRegistration-leader")), (String)"config");
        TestActorRef followerShard = this.actorFactory.createTestActor(((Shard.Builder)((Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(followerShardID)).datastoreContext(this.dataStoreContextBuilder.shardElectionTimeoutFactor(1000L).build())).peerAddresses(Collections.singletonMap(leaderShardID.toString(), "akka://test/user/" + leaderShardID.toString()))).schemaContextProvider(() -> SCHEMA_CONTEXT)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), followerShardID.toString());
        TestActorRef leaderShard = this.actorFactory.createTestActor(((Shard.Builder)((Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(leaderShardID)).datastoreContext(this.newDatastoreContext())).peerAddresses(Collections.singletonMap(followerShardID.toString(), "akka://test/user/" + followerShardID.toString()))).schemaContextProvider(() -> SCHEMA_CONTEXT)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), leaderShardID.toString());
        leaderShard.tell((Object)TimeoutNow.INSTANCE, ActorRef.noSender());
        String leaderPath = ShardTestKit.waitUntilLeader((ActorRef)followerShard);
        Assert.assertEquals((String)"Shard leader path", (Object)leaderShard.path().toString(), (Object)leaderPath);
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        MockDataTreeChangeListener listener = new MockDataTreeChangeListener(1);
        ActorRef dclActor = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener, (YangInstanceIdentifier)path), this.actorFactory.generateActorId("testClusteredDataTreeChangeListenerRegistration-DataTreeChangeListener"));
        followerShard.tell((Object)new RegisterDataTreeChangeListener(TestModel.TEST_PATH, dclActor, true), testKit.getRef());
        RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), RegisterDataTreeNotificationListenerReply.class);
        Assert.assertNotNull((String)"getListenerRegistrationPath", (Object)reply.getListenerRegistrationPath());
        this.writeToStore((TestActorRef<Shard>)followerShard, path, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
    }

    @Test
    public void testServerRemoved() {
        TestActorRef parent = this.actorFactory.createTestActor(MessageCollectorActor.props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ActorRef shard = ((MessageCollectorActor)parent.underlyingActor()).context().actorOf(this.newShardBuilder().props().withDispatcher(Dispatchers.DefaultDispatcherId()), "testServerRemoved");
        shard.tell((Object)new ServerRemoved("test"), ActorRef.noSender());
        MessageCollectorActor.expectFirstMatching((ActorRef)parent, ServerRemoved.class);
    }
}

