/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.pattern.Patterns;
import akka.testkit.TestActorRef;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.ShardTestKit;
import org.opendaylight.controller.cluster.datastore.ShardTransaction;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ShardTransactionFailureTest
extends AbstractActorTest {
    private static final EffectiveModelContext TEST_SCHEMA_CONTEXT = TestModel.createTestContext();
    private static final TransactionType RO = TransactionType.READ_ONLY;
    private static final TransactionType RW = TransactionType.READ_WRITE;
    private static final Shard MOCK_SHARD = (Shard)Mockito.mock(Shard.class);
    private static final ShardDataTree STORE = new ShardDataTree(MOCK_SHARD, TEST_SCHEMA_CONTEXT, TreeType.OPERATIONAL);
    private static final ShardIdentifier SHARD_IDENTIFIER = ShardIdentifier.create((String)"inventory", (MemberName)MemberName.forName((String)"member-1"), (String)"operational");
    private final DatastoreContext datastoreContext = DatastoreContext.newBuilder().build();
    private final ShardStats shardStats = new ShardStats(SHARD_IDENTIFIER.toString(), "DataStore", null);

    private ActorRef createShard() {
        ActorRef shard = ShardTransactionFailureTest.getSystem().actorOf(((Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(SHARD_IDENTIFIER)).datastoreContext(this.datastoreContext)).schemaContextProvider(() -> TEST_SCHEMA_CONTEXT)).props());
        ShardTestKit.waitUntilLeader(shard);
        return shard;
    }

    @Before
    public void setup() {
        ((Shard)Mockito.doReturn((Object)new ShardStats("inventory", "mxBeanType", MOCK_SHARD)).when((Object)MOCK_SHARD)).getShardMBean();
    }

    @Test(expected=ReadFailedException.class)
    public void testNegativeReadWithReadOnlyTransactionClosed() throws Exception {
        ActorRef shard = this.createShard();
        Props props = ShardTransaction.props((TransactionType)RO, (AbstractShardDataTreeTransaction)STORE.newReadOnlyTransaction(ShardTransactionFailureTest.nextTransactionId()), (ActorRef)shard, (DatastoreContext)this.datastoreContext, (ShardStats)this.shardStats);
        TestActorRef subject = TestActorRef.create((ActorSystem)ShardTransactionFailureTest.getSystem(), (Props)props, (String)"testNegativeReadWithReadOnlyTransactionClosed");
        Future future = Patterns.ask((ActorRef)subject, (Object)new ReadData(YangInstanceIdentifier.of(), 13), (long)3000L);
        Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
        ((ShardTransaction)subject.underlyingActor()).getDOMStoreTransaction().abortFromTransactionActor();
        future = Patterns.ask((ActorRef)subject, (Object)new ReadData(YangInstanceIdentifier.of(), 13), (long)3000L);
        Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Test(expected=ReadFailedException.class)
    public void testNegativeReadWithReadWriteTransactionClosed() throws Exception {
        ActorRef shard = this.createShard();
        Props props = ShardTransaction.props((TransactionType)RW, (AbstractShardDataTreeTransaction)STORE.newReadWriteTransaction(ShardTransactionFailureTest.nextTransactionId()), (ActorRef)shard, (DatastoreContext)this.datastoreContext, (ShardStats)this.shardStats);
        TestActorRef subject = TestActorRef.create((ActorSystem)ShardTransactionFailureTest.getSystem(), (Props)props, (String)"testNegativeReadWithReadWriteTransactionClosed");
        Future future = Patterns.ask((ActorRef)subject, (Object)new ReadData(YangInstanceIdentifier.of(), 13), (long)3000L);
        Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
        ((ShardTransaction)subject.underlyingActor()).getDOMStoreTransaction().abortFromTransactionActor();
        future = Patterns.ask((ActorRef)subject, (Object)new ReadData(YangInstanceIdentifier.of(), 13), (long)3000L);
        Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Test(expected=ReadFailedException.class)
    public void testNegativeExistsWithReadWriteTransactionClosed() throws Exception {
        ActorRef shard = this.createShard();
        Props props = ShardTransaction.props((TransactionType)RW, (AbstractShardDataTreeTransaction)STORE.newReadWriteTransaction(ShardTransactionFailureTest.nextTransactionId()), (ActorRef)shard, (DatastoreContext)this.datastoreContext, (ShardStats)this.shardStats);
        TestActorRef subject = TestActorRef.create((ActorSystem)ShardTransactionFailureTest.getSystem(), (Props)props, (String)"testNegativeExistsWithReadWriteTransactionClosed");
        Future future = Patterns.ask((ActorRef)subject, (Object)new DataExists(YangInstanceIdentifier.of(), 13), (long)3000L);
        Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
        ((ShardTransaction)subject.underlyingActor()).getDOMStoreTransaction().abortFromTransactionActor();
        future = Patterns.ask((ActorRef)subject, (Object)new DataExists(YangInstanceIdentifier.of(), 13), (long)3000L);
        Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
    }
}

