/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.CompositeDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.SimpleShardDataTreeCohort;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class SimpleShardDataTreeCohortTest
extends AbstractTest {
    @Mock
    private ShardDataTree mockShardDataTree;
    @Mock
    private DataTreeModification mockModification;
    @Mock
    private CompositeDataTreeCohort mockUserCohorts;
    @Mock
    private FutureCallback<DataTreeCandidate> mockPreCallback;
    private SimpleShardDataTreeCohort cohort;

    @Before
    public void setup() {
        ((CompositeDataTreeCohort)Mockito.doReturn(Optional.empty()).when((Object)this.mockUserCohorts)).commit();
        ((CompositeDataTreeCohort)Mockito.doReturn(Optional.empty()).when((Object)this.mockUserCohorts)).abort();
        this.cohort = new SimpleShardDataTreeCohort(this.mockShardDataTree, this.mockModification, SimpleShardDataTreeCohortTest.nextTransactionId(), this.mockUserCohorts, Optional.empty());
    }

    @Test
    public void testCanCommitSuccess() {
        this.canCommitSuccess();
    }

    private void canCommitSuccess() {
        ((ShardDataTree)Mockito.doAnswer(invocation -> {
            ((SimpleShardDataTreeCohort)invocation.getArgument(0)).successfulCanCommit();
            return null;
        }).when((Object)this.mockShardDataTree)).startCanCommit(this.cohort);
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.canCommit(callback);
        ((FutureCallback)Mockito.verify((Object)callback)).onSuccess((Object)Empty.value());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    private void testValidatationPropagates(Exception cause) {
        ((ShardDataTree)Mockito.doAnswer(invocation -> {
            ((SimpleShardDataTreeCohort)invocation.getArgument(0)).failedCanCommit(cause);
            return null;
        }).when((Object)this.mockShardDataTree)).startCanCommit(this.cohort);
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.canCommit(callback);
        ((FutureCallback)Mockito.verify((Object)callback)).onFailure((Throwable)cause);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void testCanCommitWithConflictingModEx() {
        this.testValidatationPropagates((Exception)new ConflictingModificationAppliedException(YangInstanceIdentifier.of(), "mock"));
    }

    @Test
    public void testCanCommitWithDataValidationEx() {
        this.testValidatationPropagates((Exception)((Object)new DataValidationFailedException(YangInstanceIdentifier.of(), "mock")));
    }

    @Test
    public void testCanCommitWithIllegalArgumentEx() {
        this.testValidatationPropagates(new IllegalArgumentException("mock"));
    }

    private DataTreeCandidateTip preCommitSuccess() {
        DataTreeCandidateTip mockCandidate = (DataTreeCandidateTip)Mockito.mock(DataTreeCandidateTip.class);
        ((ShardDataTree)Mockito.doAnswer(invocation -> {
            ((SimpleShardDataTreeCohort)invocation.getArgument(0)).successfulPreCommit(mockCandidate);
            return null;
        }).when((Object)this.mockShardDataTree)).startPreCommit(this.cohort);
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.preCommit(callback);
        ((FutureCallback)Mockito.verify((Object)callback)).onSuccess((Object)mockCandidate);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        Assert.assertSame((String)"getCandidate", (Object)mockCandidate, (Object)this.cohort.getCandidate());
        return mockCandidate;
    }

    @Test
    public void testPreCommitAndCommitSuccess() {
        this.canCommitSuccess();
        DataTreeCandidateTip candidate = this.preCommitSuccess();
        ((ShardDataTree)Mockito.doAnswer(invocation -> {
            ((SimpleShardDataTreeCohort)invocation.getArgument(0)).successfulCommit(UnsignedLong.valueOf((long)0L), () -> {});
            return null;
        }).when((Object)this.mockShardDataTree)).startCommit(this.cohort, (DataTreeCandidate)candidate);
        FutureCallback mockCommitCallback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.commit(mockCommitCallback);
        ((FutureCallback)Mockito.verify((Object)mockCommitCallback)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockCommitCallback});
        ((CompositeDataTreeCohort)Mockito.verify((Object)this.mockUserCohorts)).commit();
    }

    @Test
    public void testPreCommitWithIllegalArgumentEx() {
        this.canCommitSuccess();
        IllegalArgumentException cause = new IllegalArgumentException("mock");
        ((ShardDataTree)Mockito.doAnswer(invocation -> {
            ((SimpleShardDataTreeCohort)invocation.getArgument(0)).failedPreCommit((Throwable)cause);
            return null;
        }).when((Object)this.mockShardDataTree)).startPreCommit(this.cohort);
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.preCommit(callback);
        ((FutureCallback)Mockito.verify((Object)callback)).onFailure((Throwable)cause);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        ((CompositeDataTreeCohort)Mockito.verify((Object)this.mockUserCohorts)).abort();
    }

    @Test
    public void testPreCommitWithReportedFailure() {
        this.canCommitSuccess();
        IllegalArgumentException cause = new IllegalArgumentException("mock");
        this.cohort.reportFailure((Exception)cause);
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.preCommit(callback);
        ((FutureCallback)Mockito.verify((Object)callback)).onFailure((Throwable)cause);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        ((ShardDataTree)Mockito.verify((Object)this.mockShardDataTree, (VerificationMode)Mockito.never())).startPreCommit(this.cohort);
    }

    @Test
    public void testCommitWithIllegalArgumentEx() {
        this.canCommitSuccess();
        DataTreeCandidateTip candidate = this.preCommitSuccess();
        IllegalArgumentException cause = new IllegalArgumentException("mock");
        ((ShardDataTree)Mockito.doAnswer(invocation -> {
            ((SimpleShardDataTreeCohort)invocation.getArgument(0)).failedCommit(cause);
            return null;
        }).when((Object)this.mockShardDataTree)).startCommit(this.cohort, (DataTreeCandidate)candidate);
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.cohort.commit(callback);
        ((FutureCallback)Mockito.verify((Object)callback)).onFailure((Throwable)cause);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        ((CompositeDataTreeCohort)Mockito.verify((Object)this.mockUserCohorts)).abort();
    }

    private static Future<?> abort(ShardDataTreeCohort cohort) {
        final CompletableFuture f = new CompletableFuture();
        cohort.abort((FutureCallback)new FutureCallback<Empty>(){

            public void onSuccess(Empty result) {
                f.complete(result);
            }

            public void onFailure(Throwable failure) {
                f.completeExceptionally(failure);
            }
        });
        return f;
    }

    @Test
    public void testAbort() throws Exception {
        ((ShardDataTree)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.mockShardDataTree)).startAbort(this.cohort);
        SimpleShardDataTreeCohortTest.abort((ShardDataTreeCohort)this.cohort).get();
        ((ShardDataTree)Mockito.verify((Object)this.mockShardDataTree)).startAbort(this.cohort);
    }

    @Test
    public void testAbortWithCohorts() throws Exception {
        ((ShardDataTree)Mockito.doReturn((Object)true).when((Object)this.mockShardDataTree)).startAbort(this.cohort);
        ((CompositeDataTreeCohort)Mockito.doReturn(Optional.of(CompletableFuture.completedFuture(null))).when((Object)this.mockUserCohorts)).abort();
        Future<?> abortFuture = SimpleShardDataTreeCohortTest.abort((ShardDataTreeCohort)this.cohort);
        abortFuture.get();
        ((ShardDataTree)Mockito.verify((Object)this.mockShardDataTree)).startAbort(this.cohort);
    }
}

