/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransaction;

public class CreateTransactionTest
extends AbstractTest {
    @Test
    public void testSerialization() {
        CreateTransaction expected = new CreateTransaction(CreateTransactionTest.nextTransactionId(), 2, 13);
        Object serialized = expected.toSerializable();
        Assert.assertEquals((String)"Serialized type", CreateTransaction.class, serialized.getClass());
        CreateTransaction actual = CreateTransaction.fromSerializable((Object)SerializationUtils.clone((Serializable)((Serializable)serialized)));
        Assert.assertEquals((String)"getTransactionId", (Object)expected.getTransactionId(), (Object)actual.getTransactionId());
        Assert.assertEquals((String)"getTransactionType", (long)expected.getTransactionType(), (long)actual.getTransactionType());
        Assert.assertEquals((String)"getVersion", (long)13L, (long)actual.getVersion());
    }

    @Test
    public void testSerializationWithNewerVersion() {
        short newerVersion = 14;
        CreateTransaction expected = new CreateTransaction(CreateTransactionTest.nextTransactionId(), 2, newerVersion);
        Object serialized = expected.toSerializable();
        Assert.assertEquals((String)"Serialized type", CreateTransaction.class, serialized.getClass());
        CreateTransaction actual = CreateTransaction.fromSerializable((Object)SerializationUtils.clone((Serializable)((Serializable)serialized)));
        Assert.assertEquals((String)"getTransactionId", (Object)expected.getTransactionId(), (Object)actual.getTransactionId());
        Assert.assertEquals((String)"getTransactionType", (long)expected.getTransactionType(), (long)actual.getTransactionType());
        Assert.assertEquals((String)"getVersion", (long)13L, (long)actual.getVersion());
    }

    @Test
    public void testIsSerializedType() {
        Assert.assertTrue((String)"isSerializedType", (boolean)CreateTransaction.isSerializedType((Object)new CreateTransaction()));
        Assert.assertFalse((String)"isSerializedType", (boolean)CreateTransaction.isSerializedType((Object)new Object()));
    }
}

